/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.netty.http.client.handler;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2EventAdapter;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.HttpConversionUtil;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xbib.netty.http.client.HttpClientChannelContextDefaults;
import org.xbib.netty.http.client.HttpRequestContext;

public class Http2EventHandler
extends Http2EventAdapter {
    private static final Logger logger = Logger.getLogger(Http2EventHandler.class.getName());
    private final Http2Connection connection;
    private final Http2Connection.PropertyKey messageKey;
    private final int maxContentLength;
    private final boolean validateHttpHeaders;

    public Http2EventHandler(Http2Connection connection, int maxContentLength, boolean validateHeaders) {
        this.connection = connection;
        this.maxContentLength = maxContentLength;
        this.validateHttpHeaders = validateHeaders;
        this.messageKey = connection.newKey();
    }

    public void onSettingsRead(ChannelHandlerContext ctx, Http2Settings settings) throws Http2Exception {
        logger.log(Level.FINEST, () -> "settings received " + settings);
        Channel channel = ctx.channel();
        HttpRequestContext httpRequestContext = (HttpRequestContext)channel.attr(HttpClientChannelContextDefaults.REQUEST_CONTEXT_ATTRIBUTE_KEY).get();
        HttpRequest httpRequest = httpRequestContext.getHttpRequest();
        ChannelPromise channelPromise = channel.newPromise();
        Http2Headers headers = Http2EventHandler.toHttp2Headers(httpRequestContext);
        logger.log(Level.FINEST, () -> "write request " + httpRequest + " headers = " + headers);
        boolean hasBody = httpRequestContext.getHttpRequest() instanceof FullHttpRequest;
        Http2ConnectionHandler handler = (Http2ConnectionHandler)ctx.pipeline().get(Http2ConnectionHandler.class);
        Integer streamId = httpRequestContext.getStreamId().get();
        ChannelFuture channelFuture = handler.encoder().writeHeaders(ctx, streamId.intValue(), headers, 0, !hasBody, channelPromise);
        httpRequestContext.putStreamID(streamId, channelFuture, channelPromise);
        if (hasBody) {
            FullHttpRequest fullHttpRequest = (FullHttpRequest)httpRequestContext.getHttpRequest();
            ChannelPromise contentChannelPromise = channel.newPromise();
            streamId = httpRequestContext.getStreamId().get();
            ChannelFuture contentChannelFuture = handler.encoder().writeData(ctx, streamId.intValue(), fullHttpRequest.content(), 0, true, contentChannelPromise);
            httpRequestContext.putStreamID(streamId, contentChannelFuture, contentChannelPromise);
            channel.flush();
        }
        httpRequestContext.getSettingsPromise().setSuccess();
    }

    public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int padding, boolean endOfStream) throws Http2Exception {
        logger.log(Level.FINEST, () -> "headers received " + headers);
        Http2Stream stream = this.connection.stream(streamId);
        FullHttpMessage msg = this.beginHeader(ctx, stream, headers, true, true);
        if (msg != null) {
            this.endHeader(ctx, stream, msg, endOfStream);
        }
    }

    public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endOfStream) throws Http2Exception {
        logger.log(Level.FINEST, () -> "headers received " + headers);
        Http2Stream stream = this.connection.stream(streamId);
        FullHttpMessage msg = this.beginHeader(ctx, stream, headers, true, true);
        if (msg != null) {
            if (streamDependency != 0) {
                msg.headers().setInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_DEPENDENCY_ID.text(), streamDependency);
            }
            msg.headers().setShort((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_WEIGHT.text(), weight);
            this.endHeader(ctx, stream, msg, endOfStream);
        }
    }

    public int onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream) throws Http2Exception {
        logger.log(Level.FINEST, () -> "data received " + data);
        Http2Stream stream = this.connection.stream(streamId);
        FullHttpMessage msg = this.getMessage(stream);
        if (msg == null) {
            throw Http2Exception.connectionError((Http2Error)Http2Error.PROTOCOL_ERROR, (String)"data frame received for unknown stream id %d", (Object[])new Object[]{streamId});
        }
        ByteBuf content = msg.content();
        int dataReadableBytes = data.readableBytes();
        if (content.readableBytes() > this.maxContentLength - dataReadableBytes) {
            throw Http2Exception.connectionError((Http2Error)Http2Error.INTERNAL_ERROR, (String)"content length exceeded maximum of %d for stream id %d", (Object[])new Object[]{this.maxContentLength, streamId});
        }
        content.writeBytes(data, data.readerIndex(), dataReadableBytes);
        if (endOfStream) {
            this.fireChannelRead(ctx, msg, false, stream);
        }
        return dataReadableBytes + padding;
    }

    public void onRstStreamRead(ChannelHandlerContext ctx, int streamId, long errorCode) throws Http2Exception {
        logger.log(Level.FINEST, () -> "rst stream received: error code = " + errorCode);
        Http2Stream stream = this.connection.stream(streamId);
        FullHttpMessage msg = this.getMessage(stream);
        if (msg != null) {
            this.removeMessage(stream, true);
        }
        HttpRequestContext httpRequestContext = (HttpRequestContext)ctx.channel().attr(HttpClientChannelContextDefaults.REQUEST_CONTEXT_ATTRIBUTE_KEY).get();
        httpRequestContext.getPushMap().remove(streamId);
    }

    public void onPushPromiseRead(ChannelHandlerContext ctx, int streamId, int promisedStreamId, Http2Headers headers, int padding) throws Http2Exception {
        logger.log(Level.FINEST, () -> "push promise received: streamId " + streamId + " promised stream ID = " + promisedStreamId + " headers =" + headers);
        Http2Stream promisedStream = this.connection.stream(promisedStreamId);
        FullHttpMessage msg = this.beginHeader(ctx, promisedStream, headers, false, false);
        if (msg != null) {
            msg.headers().setInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_PROMISE_ID.text(), streamId);
            msg.headers().setShort((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_WEIGHT.text(), (short)16);
            this.endHeader(ctx, promisedStream, msg, false);
        }
        Channel channel = ctx.channel();
        HttpRequestContext httpRequestContext = (HttpRequestContext)channel.attr(HttpClientChannelContextDefaults.REQUEST_CONTEXT_ATTRIBUTE_KEY).get();
        httpRequestContext.receiveStreamID(promisedStreamId, headers, channel.newPromise());
    }

    public void onStreamRemoved(Http2Stream stream) {
        logger.log(Level.FINEST, () -> "stream removed " + stream);
        this.removeMessage(stream, true);
    }

    private FullHttpMessage newMessage(Http2Stream stream, Http2Headers headers, boolean validateHttpHeaders, ByteBufAllocator alloc) throws Http2Exception {
        if (headers.status() != null) {
            return HttpConversionUtil.toHttpResponse((int)stream.id(), (Http2Headers)headers, (ByteBufAllocator)alloc, (boolean)validateHttpHeaders);
        }
        return null;
    }

    private FullHttpMessage getMessage(Http2Stream stream) {
        return (FullHttpMessage)stream.getProperty(this.messageKey);
    }

    private void putMessage(Http2Stream stream, FullHttpMessage message) {
        FullHttpMessage previous = (FullHttpMessage)stream.setProperty(this.messageKey, (Object)message);
        if (previous != message && previous != null) {
            previous.release();
        }
    }

    private void removeMessage(Http2Stream stream, boolean release) {
        FullHttpMessage msg = (FullHttpMessage)stream.removeProperty(this.messageKey);
        if (release && msg != null) {
            msg.release();
        }
    }

    private void fireChannelRead(ChannelHandlerContext ctx, FullHttpMessage msg, boolean release, Http2Stream stream) {
        this.removeMessage(stream, release);
        HttpUtil.setContentLength((HttpMessage)msg, (long)msg.content().readableBytes());
        ctx.fireChannelRead((Object)msg);
    }

    private FullHttpMessage beginHeader(ChannelHandlerContext ctx, Http2Stream stream, Http2Headers headers, boolean allowAppend, boolean appendToTrailer) throws Http2Exception {
        FullHttpMessage msg = this.getMessage(stream);
        if (msg == null) {
            msg = this.newMessage(stream, headers, this.validateHttpHeaders, ctx.alloc());
        } else if (allowAppend) {
            HttpConversionUtil.addHttp2ToHttpHeaders((int)stream.id(), (Http2Headers)headers, (FullHttpMessage)msg, (boolean)appendToTrailer);
        } else {
            throw new Http2Exception(Http2Error.PROTOCOL_ERROR, "stream already exists");
        }
        return msg;
    }

    private void endHeader(ChannelHandlerContext ctx, Http2Stream stream, FullHttpMessage msg, boolean endOfStream) {
        if (endOfStream) {
            this.fireChannelRead(ctx, msg, this.getMessage(stream) != msg, stream);
        } else {
            this.putMessage(stream, msg);
        }
    }

    private static Http2Headers toHttp2Headers(HttpRequestContext httpRequestContext) {
        HttpRequest httpRequest = httpRequestContext.getHttpRequest();
        Http2Headers headers = new DefaultHttp2Headers().method((CharSequence)httpRequest.method().asciiName()).path((CharSequence)httpRequest.uri()).scheme((CharSequence)httpRequestContext.getURI().getScheme()).authority((CharSequence)httpRequestContext.getURI().getHost());
        HttpConversionUtil.toHttp2Headers((HttpHeaders)httpRequest.headers(), (Http2Headers)headers);
        return headers;
    }
}

