/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.netty.http.client.handler;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http2.HttpToHttp2ConnectionHandler;
import io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xbib.netty.http.client.handler.HttpClientChannelInitializer;

class Http2NegotiationHandler
extends ApplicationProtocolNegotiationHandler {
    private static final Logger logger = Logger.getLogger(Http2NegotiationHandler.class.getName());
    private final HttpClientChannelInitializer initializer;

    Http2NegotiationHandler(String fallbackProtocol, HttpClientChannelInitializer initializer) {
        super(fallbackProtocol);
        this.initializer = initializer;
    }

    protected void configurePipeline(ChannelHandlerContext ctx, String protocol) throws Exception {
        if ("h2".equals(protocol)) {
            HttpToHttp2ConnectionHandler http2connectionHandler = HttpClientChannelInitializer.createHttp2ConnectionHandler(this.initializer.getContext());
            ctx.pipeline().addLast(new ChannelHandler[]{http2connectionHandler});
            HttpClientChannelInitializer.configureHttp2Pipeline(ctx.pipeline(), this.initializer.getHttp2ResponseHandler());
            logger.log(Level.FINE, () -> "negotiated HTTP/2: handler = " + ctx.pipeline().names());
            return;
        }
        if ("http/1.1".equals(protocol)) {
            HttpClientCodec http1connectionHandler = HttpClientChannelInitializer.createHttp1ConnectionHandler(this.initializer.getContext());
            ctx.pipeline().addLast(new ChannelHandler[]{http1connectionHandler});
            HttpClientChannelInitializer.configureHttp1Pipeline(ctx.pipeline(), this.initializer.getContext(), this.initializer.getHttpHandler());
            logger.log(Level.FINE, () -> "negotiated HTTP/1.1: handler = " + ctx.pipeline().names());
            return;
        }
        ctx.close();
        throw new IllegalStateException("unexpected protocol: " + protocol);
    }
}

