/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.netty.http.client.handler;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.pool.ChannelPool;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.cookie.ClientCookieDecoder;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.HttpConversionUtil;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xbib.netty.http.client.HttpClient;
import org.xbib.netty.http.client.HttpClientChannelContextDefaults;
import org.xbib.netty.http.client.HttpRequestContext;
import org.xbib.netty.http.client.listener.CookieListener;
import org.xbib.netty.http.client.listener.ExceptionListener;
import org.xbib.netty.http.client.listener.HttpHeadersListener;
import org.xbib.netty.http.client.listener.HttpPushListener;
import org.xbib.netty.http.client.listener.HttpResponseListener;

@ChannelHandler.Sharable
public class Http2ResponseHandler
extends SimpleChannelInboundHandler<FullHttpResponse> {
    private static final Logger logger = Logger.getLogger(Http2ResponseHandler.class.getName());
    private final HttpClient httpClient;

    public Http2ResponseHandler(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    protected void channelRead0(ChannelHandlerContext ctx, FullHttpResponse httpResponse) throws Exception {
        logger.log(Level.FINE, () -> httpResponse.getClass().getName());
        Integer streamId = httpResponse.headers().getInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text());
        if (streamId == null) {
            logger.log(Level.WARNING, () -> "stream ID missing in headers");
            return;
        }
        HttpRequestContext httpRequestContext = (HttpRequestContext)ctx.channel().attr(HttpClientChannelContextDefaults.REQUEST_CONTEXT_ATTRIBUTE_KEY).get();
        HttpHeaders httpHeaders = httpResponse.headers();
        HttpHeadersListener httpHeadersListener = (HttpHeadersListener)ctx.channel().attr(HttpClientChannelContextDefaults.HEADER_LISTENER_ATTRIBUTE_KEY).get();
        if (httpHeadersListener != null) {
            logger.log(Level.FINE, () -> "firing onHeaders");
            httpHeadersListener.onHeaders(httpHeaders);
        }
        CookieListener cookieListener = (CookieListener)ctx.channel().attr(HttpClientChannelContextDefaults.COOKIE_LISTENER_ATTRIBUTE_KEY).get();
        for (String cookieString : httpHeaders.getAll((CharSequence)HttpHeaderNames.SET_COOKIE)) {
            Cookie cookie = ClientCookieDecoder.STRICT.decode(cookieString);
            httpRequestContext.addCookie(cookie);
            if (cookieListener == null) continue;
            logger.log(Level.FINE, () -> "firing onCookie");
            cookieListener.onCookie(cookie);
        }
        Map.Entry<Http2Headers, ChannelPromise> pushEntry = httpRequestContext.getPushMap().get(streamId);
        if (pushEntry != null) {
            HttpPushListener httpPushListener = (HttpPushListener)ctx.channel().attr(HttpClientChannelContextDefaults.PUSH_LISTENER_ATTRIBUTE_KEY).get();
            if (httpPushListener != null) {
                httpPushListener.onPushReceived(pushEntry.getKey(), httpResponse);
            }
            if (!pushEntry.getValue().isSuccess()) {
                pushEntry.getValue().setSuccess();
            }
            httpRequestContext.getPushMap().remove(streamId);
            if (httpRequestContext.isFinished()) {
                httpRequestContext.success("response finished");
            }
            return;
        }
        Map.Entry<ChannelFuture, ChannelPromise> promiseEntry = httpRequestContext.getStreamIdPromiseMap().get(streamId);
        if (promiseEntry != null) {
            HttpResponseListener httpResponseListener = (HttpResponseListener)ctx.channel().attr(HttpClientChannelContextDefaults.RESPONSE_LISTENER_ATTRIBUTE_KEY).get();
            if (httpResponseListener != null) {
                httpResponseListener.onResponse(httpResponse);
            }
            if (!promiseEntry.getValue().isSuccess()) {
                promiseEntry.getValue().setSuccess();
            }
            if (this.httpClient.tryRedirect(ctx.channel(), httpResponse, httpRequestContext)) {
                return;
            }
            httpRequestContext.getStreamIdPromiseMap().remove(streamId);
            if (httpRequestContext.isFinished()) {
                httpRequestContext.success("response finished");
            }
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        logger.log(Level.FINE, ctx::toString);
        ChannelPool channelPool = (ChannelPool)ctx.channel().attr(HttpClientChannelContextDefaults.CHANNEL_POOL_ATTRIBUTE_KEY).get();
        channelPool.release(ctx.channel());
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        logger.log(Level.FINE, () -> "exception caught: " + cause);
        ExceptionListener exceptionListener = (ExceptionListener)ctx.channel().attr(HttpClientChannelContextDefaults.EXCEPTION_LISTENER_ATTRIBUTE_KEY).get();
        if (exceptionListener != null) {
            exceptionListener.onException(cause);
        }
        HttpRequestContext httpRequestContext = (HttpRequestContext)ctx.channel().attr(HttpClientChannelContextDefaults.REQUEST_CONTEXT_ATTRIBUTE_KEY).get();
        httpRequestContext.fail(cause.getMessage());
        ChannelPool channelPool = (ChannelPool)ctx.channel().attr(HttpClientChannelContextDefaults.CHANNEL_POOL_ATTRIBUTE_KEY).get();
        channelPool.release(ctx.channel());
    }
}

