/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.netty.http.client.handler;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpClientUpgradeHandler;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.DelegatingDecompressorFrameListener;
import io.netty.handler.codec.http2.Http2ClientUpgradeCodec;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.codec.http2.HttpToHttp2ConnectionHandler;
import io.netty.handler.codec.http2.HttpToHttp2ConnectionHandlerBuilder;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.ReadTimeoutHandler;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import org.xbib.netty.http.client.HttpClientChannelContext;
import org.xbib.netty.http.client.handler.Http2EventHandler;
import org.xbib.netty.http.client.handler.Http2NegotiationHandler;
import org.xbib.netty.http.client.handler.Http2ResponseHandler;
import org.xbib.netty.http.client.handler.HttpHandler;
import org.xbib.netty.http.client.handler.TrafficLoggingHandler;
import org.xbib.netty.http.client.handler.UpgradeRequestHandler;
import org.xbib.netty.http.client.handler.UserEventLogger;
import org.xbib.netty.http.client.util.InetAddressKey;

public class HttpClientChannelInitializer
extends ChannelInitializer<SocketChannel> {
    private static final Logger logger = Logger.getLogger(HttpClientChannelInitializer.class.getName());
    private final HttpClientChannelContext context;
    private final HttpHandler httpHandler;
    private final Http2ResponseHandler http2ResponseHandler;
    private InetAddressKey key;

    public HttpClientChannelInitializer(HttpClientChannelContext context, HttpHandler httpHandler, Http2ResponseHandler http2ResponseHandler) {
        this.context = context;
        this.httpHandler = httpHandler;
        this.http2ResponseHandler = http2ResponseHandler;
    }

    HttpClientChannelContext getContext() {
        return this.context;
    }

    HttpHandler getHttpHandler() {
        return this.httpHandler;
    }

    Http2ResponseHandler getHttp2ResponseHandler() {
        return this.http2ResponseHandler;
    }

    public void initChannel(SocketChannel ch, InetAddressKey key) throws Exception {
        this.key = key;
        this.initChannel(ch);
    }

    protected void initChannel(SocketChannel ch) throws Exception {
        logger.log(Level.FINE, () -> "initChannel with key = " + this.key);
        if (this.key == null) {
            throw new IllegalStateException("no key set for channel initialization");
        }
        ChannelPipeline pipeline = ch.pipeline();
        pipeline.addLast(new ChannelHandler[]{new TrafficLoggingHandler()});
        if (this.context.getHttpProxyHandler() != null) {
            pipeline.addLast(new ChannelHandler[]{this.context.getHttpProxyHandler()});
        }
        if (this.context.getSocks4ProxyHandler() != null) {
            pipeline.addLast(new ChannelHandler[]{this.context.getSocks4ProxyHandler()});
        }
        if (this.context.getSocks5ProxyHandler() != null) {
            pipeline.addLast(new ChannelHandler[]{this.context.getSocks5ProxyHandler()});
        }
        pipeline.addLast(new ChannelHandler[]{new ReadTimeoutHandler((long)this.context.getReadTimeoutMillis(), TimeUnit.MILLISECONDS)});
        if (this.context.getSslProvider() != null && this.key.isSecure()) {
            this.configureEncrypted(ch);
        } else {
            this.configureClearText(ch);
        }
        logger.log(Level.FINE, () -> "initChannel complete, pipeline handler names = " + ch.pipeline().names());
    }

    private void configureClearText(SocketChannel ch) {
        ChannelPipeline pipeline = ch.pipeline();
        if (this.key.getVersion().majorVersion() == 1) {
            HttpClientCodec http1connectionHandler = HttpClientChannelInitializer.createHttp1ConnectionHandler(this.context);
            pipeline.addLast(new ChannelHandler[]{http1connectionHandler});
            HttpClientChannelInitializer.configureHttp1Pipeline(pipeline, this.context, this.httpHandler);
        } else if (this.key.getVersion().majorVersion() == 2) {
            HttpToHttp2ConnectionHandler http2connectionHandler = HttpClientChannelInitializer.createHttp2ConnectionHandler(this.context);
            if (this.context.isInstallHttp2Upgrade()) {
                HttpClientCodec http1connectionHandler = HttpClientChannelInitializer.createHttp1ConnectionHandler(this.context);
                Http2ClientUpgradeCodec upgradeCodec = new Http2ClientUpgradeCodec((Http2ConnectionHandler)http2connectionHandler);
                HttpClientUpgradeHandler upgradeHandler = new HttpClientUpgradeHandler((HttpClientUpgradeHandler.SourceCodec)http1connectionHandler, (HttpClientUpgradeHandler.UpgradeCodec)upgradeCodec, this.context.getMaxContentLength());
                pipeline.addLast(new ChannelHandler[]{upgradeHandler});
                UpgradeRequestHandler upgradeRequestHandler = new UpgradeRequestHandler();
                pipeline.addLast(new ChannelHandler[]{upgradeRequestHandler});
            } else {
                pipeline.addLast(new ChannelHandler[]{http2connectionHandler});
            }
            HttpClientChannelInitializer.configureHttp2Pipeline(pipeline, this.http2ResponseHandler);
            HttpClientChannelInitializer.configureHttp1Pipeline(pipeline, this.context, this.httpHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureEncrypted(SocketChannel ch) throws SSLException {
        ChannelPipeline pipeline = ch.pipeline();
        SslContextBuilder sslContextBuilder = SslContextBuilder.forClient().sslProvider(this.context.getSslProvider()).keyManager(this.context.getKeyCertChainInputStream(), this.context.getKeyInputStream(), this.context.getKeyPassword()).ciphers(this.context.getCiphers(), this.context.getCipherSuiteFilter()).trustManager(this.context.getTrustManagerFactory());
        if (this.key.getVersion().majorVersion() == 2) {
            sslContextBuilder.applicationProtocolConfig(new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, new String[]{"h2", "http/1.1"}));
        }
        SslHandler sslHandler = sslContextBuilder.build().newHandler(ch.alloc());
        SSLEngine engine = sslHandler.engine();
        try {
            if (this.context.isUseServerNameIdentification()) {
                String fullQualifiedHostname = this.key.getInetSocketAddress().getHostName();
                SSLParameters params = engine.getSSLParameters();
                params.setServerNames(Arrays.asList(new SNIHostName(fullQualifiedHostname)));
                engine.setSSLParameters(params);
            }
        }
        catch (Throwable throwable) {
            pipeline.addLast(new ChannelHandler[]{sslHandler});
            throw throwable;
        }
        pipeline.addLast(new ChannelHandler[]{sslHandler});
        switch (this.context.getClientAuthMode()) {
            case NEED: {
                engine.setNeedClientAuth(true);
                break;
            }
            case WANT: {
                engine.setWantClientAuth(true);
                break;
            }
        }
        if (this.key.getVersion().majorVersion() == 1) {
            HttpClientCodec http1connectionHandler = HttpClientChannelInitializer.createHttp1ConnectionHandler(this.context);
            pipeline.addLast(new ChannelHandler[]{http1connectionHandler});
            HttpClientChannelInitializer.configureHttp1Pipeline(pipeline, this.context, this.httpHandler);
        } else if (this.key.getVersion().majorVersion() == 2) {
            pipeline.addLast(new ChannelHandler[]{new Http2NegotiationHandler("http/1.1", this)});
        }
    }

    static void configureHttp1Pipeline(ChannelPipeline pipeline, HttpClientChannelContext context, HttpHandler httpHandler) {
        if (context.isGzipEnabled()) {
            pipeline.addLast(new ChannelHandler[]{new HttpContentDecompressor()});
        }
        HttpObjectAggregator httpObjectAggregator = new HttpObjectAggregator(context.getMaxContentLength(), false);
        httpObjectAggregator.setMaxCumulationBufferComponents(context.getMaxCompositeBufferComponents());
        pipeline.addLast(new ChannelHandler[]{httpObjectAggregator});
        pipeline.addLast(new ChannelHandler[]{httpHandler});
    }

    static void configureHttp2Pipeline(ChannelPipeline pipeline, Http2ResponseHandler http2ResponseHandler) {
        pipeline.addLast(new ChannelHandler[]{new UserEventLogger()});
        pipeline.addLast(new ChannelHandler[]{http2ResponseHandler});
    }

    static HttpClientCodec createHttp1ConnectionHandler(HttpClientChannelContext context) {
        return new HttpClientCodec(context.getMaxInitialLineLength(), context.getMaxHeaderSize(), context.getMaxChunkSize());
    }

    static HttpToHttp2ConnectionHandler createHttp2ConnectionHandler(HttpClientChannelContext context) {
        DefaultHttp2Connection http2Connection = new DefaultHttp2Connection(false);
        return new HttpToHttp2ConnectionHandlerBuilder().connection((Http2Connection)http2Connection).frameLogger(new Http2FrameLogger(LogLevel.TRACE, HttpClientChannelInitializer.class)).frameListener((Http2FrameListener)new DelegatingDecompressorFrameListener((Http2Connection)http2Connection, (Http2FrameListener)new Http2EventHandler((Http2Connection)http2Connection, context.getMaxContentLength(), false))).build();
    }
}

