/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.netty.http.client.handler;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.pool.ChannelPool;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.cookie.ClientCookieDecoder;
import io.netty.handler.codec.http.cookie.Cookie;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xbib.netty.http.client.HttpClient;
import org.xbib.netty.http.client.HttpClientChannelContextDefaults;
import org.xbib.netty.http.client.HttpRequestContext;
import org.xbib.netty.http.client.listener.CookieListener;
import org.xbib.netty.http.client.listener.ExceptionListener;
import org.xbib.netty.http.client.listener.HttpHeadersListener;
import org.xbib.netty.http.client.listener.HttpResponseListener;

@ChannelHandler.Sharable
public final class HttpHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger logger = Logger.getLogger(HttpHandler.class.getName());
    private final HttpClient httpClient;

    public HttpHandler(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        logger.log(Level.FINE, () -> "channelRead msg " + msg.getClass().getName());
        HttpRequestContext httpRequestContext = (HttpRequestContext)ctx.channel().attr(HttpClientChannelContextDefaults.REQUEST_CONTEXT_ATTRIBUTE_KEY).get();
        if (msg instanceof FullHttpResponse) {
            FullHttpResponse httpResponse = (FullHttpResponse)msg;
            HttpHeaders httpHeaders = httpResponse.headers();
            HttpHeadersListener httpHeadersListener = (HttpHeadersListener)ctx.channel().attr(HttpClientChannelContextDefaults.HEADER_LISTENER_ATTRIBUTE_KEY).get();
            if (httpHeadersListener != null) {
                logger.log(Level.FINE, () -> "firing onHeaders");
                httpHeadersListener.onHeaders(httpHeaders);
            }
            CookieListener cookieListener = (CookieListener)ctx.channel().attr(HttpClientChannelContextDefaults.COOKIE_LISTENER_ATTRIBUTE_KEY).get();
            for (String cookieString : httpHeaders.getAll((CharSequence)HttpHeaderNames.SET_COOKIE)) {
                Cookie cookie = ClientCookieDecoder.STRICT.decode(cookieString);
                httpRequestContext.addCookie(cookie);
                if (cookieListener == null) continue;
                logger.log(Level.FINE, () -> "firing onCookie");
                cookieListener.onCookie(cookie);
            }
            HttpResponseListener httpResponseListener = (HttpResponseListener)ctx.channel().attr(HttpClientChannelContextDefaults.RESPONSE_LISTENER_ATTRIBUTE_KEY).get();
            if (httpResponseListener != null) {
                logger.log(Level.FINE, () -> "firing onResponse");
                httpResponseListener.onResponse(httpResponse);
            }
            logger.log(Level.FINE, () -> "trying redirect");
            if (this.httpClient.tryRedirect(ctx.channel(), httpResponse, httpRequestContext)) {
                return;
            }
            httpRequestContext.success("response finished");
            ChannelPool channelPool = (ChannelPool)ctx.channel().attr(HttpClientChannelContextDefaults.CHANNEL_POOL_ATTRIBUTE_KEY).get();
            channelPool.release(ctx.channel());
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        logger.log(Level.FINE, () -> "channelInactive " + ctx);
        HttpRequestContext httpRequestContext = (HttpRequestContext)ctx.channel().attr(HttpClientChannelContextDefaults.REQUEST_CONTEXT_ATTRIBUTE_KEY).get();
        if (httpRequestContext.getRedirectCount().get() == 0 && !httpRequestContext.isSucceeded()) {
            httpRequestContext.fail("channel inactive");
        }
        ChannelPool channelPool = (ChannelPool)ctx.channel().attr(HttpClientChannelContextDefaults.CHANNEL_POOL_ATTRIBUTE_KEY).get();
        channelPool.release(ctx.channel());
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        ExceptionListener exceptionListener = (ExceptionListener)ctx.channel().attr(HttpClientChannelContextDefaults.EXCEPTION_LISTENER_ATTRIBUTE_KEY).get();
        logger.log(Level.FINE, () -> "exceptionCaught");
        if (exceptionListener != null) {
            exceptionListener.onException(cause);
        }
        HttpRequestContext httpRequestContext = (HttpRequestContext)ctx.channel().attr(HttpClientChannelContextDefaults.REQUEST_CONTEXT_ATTRIBUTE_KEY).get();
        httpRequestContext.fail(cause.getMessage());
        ChannelPool channelPool = (ChannelPool)ctx.channel().attr(HttpClientChannelContextDefaults.CHANNEL_POOL_ATTRIBUTE_KEY).get();
        channelPool.release(ctx.channel());
    }
}

