/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.netty.http.client.handler;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xbib.netty.http.client.HttpClientChannelContextDefaults;
import org.xbib.netty.http.client.HttpRequestContext;
import org.xbib.netty.http.client.listener.ExceptionListener;

@ChannelHandler.Sharable
class UpgradeRequestHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger logger = Logger.getLogger(UpgradeRequestHandler.class.getName());

    UpgradeRequestHandler() {
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        DefaultFullHttpRequest upgradeRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/");
        ctx.writeAndFlush((Object)upgradeRequest);
        super.channelActive(ctx);
        ctx.pipeline().remove((ChannelHandler)this);
        logger.log(Level.FINE, () -> "upgrade request handler removed, pipeline = " + ctx.pipeline().names());
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        logger.log(Level.FINE, () -> "exceptionCaught " + cause.getMessage());
        ExceptionListener exceptionListener = (ExceptionListener)ctx.channel().attr(HttpClientChannelContextDefaults.EXCEPTION_LISTENER_ATTRIBUTE_KEY).get();
        if (exceptionListener != null) {
            exceptionListener.onException(cause);
        }
        HttpRequestContext httpRequestContext = (HttpRequestContext)ctx.channel().attr(HttpClientChannelContextDefaults.REQUEST_CONTEXT_ATTRIBUTE_KEY).get();
        httpRequestContext.fail(cause.getMessage());
    }
}

