/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.netty.http.client.internal;

import io.netty.channel.Channel;
import io.netty.channel.pool.ChannelPoolHandler;
import io.netty.channel.socket.SocketChannel;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xbib.netty.http.client.handler.HttpClientChannelInitializer;
import org.xbib.netty.http.client.util.InetAddressKey;

public class HttpClientChannelPoolHandler
implements ChannelPoolHandler {
    private static final Logger logger = Logger.getLogger(HttpClientChannelPoolHandler.class.getName());
    private final HttpClientChannelInitializer channelInitializer;
    private final InetAddressKey key;
    private final AtomicInteger active = new AtomicInteger();
    private int peak;

    public HttpClientChannelPoolHandler(HttpClientChannelInitializer channelInitializer, InetAddressKey key) {
        this.channelInitializer = channelInitializer;
        this.key = key;
    }

    public void channelCreated(Channel ch) throws Exception {
        logger.log(Level.FINE, () -> "channel created " + ch + " key:" + this.key);
        this.channelInitializer.initChannel((SocketChannel)ch, this.key);
        int n = this.active.incrementAndGet();
        if (n > this.peak) {
            this.peak = n;
        }
    }

    public void channelAcquired(Channel ch) throws Exception {
        logger.log(Level.FINE, () -> "channel acquired from pool " + ch);
    }

    public void channelReleased(Channel ch) throws Exception {
        logger.log(Level.FINE, () -> "channel released to pool " + ch);
        this.active.decrementAndGet();
    }

    public int getActive() {
        return this.active.get();
    }

    public int getPeak() {
        return this.peak;
    }
}

