/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.netty.http.client.internal;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.pool.AbstractChannelPoolMap;
import io.netty.channel.pool.ChannelPoolHandler;
import io.netty.channel.pool.FixedChannelPool;
import java.net.SocketAddress;
import org.xbib.netty.http.client.HttpClient;
import org.xbib.netty.http.client.HttpClientChannelContext;
import org.xbib.netty.http.client.handler.Http2ResponseHandler;
import org.xbib.netty.http.client.handler.HttpClientChannelInitializer;
import org.xbib.netty.http.client.handler.HttpHandler;
import org.xbib.netty.http.client.internal.HttpClientChannelPoolHandler;
import org.xbib.netty.http.client.util.InetAddressKey;

public class HttpClientChannelPoolMap
extends AbstractChannelPoolMap<InetAddressKey, FixedChannelPool> {
    private final HttpClient httpClient;
    private final HttpClientChannelContext httpClientChannelContext;
    private final Bootstrap bootstrap;
    private final int maxConnections;
    private HttpClientChannelInitializer httpClientChannelInitializer;
    private HttpClientChannelPoolHandler httpClientChannelPoolHandler;

    public HttpClientChannelPoolMap(HttpClient httpClient, HttpClientChannelContext httpClientChannelContext, Bootstrap bootstrap, int maxConnections) {
        this.httpClient = httpClient;
        this.httpClientChannelContext = httpClientChannelContext;
        this.bootstrap = bootstrap;
        this.maxConnections = maxConnections;
    }

    protected FixedChannelPool newPool(InetAddressKey key) {
        this.httpClientChannelInitializer = new HttpClientChannelInitializer(this.httpClientChannelContext, new HttpHandler(this.httpClient), new Http2ResponseHandler(this.httpClient));
        this.httpClientChannelPoolHandler = new HttpClientChannelPoolHandler(this.httpClientChannelInitializer, key);
        return new FixedChannelPool(this.bootstrap.remoteAddress((SocketAddress)key.getInetSocketAddress()), (ChannelPoolHandler)this.httpClientChannelPoolHandler, this.maxConnections);
    }

    public HttpClientChannelInitializer getHttpClientChannelInitializer() {
        return this.httpClientChannelInitializer;
    }

    public HttpClientChannelPoolHandler getHttpClientChannelPoolHandler() {
        return this.httpClientChannelPoolHandler;
    }
}

