/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.netty.http.client.internal;

import io.netty.bootstrap.Bootstrap;
import java.util.Optional;
import org.xbib.netty.http.client.HttpClient;

public final class HttpClientUserAgent {
    private static final String USER_AGENT = String.format("XbibHttpClient/%s (Java/%s/%s) (Netty/%s)", HttpClientUserAgent.httpClientVersion(), HttpClientUserAgent.javaVendor(), HttpClientUserAgent.javaVersion(), HttpClientUserAgent.nettyVersion());

    private HttpClientUserAgent() {
    }

    public static String getUserAgent() {
        return USER_AGENT;
    }

    private static String httpClientVersion() {
        return Optional.ofNullable(HttpClient.class.getPackage().getImplementationVersion()).orElse("unknown");
    }

    private static String javaVendor() {
        return Optional.ofNullable(System.getProperty("java.vendor")).orElse("unknown");
    }

    private static String javaVersion() {
        return Optional.ofNullable(System.getProperty("java.version")).orElse("unknown");
    }

    private static String nettyVersion() {
        return Optional.ofNullable(Bootstrap.class.getPackage().getImplementationVersion()).orElse("unknown");
    }
}

