/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.netty.http.client.util;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;

public abstract class AbstractFuture<V>
implements Future<V> {
    private final Sync<V> sync = new Sync();

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException, ExecutionException {
        return this.sync.get(unit.toNanos(timeout));
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        return this.sync.get();
    }

    @Override
    public boolean isDone() {
        return this.sync.isDone();
    }

    @Override
    public boolean isCancelled() {
        return this.sync.isCancelled();
    }

    public boolean isSucceeded() {
        return this.sync.isSuccess();
    }

    public boolean isFailed() {
        return this.sync.isFailed();
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (!this.sync.cancel()) {
            return false;
        }
        this.done();
        if (mayInterruptIfRunning) {
            this.interruptTask();
        }
        return true;
    }

    protected boolean set(V value) {
        boolean result = this.sync.set(value);
        if (result) {
            this.done();
        }
        return result;
    }

    protected boolean setException(Exception exception) {
        boolean result = this.sync.setException(exception);
        if (result) {
            this.done();
        }
        return result;
    }

    protected final boolean cancel() {
        boolean result = this.sync.cancel();
        if (result) {
            this.done();
        }
        return result;
    }

    protected void done() {
    }

    protected void interruptTask() {
    }

    static final class Sync<V>
    extends AbstractQueuedSynchronizer {
        private static final long serialVersionUID = -796072460488712821L;
        static final int RUNNING = 0;
        static final int COMPLETING = 1;
        static final int COMPLETED = 2;
        static final int CANCELLED = 4;
        private V value;
        private Exception exception;

        Sync() {
        }

        @Override
        protected int tryAcquireShared(int ignored) {
            return this.isDone() ? 1 : -1;
        }

        @Override
        protected boolean tryReleaseShared(int finalState) {
            this.setState(finalState);
            return true;
        }

        V get(long nanos) throws TimeoutException, CancellationException, ExecutionException, InterruptedException {
            if (!this.tryAcquireSharedNanos(-1, nanos)) {
                throw new TimeoutException("Timeout waiting for task.");
            }
            return this.getValue();
        }

        V get() throws CancellationException, ExecutionException, InterruptedException {
            this.acquireSharedInterruptibly(-1);
            return this.getValue();
        }

        private V getValue() throws CancellationException, ExecutionException {
            int state = this.getState();
            switch (state) {
                case 2: {
                    if (this.exception != null) {
                        throw new ExecutionException(this.exception);
                    }
                    return this.value;
                }
                case 4: {
                    throw new CancellationException("task was cancelled");
                }
            }
            throw new IllegalStateException("error, synchronizer in invalid state: " + state);
        }

        boolean isDone() {
            return (this.getState() & 6) != 0;
        }

        boolean isCancelled() {
            return this.getState() == 4;
        }

        boolean isSuccess() {
            return this.value != null && this.getState() == 2;
        }

        boolean isFailed() {
            return this.exception != null && this.getState() == 2;
        }

        boolean set(V v) {
            return this.complete(v, null, 2);
        }

        boolean setException(Exception exception) {
            return this.complete(null, exception, 2);
        }

        boolean cancel() {
            return this.complete(null, null, 4);
        }

        private boolean complete(V v, Exception exception, int finalState) {
            boolean doCompletion = this.compareAndSetState(0, 1);
            if (doCompletion) {
                this.value = v;
                this.exception = exception;
                this.releaseShared(finalState);
            } else if (this.getState() == 1) {
                this.acquireShared(-1);
            }
            return doCompletion;
        }
    }
}

