/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.netty.http.client.util;

import io.netty.handler.codec.http.HttpVersion;
import java.net.InetSocketAddress;

public class InetAddressKey {
    private final String host;
    private final int port;
    private final HttpVersion version;
    private final Boolean secure;
    private InetSocketAddress inetSocketAddress;

    public InetAddressKey(String host, int port, HttpVersion version, boolean secure) {
        this.host = host;
        this.port = port == -1 ? (secure ? 443 : 80) : port;
        this.version = version;
        this.secure = secure;
    }

    public InetSocketAddress getInetSocketAddress() {
        if (this.inetSocketAddress == null) {
            this.inetSocketAddress = new InetSocketAddress(this.host, this.port);
        }
        return this.inetSocketAddress;
    }

    public HttpVersion getVersion() {
        return this.version;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public String toString() {
        return this.host + ":" + this.port + " (version:" + this.version + ",secure:" + this.secure + ")";
    }

    public boolean equals(Object object) {
        return object instanceof InetAddressKey && this.host.equals(((InetAddressKey)object).host) && this.port == ((InetAddressKey)object).port && this.version.equals((Object)((InetAddressKey)object).version) && this.secure.equals(((InetAddressKey)object).secure);
    }

    public int hashCode() {
        return this.host.hashCode() ^ this.port ^ this.version.hashCode() ^ this.secure.hashCode();
    }
}

