/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.netty.http.client.util;

import java.util.Collection;
import java.util.LinkedHashSet;

public final class LimitedHashSet<E>
extends LinkedHashSet<E> {
    private static final long serialVersionUID = 1838128758142912702L;
    private final int max;

    public LimitedHashSet(int max) {
        this.max = max;
    }

    @Override
    public boolean add(E element) {
        if (this.max < this.size()) {
            throw new IllegalStateException("limit exceeded");
        }
        return super.add(element);
    }

    @Override
    public boolean addAll(Collection<? extends E> elements) {
        boolean b = false;
        for (E element : elements) {
            if (this.max < this.size()) {
                throw new IllegalStateException("limit exceeded");
            }
            b = b || super.add(element);
        }
        return b;
    }
}

