/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.netty.http.client;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.pool.ChannelPoolHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.proxy.HttpProxyHandler;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.util.concurrent.Future;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.KeyStoreException;
import java.security.Provider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.ServiceLoader;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManagerFactory;
import org.xbib.net.URL;
import org.xbib.netty.http.client.ClientAuthMode;
import org.xbib.netty.http.client.ClientConfig;
import org.xbib.netty.http.client.api.ClientProtocolProvider;
import org.xbib.netty.http.client.api.ClientTransport;
import org.xbib.netty.http.client.api.Request;
import org.xbib.netty.http.client.pool.BoundedChannelPool;
import org.xbib.netty.http.common.HttpAddress;
import org.xbib.netty.http.common.HttpChannelInitializer;
import org.xbib.netty.http.common.HttpResponse;
import org.xbib.netty.http.common.NetworkUtils;
import org.xbib.netty.http.common.TransportProvider;
import org.xbib.netty.http.common.security.SecurityUtil;

public final class Client
implements AutoCloseable {
    private static final Logger logger = Logger.getLogger(Client.class.getName());
    private final AtomicLong requestCounter;
    private final AtomicLong responseCounter;
    private final ClientConfig clientConfig;
    private final ByteBufAllocator byteBufAllocator;
    private final Bootstrap bootstrap;
    private final Queue<ClientTransport> transports;
    private final List<ClientProtocolProvider<HttpChannelInitializer, ClientTransport>> protocolProviders;
    private final AtomicBoolean closed;
    private EventLoopGroup eventLoopGroup;
    private Class<? extends SocketChannel> socketChannelClass;
    private BoundedChannelPool<HttpAddress> pool;

    public Client() {
        this(new ClientConfig());
    }

    public Client(ClientConfig clientConfig) {
        this(clientConfig, null, null, null);
    }

    public Client(ClientConfig clientConfig, ByteBufAllocator byteBufAllocator, EventLoopGroup eventLoopGroup, Class<? extends SocketChannel> socketChannelClass) {
        Objects.requireNonNull(clientConfig);
        this.requestCounter = new AtomicLong();
        this.responseCounter = new AtomicLong();
        this.closed = new AtomicBoolean(false);
        this.clientConfig = clientConfig;
        this.protocolProviders = new ArrayList<ClientProtocolProvider<HttpChannelInitializer, ClientTransport>>();
        for (ClientProtocolProvider clientProtocolProvider : ServiceLoader.load(ClientProtocolProvider.class)) {
            this.protocolProviders.add((ClientProtocolProvider<HttpChannelInitializer, ClientTransport>)clientProtocolProvider);
            if (!logger.isLoggable(Level.FINEST)) continue;
            logger.log(Level.FINEST, "protocol provider: " + clientProtocolProvider.transportClass());
        }
        Client.initializeTrustManagerFactory(clientConfig);
        ByteBufAllocator byteBufAllocator2 = this.byteBufAllocator = byteBufAllocator != null ? byteBufAllocator : ByteBufAllocator.DEFAULT;
        if (eventLoopGroup != null) {
            this.eventLoopGroup = eventLoopGroup;
        }
        if (socketChannelClass != null) {
            this.socketChannelClass = socketChannelClass;
        }
        ServiceLoader<TransportProvider> transportProviders = ServiceLoader.load(TransportProvider.class);
        for (TransportProvider transportProvider : transportProviders) {
            if (this.eventLoopGroup == null && (clientConfig.getTransportProviderName() == null || clientConfig.getTransportProviderName().equals(transportProvider.getClass().getName()))) {
                this.eventLoopGroup = transportProvider.createEventLoopGroup(clientConfig.getThreadCount(), (ThreadFactory)new HttpClientThreadFactory());
            }
            if (this.socketChannelClass != null || clientConfig.getTransportProviderName() != null && !clientConfig.getTransportProviderName().equals(transportProvider.getClass().getName())) continue;
            this.socketChannelClass = transportProvider.createSocketChannelClass();
        }
        if (this.eventLoopGroup == null) {
            this.eventLoopGroup = new NioEventLoopGroup(clientConfig.getThreadCount(), (ThreadFactory)new HttpClientThreadFactory());
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "event loop group class: " + this.eventLoopGroup.getClass().getName());
        }
        if (this.socketChannelClass == null) {
            this.socketChannelClass = NioSocketChannel.class;
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "socket channel class: " + this.socketChannelClass.getName());
        }
        this.bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.eventLoopGroup)).channel(this.socketChannelClass)).option(ChannelOption.ALLOCATOR, (Object)byteBufAllocator)).option(ChannelOption.TCP_NODELAY, (Object)clientConfig.isTcpNodelay())).option(ChannelOption.SO_KEEPALIVE, (Object)clientConfig.isKeepAlive())).option(ChannelOption.SO_REUSEADDR, (Object)clientConfig.isReuseAddr())).option(ChannelOption.SO_SNDBUF, (Object)clientConfig.getTcpSendBufferSize())).option(ChannelOption.SO_RCVBUF, (Object)clientConfig.getTcpReceiveBufferSize())).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)clientConfig.getConnectTimeoutMillis())).option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)clientConfig.getWriteBufferWaterMark());
        this.transports = new ConcurrentLinkedQueue<ClientTransport>();
        if (!clientConfig.getPoolNodes().isEmpty()) {
            List<HttpAddress> list = clientConfig.getPoolNodes();
            Integer limit = clientConfig.getPoolNodeConnectionLimit();
            if (limit == null || limit < 1) {
                limit = 1;
            }
            Semaphore semaphore = new Semaphore(limit);
            Integer retries = clientConfig.getRetriesPerPoolNode();
            if (retries == null || retries < 0) {
                retries = 0;
            }
            ClientChannelPoolHandler clientChannelPoolHandler = new ClientChannelPoolHandler();
            this.pool = new BoundedChannelPool<HttpAddress>(semaphore, clientConfig.getPoolVersion(), list, this.bootstrap, clientChannelPoolHandler, retries, clientConfig.getPoolKeySelectorType());
            Integer nodeConnectionLimit = clientConfig.getPoolNodeConnectionLimit();
            if (nodeConnectionLimit == null || nodeConnectionLimit == 0) {
                nodeConnectionLimit = list.size();
            }
            try {
                this.pool.prepare(nodeConnectionLimit);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            logger.log(Level.FINE, "client pool prepared: size = " + nodeConnectionLimit);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<ClientProtocolProvider<HttpChannelInitializer, ClientTransport>> getProtocolProviders() {
        return this.protocolProviders;
    }

    public ClientConfig getClientConfig() {
        return this.clientConfig;
    }

    public ByteBufAllocator getByteBufAllocator() {
        return this.byteBufAllocator;
    }

    public boolean hasPooledConnections() {
        return this.pool != null && !this.clientConfig.getPoolNodes().isEmpty();
    }

    public AtomicLong getRequestCounter() {
        return this.requestCounter;
    }

    public AtomicLong getResponseCounter() {
        return this.responseCounter;
    }

    public ClientTransport newTransport() {
        return this.newTransport(null);
    }

    public ClientTransport newTransport(HttpAddress httpAddress) {
        ClientTransport transport = null;
        if (httpAddress != null) {
            for (ClientProtocolProvider<HttpChannelInitializer, ClientTransport> protocolProvider : this.protocolProviders) {
                if (!protocolProvider.supportsMajorVersion(httpAddress.getVersion().majorVersion())) continue;
                try {
                    transport = (ClientTransport)protocolProvider.transportClass().getConstructor(Client.class, HttpAddress.class).newInstance(this, httpAddress);
                    break;
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new IllegalStateException();
                }
            }
            if (transport == null) {
                throw new UnsupportedOperationException("no protocol support for " + httpAddress);
            }
        } else if (this.hasPooledConnections()) {
            for (ClientProtocolProvider<HttpChannelInitializer, ClientTransport> protocolProvider : this.protocolProviders) {
                if (!protocolProvider.supportsMajorVersion(this.pool.getVersion().majorVersion())) continue;
                try {
                    transport = (ClientTransport)protocolProvider.transportClass().getConstructor(Client.class, HttpAddress.class).newInstance(this, null);
                    break;
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new IllegalStateException();
                }
            }
            if (transport == null) {
                throw new UnsupportedOperationException("no pool protocol support for " + this.pool.getVersion().majorVersion());
            }
        } else {
            throw new IllegalStateException("no address given to connect to");
        }
        this.transports.add(transport);
        return transport;
    }

    public Channel newChannel(HttpAddress httpAddress) throws IOException {
        Channel channel;
        if (httpAddress != null) {
            HttpVersion httpVersion = httpAddress.getVersion();
            SslContext sslContext = Client.newSslContext(this.clientConfig, httpAddress.getVersion());
            SslHandlerFactory sslHandlerFactory = new SslHandlerFactory(sslContext, this.clientConfig, httpAddress, this.byteBufAllocator);
            HttpChannelInitializer initializerTwo = this.findChannelInitializer(2, httpAddress, sslHandlerFactory, null);
            HttpChannelInitializer initializer = this.findChannelInitializer(httpVersion.majorVersion(), httpAddress, sslHandlerFactory, initializerTwo);
            try {
                channel = ((Bootstrap)this.bootstrap.handler((ChannelHandler)initializer)).connect((SocketAddress)httpAddress.getInetSocketAddress()).sync().await().channel();
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        } else if (this.hasPooledConnections()) {
            try {
                channel = this.pool.acquire();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        } else {
            throw new UnsupportedOperationException();
        }
        return channel;
    }

    public void releaseChannel(Channel channel, boolean close) throws IOException {
        if (channel == null) {
            return;
        }
        if (this.hasPooledConnections()) {
            try {
                this.pool.release(channel, close);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        } else if (close) {
            channel.close();
        }
    }

    public ClientTransport execute(Request request) throws IOException {
        return this.newTransport(HttpAddress.of((URL)request.url(), (HttpVersion)request.httpVersion())).execute(request);
    }

    public <T> CompletableFuture<T> execute(Request request, Function<HttpResponse, T> supplier) throws IOException {
        return this.newTransport(HttpAddress.of((URL)request.url(), (HttpVersion)request.httpVersion())).execute(request, supplier);
    }

    public void continuation(ClientTransport transport, Request request) throws IOException {
        ClientTransport nextTransport = this.newTransport(HttpAddress.of((URL)request.url(), (HttpVersion)request.httpVersion()));
        nextTransport.setCookieBox(transport.getCookieBox());
        nextTransport.execute(request);
        nextTransport.get();
        this.closeAndRemove(nextTransport);
    }

    public void retry(ClientTransport transport, Request request) throws IOException {
        transport.execute(request);
        transport.get();
        this.closeAndRemove(transport);
    }

    @Override
    public void close() throws IOException {
        this.shutdownGracefully();
    }

    public void shutdownGracefully() throws IOException {
        this.shutdownGracefully(30L, TimeUnit.SECONDS);
    }

    public void shutdownGracefully(long amount, TimeUnit timeUnit) throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            try {
                for (ClientTransport transport : this.transports) {
                    transport.close();
                }
                this.transports.clear();
                if (this.hasPooledConnections()) {
                    this.pool.close();
                }
                Future future = this.eventLoopGroup.shutdownGracefully(1L, amount, timeUnit);
                this.eventLoopGroup.awaitTermination(amount, timeUnit);
                future.sync();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }

    private void closeAndRemove(ClientTransport transport) throws IOException {
        try {
            transport.close();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            this.transports.remove(transport);
        }
    }

    private HttpChannelInitializer findChannelInitializer(int majorVersion, HttpAddress httpAddress, SslHandlerFactory sslHandlerFactory, HttpChannelInitializer helper) {
        for (ClientProtocolProvider<HttpChannelInitializer, ClientTransport> protocolProvider : this.protocolProviders) {
            if (!protocolProvider.supportsMajorVersion(majorVersion)) continue;
            try {
                return (HttpChannelInitializer)protocolProvider.initializerClass().getConstructor(ClientConfig.class, HttpAddress.class, SslHandlerFactory.class, HttpChannelInitializer.class).newInstance(this.clientConfig, httpAddress, sslHandlerFactory, helper);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalStateException();
            }
        }
        throw new IllegalStateException("no channel initializer found for major version " + majorVersion);
    }

    private static void initializeTrustManagerFactory(ClientConfig clientConfig) {
        TrustManagerFactory trustManagerFactory = clientConfig.getTrustManagerFactory();
        if (trustManagerFactory != null) {
            try {
                trustManagerFactory.init(clientConfig.getTrustManagerKeyStore());
            }
            catch (KeyStoreException e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }

    private static SslContext newSslContext(ClientConfig clientConfig, HttpVersion httpVersion) throws SSLException {
        SslContextBuilder sslContextBuilder = SslContextBuilder.forClient().sslProvider(clientConfig.getSslProvider()).ciphers(clientConfig.getCiphers(), clientConfig.getCipherSuiteFilter()).applicationProtocolConfig(Client.newApplicationProtocolConfig(httpVersion));
        if (clientConfig.getSslContextProvider() != null) {
            sslContextBuilder.sslContextProvider(clientConfig.getSslContextProvider());
        }
        if (clientConfig.getTrustManagerFactory() != null) {
            sslContextBuilder.trustManager(clientConfig.getTrustManagerFactory());
        }
        return sslContextBuilder.build();
    }

    private static ApplicationProtocolConfig newApplicationProtocolConfig(HttpVersion httpVersion) {
        return httpVersion.majorVersion() == 1 ? new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, new String[]{"http/1.1"}) : new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, new String[]{"h2"});
    }

    static {
        if (System.getProperty("xbib.netty.http.client.extendsystemproperties") != null) {
            NetworkUtils.extendSystemProperties();
        }
        if (System.getProperty("io.netty.noUnsafe") == null) {
            System.setProperty("io.netty.noUnsafe", Boolean.toString(true));
        }
        if (System.getProperty("io.netty.noKeySetOptimization") == null) {
            System.setProperty("io.netty.noKeySetOptimization", Boolean.toString(true));
        }
    }

    public static class Builder {
        private ByteBufAllocator byteBufAllocator;
        private EventLoopGroup eventLoopGroup;
        private Class<? extends SocketChannel> socketChannelClass;
        private ClientConfig clientConfig = new ClientConfig();

        private Builder() {
        }

        public Builder enableDebug() {
            this.clientConfig.enableDebug();
            return this;
        }

        public Builder disableDebug() {
            this.clientConfig.disableDebug();
            return this;
        }

        public Builder setByteBufAllocator(ByteBufAllocator byteBufAllocator) {
            this.byteBufAllocator = byteBufAllocator;
            return this;
        }

        public Builder setTransportProviderName(String transportProviderName) {
            this.clientConfig.setTransportProviderName(transportProviderName);
            return this;
        }

        public Builder setEventLoop(EventLoopGroup eventLoopGroup) {
            this.eventLoopGroup = eventLoopGroup;
            return this;
        }

        public Builder setChannelClass(Class<SocketChannel> socketChannelClass) {
            this.socketChannelClass = socketChannelClass;
            return this;
        }

        public Builder setThreadCount(int threadCount) {
            this.clientConfig.setThreadCount(threadCount);
            return this;
        }

        public Builder setConnectTimeoutMillis(int connectTimeoutMillis) {
            this.clientConfig.setConnectTimeoutMillis(connectTimeoutMillis);
            return this;
        }

        public Builder setTcpSendBufferSize(int tcpSendBufferSize) {
            this.clientConfig.setTcpSendBufferSize(tcpSendBufferSize);
            return this;
        }

        public Builder setTcpReceiveBufferSize(int tcpReceiveBufferSize) {
            this.clientConfig.setTcpReceiveBufferSize(tcpReceiveBufferSize);
            return this;
        }

        public Builder setTcpNodelay(boolean tcpNodelay) {
            this.clientConfig.setTcpNodelay(tcpNodelay);
            return this;
        }

        public Builder setKeepAlive(boolean keepAlive) {
            this.clientConfig.setKeepAlive(keepAlive);
            return this;
        }

        public Builder setReuseAddr(boolean reuseAddr) {
            this.clientConfig.setReuseAddr(reuseAddr);
            return this;
        }

        public Builder setMaxChunkSize(int maxChunkSize) {
            this.clientConfig.setMaxChunkSize(maxChunkSize);
            return this;
        }

        public Builder setMaxInitialLineLength(int maxInitialLineLength) {
            this.clientConfig.setMaxInitialLineLength(maxInitialLineLength);
            return this;
        }

        public Builder setMaxHeadersSize(int maxHeadersSize) {
            this.clientConfig.setMaxHeadersSize(maxHeadersSize);
            return this;
        }

        public Builder setMaxContentLength(int maxContentLength) {
            this.clientConfig.setMaxContentLength(maxContentLength);
            return this;
        }

        public Builder setMaxCompositeBufferComponents(int maxCompositeBufferComponents) {
            this.clientConfig.setMaxCompositeBufferComponents(maxCompositeBufferComponents);
            return this;
        }

        public Builder setReadTimeoutMillis(int readTimeoutMillis) {
            this.clientConfig.setReadTimeoutMillis(readTimeoutMillis);
            return this;
        }

        public Builder enableGzip(boolean enableGzip) {
            this.clientConfig.setEnableGzip(enableGzip);
            return this;
        }

        public Builder setSslProvider(SslProvider sslProvider) {
            this.clientConfig.setSslProvider(sslProvider);
            return this;
        }

        public Builder setJdkSslProvider() {
            this.clientConfig.setJdkSslProvider();
            this.clientConfig.setCiphers(SecurityUtil.Defaults.JDK_CIPHERS);
            return this;
        }

        public Builder setOpenSSLSslProvider() {
            this.clientConfig.setOpenSSLSslProvider();
            this.clientConfig.setCiphers(SecurityUtil.Defaults.OPENSSL_CIPHERS);
            return this;
        }

        public Builder setSslContextProvider(Provider provider) {
            this.clientConfig.setSslContextProvider(provider);
            return this;
        }

        public Builder setTlsProtocols(String[] protocols) {
            this.clientConfig.setProtocols(protocols);
            return this;
        }

        public Builder setCiphers(Iterable<String> ciphers) {
            this.clientConfig.setCiphers(ciphers);
            return this;
        }

        public Builder setCipherSuiteFilter(CipherSuiteFilter cipherSuiteFilter) {
            this.clientConfig.setCipherSuiteFilter(cipherSuiteFilter);
            return this;
        }

        public Builder setKeyCert(InputStream keyCertChainInputStream, InputStream keyInputStream) {
            this.clientConfig.setKeyCert(keyCertChainInputStream, keyInputStream);
            return this;
        }

        public Builder setKeyCert(InputStream keyCertChainInputStream, InputStream keyInputStream, String keyPassword) {
            this.clientConfig.setKeyCert(keyCertChainInputStream, keyInputStream, keyPassword);
            return this;
        }

        public Builder setTrustManagerFactory(TrustManagerFactory trustManagerFactory) {
            this.clientConfig.setTrustManagerFactory(trustManagerFactory);
            return this;
        }

        public Builder trustInsecure() {
            this.clientConfig.setTrustManagerFactory(InsecureTrustManagerFactory.INSTANCE);
            return this;
        }

        public Builder setClientAuthMode(ClientAuthMode clientAuthMode) {
            this.clientConfig.setClientAuthMode(clientAuthMode);
            return this;
        }

        public Builder setHttpProxyHandler(HttpProxyHandler httpProxyHandler) {
            this.clientConfig.setHttpProxyHandler(httpProxyHandler);
            return this;
        }

        public Builder addPoolNode(HttpAddress httpAddress) {
            this.clientConfig.addPoolNode(httpAddress);
            this.clientConfig.setPoolVersion(httpAddress.getVersion());
            this.clientConfig.setPoolSecure(httpAddress.isSecure());
            return this;
        }

        public Builder setPoolNodeConnectionLimit(int nodeConnectionLimit) {
            this.clientConfig.setPoolNodeConnectionLimit(nodeConnectionLimit);
            return this;
        }

        public Builder setRetriesPerPoolNode(int retriesPerNode) {
            this.clientConfig.setRetriesPerPoolNode(retriesPerNode);
            return this;
        }

        public Builder addServerNameForIdentification(String serverName) {
            this.clientConfig.addServerNameForIdentification(serverName);
            return this;
        }

        public Builder setHttp2Settings(Http2Settings http2Settings) {
            this.clientConfig.setHttp2Settings(http2Settings);
            return this;
        }

        public Builder setWriteBufferWaterMark(WriteBufferWaterMark writeBufferWaterMark) {
            this.clientConfig.setWriteBufferWaterMark(writeBufferWaterMark);
            return this;
        }

        public Builder enableNegotiation(boolean enableNegotiation) {
            this.clientConfig.setEnableNegotiation(enableNegotiation);
            return this;
        }

        public Client build() {
            return new Client(this.clientConfig, this.byteBufAllocator, this.eventLoopGroup, this.socketChannelClass);
        }
    }

    public static class SslHandlerFactory {
        private final SslContext sslContext;
        private final ClientConfig clientConfig;
        private final HttpAddress httpAddress;
        private final ByteBufAllocator allocator;

        SslHandlerFactory(SslContext sslContext, ClientConfig clientConfig, HttpAddress httpAddress, ByteBufAllocator allocator) {
            this.sslContext = sslContext;
            this.clientConfig = clientConfig;
            this.httpAddress = httpAddress;
            this.allocator = allocator;
        }

        public SslHandler create() {
            InetSocketAddress peer = this.httpAddress.getInetSocketAddress();
            SslHandler sslHandler = this.sslContext.newHandler(this.allocator, peer.getHostName(), peer.getPort());
            SSLEngine engine = sslHandler.engine();
            List<String> serverNames = this.clientConfig.getServerNamesForIdentification();
            if (serverNames.isEmpty()) {
                serverNames = Collections.singletonList(peer.getHostName());
            }
            SSLParameters params = engine.getSSLParameters();
            params.setEndpointIdentificationAlgorithm("HTTPS");
            ArrayList<SNIServerName> sniServerNames = new ArrayList<SNIServerName>();
            for (String serverName : serverNames) {
                sniServerNames.add(new SNIHostName(serverName));
            }
            params.setServerNames(sniServerNames);
            engine.setSSLParameters(params);
            switch (this.clientConfig.getClientAuthMode()) {
                case NEED: {
                    engine.setNeedClientAuth(true);
                    break;
                }
                case WANT: {
                    engine.setWantClientAuth(true);
                    break;
                }
            }
            engine.setEnabledProtocols(this.clientConfig.getProtocols());
            return sslHandler;
        }
    }

    private class ClientChannelPoolHandler
    implements ChannelPoolHandler {
        private ClientChannelPoolHandler() {
        }

        public void channelReleased(Channel channel) {
        }

        public void channelAcquired(Channel channel) {
        }

        public void channelCreated(Channel channel) throws IOException {
            HttpAddress httpAddress = (HttpAddress)channel.attr(Client.this.pool.getAttributeKey()).get();
            HttpVersion httpVersion = httpAddress.getVersion();
            SslContext sslContext = Client.newSslContext(Client.this.clientConfig, httpAddress.getVersion());
            SslHandlerFactory sslHandlerFactory = new SslHandlerFactory(sslContext, Client.this.clientConfig, httpAddress, Client.this.byteBufAllocator);
            HttpChannelInitializer initializerTwo = Client.this.findChannelInitializer(2, httpAddress, sslHandlerFactory, null);
            HttpChannelInitializer initializer = Client.this.findChannelInitializer(httpVersion.majorVersion(), httpAddress, sslHandlerFactory, initializerTwo);
            initializer.initChannel(channel);
        }
    }

    static class HttpClientThreadFactory
    implements ThreadFactory {
        private long number = 0L;

        HttpClientThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable, "org-xbib-netty-http-client-pool-" + this.number++);
            thread.setDaemon(true);
            return thread;
        }
    }
}

