/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.netty.http.client;

import io.netty.channel.WriteBufferWaterMark;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.proxy.HttpProxyHandler;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.SslProvider;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.Provider;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.TrustManagerFactory;
import org.xbib.netty.http.client.ClientAuthMode;
import org.xbib.netty.http.client.api.BackOff;
import org.xbib.netty.http.client.api.Pool;
import org.xbib.netty.http.common.HttpAddress;
import org.xbib.netty.http.common.security.SecurityUtil;

public class ClientConfig {
    private boolean debug = false;
    private LogLevel debugLogLevel = Defaults.DEFAULT_DEBUG_LOG_LEVEL;
    private String transportProviderName = Defaults.DEFAULT_TRANSPORT_PROVIDER;
    private int threadCount = 0;
    private boolean tcpNodelay = true;
    private boolean keepAlive = true;
    private boolean reuseAddr = true;
    private int tcpSendBufferSize = 65536;
    private int tcpReceiveBufferSize = 65536;
    private int maxInitialLineLength = 4096;
    private int maxHeadersSize = 8192;
    private int maxChunkSize = 8192;
    private int maxContentLength = 0x6400000;
    private int maxCompositeBufferComponents = 1024;
    private int connectTimeoutMillis = 5000;
    private int readTimeoutMillis = 5000;
    private boolean enableGzip = true;
    private SslProvider sslProvider = Defaults.SSL_PROVIDER;
    private Provider sslContextProvider = Defaults.SSL_CONTEXT_PROVIDER;
    private String[] protocols = Defaults.PROTOCOLS;
    private Iterable<String> ciphers = Defaults.CIPHERS;
    private CipherSuiteFilter cipherSuiteFilter = Defaults.CIPHER_SUITE_FILTER;
    private TrustManagerFactory trustManagerFactory = SecurityUtil.Defaults.DEFAULT_TRUST_MANAGER_FACTORY;
    private KeyStore trustManagerKeyStore = null;
    private ClientAuthMode clientAuthMode = Defaults.SSL_CLIENT_AUTH_MODE;
    private InputStream keyCertChainInputStream;
    private InputStream keyInputStream;
    private String keyPassword;
    private HttpProxyHandler httpProxyHandler;
    private List<HttpAddress> poolNodes = new ArrayList<HttpAddress>();
    private Pool.PoolKeySelectorType poolKeySelectorType = Defaults.POOL_KEY_SELECTOR_TYPE;
    private Integer poolNodeConnectionLimit;
    private Integer retriesPerPoolNode = Defaults.RETRIES_PER_NODE;
    private HttpVersion poolVersion = Defaults.POOL_VERSION;
    private Boolean poolSecure = Defaults.POOL_SECURE;
    private List<String> serverNamesForIdentification = new ArrayList<String>();
    private Http2Settings http2Settings = Defaults.HTTP2_SETTINGS;
    private WriteBufferWaterMark writeBufferWaterMark = Defaults.WRITE_BUFFER_WATER_MARK;
    private BackOff backOff = Defaults.BACK_OFF;
    private boolean enableNegotiation = Defaults.ENABLE_NEGOTIATION;

    public ClientConfig setDebug(boolean debug) {
        this.debug = debug;
        return this;
    }

    public ClientConfig enableDebug() {
        this.debug = true;
        return this;
    }

    public ClientConfig disableDebug() {
        this.debug = false;
        return this;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public ClientConfig setDebugLogLevel(LogLevel debugLogLevel) {
        this.debugLogLevel = debugLogLevel;
        return this;
    }

    public LogLevel getDebugLogLevel() {
        return this.debugLogLevel;
    }

    public ClientConfig setTransportProviderName(String transportProviderName) {
        this.transportProviderName = transportProviderName;
        return this;
    }

    public String getTransportProviderName() {
        return this.transportProviderName;
    }

    public ClientConfig setThreadCount(int threadCount) {
        this.threadCount = threadCount;
        return this;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public ClientConfig setTcpNodelay(boolean tcpNodelay) {
        this.tcpNodelay = tcpNodelay;
        return this;
    }

    public boolean isTcpNodelay() {
        return this.tcpNodelay;
    }

    public ClientConfig setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
        return this;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public ClientConfig setReuseAddr(boolean reuseAddr) {
        this.reuseAddr = reuseAddr;
        return this;
    }

    public boolean isReuseAddr() {
        return this.reuseAddr;
    }

    public ClientConfig setTcpSendBufferSize(int tcpSendBufferSize) {
        this.tcpSendBufferSize = tcpSendBufferSize;
        return this;
    }

    public int getTcpSendBufferSize() {
        return this.tcpSendBufferSize;
    }

    public ClientConfig setTcpReceiveBufferSize(int tcpReceiveBufferSize) {
        this.tcpReceiveBufferSize = tcpReceiveBufferSize;
        return this;
    }

    public int getTcpReceiveBufferSize() {
        return this.tcpReceiveBufferSize;
    }

    public ClientConfig setMaxInitialLineLength(int maxInitialLineLength) {
        this.maxInitialLineLength = maxInitialLineLength;
        return this;
    }

    public int getMaxInitialLineLength() {
        return this.maxInitialLineLength;
    }

    public ClientConfig setMaxHeadersSize(int maxHeadersSize) {
        this.maxHeadersSize = maxHeadersSize;
        return this;
    }

    public int getMaxHeadersSize() {
        return this.maxHeadersSize;
    }

    public ClientConfig setMaxChunkSize(int maxChunkSize) {
        this.maxChunkSize = maxChunkSize;
        return this;
    }

    public int getMaxChunkSize() {
        return this.maxChunkSize;
    }

    public ClientConfig setMaxContentLength(int maxContentLength) {
        this.maxContentLength = maxContentLength;
        return this;
    }

    public int getMaxContentLength() {
        return this.maxContentLength;
    }

    public ClientConfig setMaxCompositeBufferComponents(int maxCompositeBufferComponents) {
        this.maxCompositeBufferComponents = maxCompositeBufferComponents;
        return this;
    }

    public int getMaxCompositeBufferComponents() {
        return this.maxCompositeBufferComponents;
    }

    public ClientConfig setConnectTimeoutMillis(int connectTimeoutMillis) {
        this.connectTimeoutMillis = connectTimeoutMillis;
        return this;
    }

    public int getConnectTimeoutMillis() {
        return this.connectTimeoutMillis;
    }

    public ClientConfig setReadTimeoutMillis(int readTimeoutMillis) {
        this.readTimeoutMillis = readTimeoutMillis;
        return this;
    }

    public int getReadTimeoutMillis() {
        return this.readTimeoutMillis;
    }

    public ClientConfig setEnableGzip(boolean enableGzip) {
        this.enableGzip = enableGzip;
        return this;
    }

    public boolean isEnableGzip() {
        return this.enableGzip;
    }

    public ClientConfig setHttp2Settings(Http2Settings http2Settings) {
        this.http2Settings = http2Settings;
        return this;
    }

    public Http2Settings getHttp2Settings() {
        return this.http2Settings;
    }

    public ClientConfig setTrustManagerFactory(TrustManagerFactory trustManagerFactory) {
        this.trustManagerFactory = trustManagerFactory;
        return this;
    }

    public TrustManagerFactory getTrustManagerFactory() {
        return this.trustManagerFactory;
    }

    public ClientConfig setTrustManagerKeyStore(KeyStore trustManagerKeyStore) {
        this.trustManagerKeyStore = trustManagerKeyStore;
        return this;
    }

    public KeyStore getTrustManagerKeyStore() {
        return this.trustManagerKeyStore;
    }

    public ClientConfig setSslProvider(SslProvider sslProvider) {
        this.sslProvider = sslProvider;
        return this;
    }

    public SslProvider getSslProvider() {
        return this.sslProvider;
    }

    public ClientConfig setJdkSslProvider() {
        this.sslProvider = SslProvider.JDK;
        return this;
    }

    public ClientConfig setOpenSSLSslProvider() {
        this.sslProvider = SslProvider.OPENSSL;
        return this;
    }

    public ClientConfig setSslContextProvider(Provider sslContextProvider) {
        this.sslContextProvider = sslContextProvider;
        return this;
    }

    public Provider getSslContextProvider() {
        return this.sslContextProvider;
    }

    public ClientConfig setProtocols(String[] protocols) {
        this.protocols = protocols;
        return this;
    }

    public String[] getProtocols() {
        return this.protocols;
    }

    public ClientConfig setCiphers(Iterable<String> ciphers) {
        this.ciphers = ciphers;
        return this;
    }

    public Iterable<String> getCiphers() {
        return this.ciphers;
    }

    public ClientConfig setCipherSuiteFilter(CipherSuiteFilter cipherSuiteFilter) {
        this.cipherSuiteFilter = cipherSuiteFilter;
        return this;
    }

    public CipherSuiteFilter getCipherSuiteFilter() {
        return this.cipherSuiteFilter;
    }

    public ClientConfig setKeyCert(InputStream keyCertChainInputStream, InputStream keyInputStream) {
        this.keyCertChainInputStream = keyCertChainInputStream;
        this.keyInputStream = keyInputStream;
        return this;
    }

    public InputStream getKeyCertChainInputStream() {
        return this.keyCertChainInputStream;
    }

    public InputStream getKeyInputStream() {
        return this.keyInputStream;
    }

    public ClientConfig setKeyCert(InputStream keyCertChainInputStream, InputStream keyInputStream, String keyPassword) {
        this.keyCertChainInputStream = keyCertChainInputStream;
        this.keyInputStream = keyInputStream;
        this.keyPassword = keyPassword;
        return this;
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public ClientConfig setClientAuthMode(ClientAuthMode clientAuthMode) {
        this.clientAuthMode = clientAuthMode;
        return this;
    }

    public ClientAuthMode getClientAuthMode() {
        return this.clientAuthMode;
    }

    public ClientConfig setHttpProxyHandler(HttpProxyHandler httpProxyHandler) {
        this.httpProxyHandler = httpProxyHandler;
        return this;
    }

    public HttpProxyHandler getHttpProxyHandler() {
        return this.httpProxyHandler;
    }

    public ClientConfig setPoolNodes(List<HttpAddress> poolNodes) {
        this.poolNodes = poolNodes;
        return this;
    }

    public List<HttpAddress> getPoolNodes() {
        return this.poolNodes;
    }

    public ClientConfig setPoolKeySelectorType(Pool.PoolKeySelectorType poolKeySelectorType) {
        this.poolKeySelectorType = poolKeySelectorType;
        return this;
    }

    public Pool.PoolKeySelectorType getPoolKeySelectorType() {
        return this.poolKeySelectorType;
    }

    public ClientConfig addPoolNode(HttpAddress poolNodeAddress) {
        this.poolNodes.add(poolNodeAddress);
        return this;
    }

    public ClientConfig setPoolNodeConnectionLimit(Integer poolNodeConnectionLimit) {
        this.poolNodeConnectionLimit = poolNodeConnectionLimit;
        return this;
    }

    public Integer getPoolNodeConnectionLimit() {
        return this.poolNodeConnectionLimit;
    }

    public ClientConfig setRetriesPerPoolNode(Integer retriesPerPoolNode) {
        this.retriesPerPoolNode = retriesPerPoolNode;
        return this;
    }

    public Integer getRetriesPerPoolNode() {
        return this.retriesPerPoolNode;
    }

    public ClientConfig setPoolVersion(HttpVersion poolVersion) {
        this.poolVersion = poolVersion;
        return this;
    }

    public HttpVersion getPoolVersion() {
        return this.poolVersion;
    }

    public ClientConfig setPoolSecure(boolean poolSecure) {
        this.poolSecure = poolSecure;
        return this;
    }

    public boolean isPoolSecure() {
        return this.poolSecure;
    }

    public ClientConfig addServerNameForIdentification(String serverNameForIdentification) {
        this.serverNamesForIdentification.add(serverNameForIdentification);
        return this;
    }

    public List<String> getServerNamesForIdentification() {
        return this.serverNamesForIdentification;
    }

    public ClientConfig setWriteBufferWaterMark(WriteBufferWaterMark writeBufferWaterMark) {
        this.writeBufferWaterMark = writeBufferWaterMark;
        return this;
    }

    public WriteBufferWaterMark getWriteBufferWaterMark() {
        return this.writeBufferWaterMark;
    }

    public ClientConfig setBackOff(BackOff backOff) {
        this.backOff = backOff;
        return this;
    }

    public BackOff getBackOff() {
        return this.backOff;
    }

    public ClientConfig setEnableNegotiation(boolean enableNegotiation) {
        this.enableNegotiation = enableNegotiation;
        return this;
    }

    public boolean isEnableNegotiation() {
        return this.enableNegotiation;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SSL=").append(this.sslProvider).append(",SSL context provider=").append(this.sslContextProvider != null ? this.sslContextProvider.getName() : "<none>");
        return sb.toString();
    }

    static interface Defaults {
        public static final boolean DEBUG = false;
        public static final LogLevel DEFAULT_DEBUG_LOG_LEVEL = LogLevel.DEBUG;
        public static final String DEFAULT_TRANSPORT_PROVIDER = null;
        public static final int THREAD_COUNT = 0;
        public static final boolean TCP_NODELAY = true;
        public static final boolean SO_KEEPALIVE = true;
        public static final boolean SO_REUSEADDR = true;
        public static final int TCP_SEND_BUFFER_SIZE = 65536;
        public static final int TCP_RECEIVE_BUFFER_SIZE = 65536;
        public static final int MAX_CHUNK_SIZE = 8192;
        public static final int MAX_INITIAL_LINE_LENGTH = 4096;
        public static final int MAX_HEADERS_SIZE = 8192;
        public static final int MAX_CONTENT_LENGTH = 0x6400000;
        public static final int MAX_COMPOSITE_BUFFER_COMPONENTS = 1024;
        public static final int TIMEOUT_MILLIS = 5000;
        public static final boolean ENABLE_GZIP = true;
        public static final SslProvider SSL_PROVIDER = SecurityUtil.Defaults.DEFAULT_SSL_PROVIDER;
        public static final Provider SSL_CONTEXT_PROVIDER = null;
        public static final String[] PROTOCOLS = new String[]{"TLSv1.3", "TLSv1.2"};
        public static final Iterable<String> CIPHERS = SecurityUtil.Defaults.DEFAULT_CIPHERS;
        public static final CipherSuiteFilter CIPHER_SUITE_FILTER = SecurityUtil.Defaults.DEFAULT_CIPHER_SUITE_FILTER;
        public static final ClientAuthMode SSL_CLIENT_AUTH_MODE = ClientAuthMode.NONE;
        public static final Integer RETRIES_PER_NODE = 0;
        public static final HttpVersion POOL_VERSION = HttpVersion.HTTP_1_1;
        public static final Pool.PoolKeySelectorType POOL_KEY_SELECTOR_TYPE = Pool.PoolKeySelectorType.ROUNDROBIN;
        public static final Boolean POOL_SECURE = false;
        public static final Http2Settings HTTP2_SETTINGS = Http2Settings.defaultSettings();
        public static final WriteBufferWaterMark WRITE_BUFFER_WATER_MARK = WriteBufferWaterMark.DEFAULT;
        public static final BackOff BACK_OFF = BackOff.ZERO_BACKOFF;
        public static final Boolean ENABLE_NEGOTIATION = false;
    }
}

