/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.netty.http.client.cookie;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import org.xbib.netty.http.common.cookie.Cookie;
import org.xbib.netty.http.common.cookie.CookieEncoder;
import org.xbib.netty.http.common.cookie.CookieUtil;
import org.xbib.netty.http.common.cookie.DefaultCookie;

public final class ClientCookieEncoder
extends CookieEncoder {
    public static final ClientCookieEncoder STRICT = new ClientCookieEncoder(true);
    public static final ClientCookieEncoder LAX = new ClientCookieEncoder(false);
    private static final Comparator<Cookie> COOKIE_COMPARATOR = (c1, c2) -> {
        int len1;
        String path1 = c1.path();
        String path2 = c2.path();
        int len2 = path2 == null ? Integer.MAX_VALUE : path2.length();
        int diff = len2 - (len1 = path1 == null ? Integer.MAX_VALUE : path1.length());
        if (diff != 0) {
            return diff;
        }
        return -1;
    };

    private ClientCookieEncoder(boolean strict) {
        super(strict);
    }

    public String encode(String name, String value) {
        return this.encode((Cookie)new DefaultCookie(name, value));
    }

    public String encode(Cookie cookie) {
        StringBuilder buf = new StringBuilder();
        this.encode(buf, Objects.requireNonNull(cookie, "cookie"));
        return CookieUtil.stripTrailingSeparator((StringBuilder)buf);
    }

    public String encode(Cookie ... cookies) {
        if (Objects.requireNonNull(cookies, "cookies").length == 0) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        if (this.strict) {
            if (cookies.length == 1) {
                this.encode(buf, cookies[0]);
            } else {
                Cookie[] cookiesSorted = Arrays.copyOf(cookies, cookies.length);
                Arrays.sort(cookiesSorted, COOKIE_COMPARATOR);
                for (Cookie c : cookiesSorted) {
                    this.encode(buf, c);
                }
            }
        } else {
            for (Cookie c : cookies) {
                this.encode(buf, c);
            }
        }
        return CookieUtil.stripTrailingSeparatorOrNull((StringBuilder)buf);
    }

    public String encode(Collection<? extends Cookie> cookies) {
        if (Objects.requireNonNull(cookies, "cookies").isEmpty()) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        if (this.strict) {
            if (cookies.size() == 1) {
                this.encode(buf, cookies.iterator().next());
            } else {
                Cookie[] cookiesSorted = cookies.toArray(new Cookie[cookies.size()]);
                Arrays.sort(cookiesSorted, COOKIE_COMPARATOR);
                for (Cookie c : cookiesSorted) {
                    this.encode(buf, c);
                }
            }
        } else {
            for (Cookie cookie : cookies) {
                this.encode(buf, cookie);
            }
        }
        return CookieUtil.stripTrailingSeparatorOrNull((StringBuilder)buf);
    }

    public String encode(Iterable<? extends Cookie> cookies) {
        Iterator<? extends Cookie> cookiesIt = Objects.requireNonNull(cookies, "cookies").iterator();
        if (!cookiesIt.hasNext()) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        if (this.strict) {
            Cookie firstCookie = cookiesIt.next();
            if (!cookiesIt.hasNext()) {
                this.encode(buf, firstCookie);
            } else {
                ArrayList<Cookie> cookiesList = new ArrayList<Cookie>();
                cookiesList.add(firstCookie);
                while (cookiesIt.hasNext()) {
                    cookiesList.add(cookiesIt.next());
                }
                Cookie[] cookiesSorted = cookiesList.toArray(new Cookie[0]);
                Arrays.sort(cookiesSorted, COOKIE_COMPARATOR);
                for (Cookie c : cookiesSorted) {
                    this.encode(buf, c);
                }
            }
        } else {
            while (cookiesIt.hasNext()) {
                this.encode(buf, cookiesIt.next());
            }
        }
        return CookieUtil.stripTrailingSeparatorOrNull((StringBuilder)buf);
    }

    public void encode(StringBuilder buf, Cookie c) {
        String name = c.name();
        String value = c.value() != null ? c.value() : "";
        this.validateCookie(name, value);
        if (c.wrap()) {
            CookieUtil.addQuoted((StringBuilder)buf, (String)name, (String)value);
        } else {
            CookieUtil.add((StringBuilder)buf, (String)name, (String)value);
        }
    }
}

