/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.netty.http.client.handler.http;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xbib.netty.http.client.Client;
import org.xbib.netty.http.client.ClientConfig;
import org.xbib.netty.http.client.handler.http.HttpResponseHandler;
import org.xbib.netty.http.client.handler.http.TrafficLoggingHandler;
import org.xbib.netty.http.client.handler.http2.Http2ChannelInitializer;
import org.xbib.netty.http.common.HttpAddress;
import org.xbib.netty.http.common.HttpChannelInitializer;

public class Http1ChannelInitializer
extends ChannelInitializer<Channel>
implements HttpChannelInitializer {
    private static final Logger logger = Logger.getLogger(Http1ChannelInitializer.class.getName());
    private final ClientConfig clientConfig;
    private final HttpAddress httpAddress;
    private final Client.SslHandlerFactory sslHandlerFactory;
    private final HttpResponseHandler httpResponseHandler;
    private final Http2ChannelInitializer http2ChannelInitializer;

    public Http1ChannelInitializer(ClientConfig clientConfig, HttpAddress httpAddress, Client.SslHandlerFactory sslHandlerFactory, HttpChannelInitializer http2ChannelInitializer) {
        this.clientConfig = clientConfig;
        this.httpAddress = httpAddress;
        this.sslHandlerFactory = sslHandlerFactory;
        this.http2ChannelInitializer = (Http2ChannelInitializer)http2ChannelInitializer;
        this.httpResponseHandler = new HttpResponseHandler();
    }

    public void initChannel(Channel channel) {
        if (this.clientConfig.isDebug()) {
            channel.pipeline().addLast(new ChannelHandler[]{new TrafficLoggingHandler(LogLevel.DEBUG)});
        }
        if (this.httpAddress.isSecure()) {
            this.configureEncrypted(channel);
        } else {
            this.configureCleartext(channel);
        }
        if (this.clientConfig.isDebug()) {
            logger.log(Level.FINE, "HTTP 1.1 client channel initialized:  address=" + this.httpAddress + " pipeline=" + channel.pipeline().names());
        }
    }

    private void configureEncrypted(Channel channel) {
        ChannelPipeline pipeline = channel.pipeline();
        SslHandler sslHandler = this.sslHandlerFactory.create();
        pipeline.addLast("client-ssl-handler", (ChannelHandler)sslHandler);
        if (this.clientConfig.isEnableNegotiation()) {
            ApplicationProtocolNegotiationHandler negotiationHandler = new ApplicationProtocolNegotiationHandler("http/1.1"){

                protected void configurePipeline(ChannelHandlerContext ctx, String protocol) {
                    if ("h2".equals(protocol)) {
                        Http1ChannelInitializer.this.http2ChannelInitializer.configureCleartext(ctx.channel());
                        if (Http1ChannelInitializer.this.clientConfig.isDebug()) {
                            logger.log(Level.FINE, "after negotiation to HTTP/2: " + ctx.pipeline().names());
                        }
                        return;
                    }
                    if ("http/1.1".equals(protocol)) {
                        Http1ChannelInitializer.this.configureCleartext(ctx.channel());
                        if (Http1ChannelInitializer.this.clientConfig.isDebug()) {
                            logger.log(Level.FINE, "after negotiation to HTTP 1.1: " + ctx.pipeline().names());
                        }
                        return;
                    }
                    ctx.close();
                    throw new IllegalStateException("protocol not accepted: " + protocol);
                }
            };
            channel.pipeline().addLast("client-negotiation", (ChannelHandler)negotiationHandler);
        } else {
            this.configureCleartext(channel);
        }
    }

    private void configureCleartext(Channel channel) {
        ChannelPipeline pipeline = channel.pipeline();
        pipeline.addLast("http-client-chunk-writer", (ChannelHandler)new ChunkedWriteHandler());
        pipeline.addLast("http-client-codec", (ChannelHandler)new HttpClientCodec(this.clientConfig.getMaxInitialLineLength(), this.clientConfig.getMaxHeadersSize(), this.clientConfig.getMaxChunkSize()));
        if (this.clientConfig.isEnableGzip()) {
            pipeline.addLast("http-client-decompressor", (ChannelHandler)new HttpContentDecompressor());
        }
        HttpObjectAggregator httpObjectAggregator = new HttpObjectAggregator(this.clientConfig.getMaxContentLength(), false);
        httpObjectAggregator.setMaxCumulationBufferComponents(this.clientConfig.getMaxCompositeBufferComponents());
        pipeline.addLast("http-client-aggregator", (ChannelHandler)httpObjectAggregator);
        pipeline.addLast("http-client-handler", (ChannelHandler)this.httpResponseHandler);
    }
}

