/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.netty.http.client.handler.http2;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http2.DefaultHttp2SettingsFrame;
import io.netty.handler.codec.http2.Http2ConnectionPrefaceAndSettingsFrameWrittenEvent;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2MultiplexCodec;
import io.netty.handler.codec.http2.Http2MultiplexCodecBuilder;
import io.netty.handler.logging.LogLevel;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xbib.netty.http.client.Client;
import org.xbib.netty.http.client.ClientConfig;
import org.xbib.netty.http.client.api.ClientTransport;
import org.xbib.netty.http.client.handler.http.TrafficLoggingHandler;
import org.xbib.netty.http.common.HttpAddress;
import org.xbib.netty.http.common.HttpChannelInitializer;

public class Http2ChannelInitializer
extends ChannelInitializer<Channel>
implements HttpChannelInitializer {
    private static final Logger logger = Logger.getLogger(Http2ChannelInitializer.class.getName());
    private final ClientConfig clientConfig;
    private final HttpAddress httpAddress;
    private final Client.SslHandlerFactory sslHandlerFactory;

    public Http2ChannelInitializer(ClientConfig clientConfig, HttpAddress httpAddress, Client.SslHandlerFactory sslHandlerFactory, HttpChannelInitializer unusedInitializer) {
        this.clientConfig = clientConfig;
        this.httpAddress = httpAddress;
        this.sslHandlerFactory = sslHandlerFactory;
    }

    public void initChannel(Channel channel) {
        if (this.clientConfig.isDebug()) {
            channel.pipeline().addLast(new ChannelHandler[]{new TrafficLoggingHandler(LogLevel.DEBUG)});
        }
        if (this.httpAddress.isSecure()) {
            this.configureEncrypted(channel);
        } else {
            this.configureCleartext(channel);
        }
        if (this.clientConfig.isDebug()) {
            logger.log(Level.FINE, "HTTP/2 client channel initialized:  address=" + this.httpAddress + " pipeline=" + channel.pipeline().names());
        }
    }

    private void configureEncrypted(Channel channel) {
        channel.pipeline().addLast(new ChannelHandler[]{this.sslHandlerFactory.create()});
        this.configureCleartext(channel);
    }

    public void configureCleartext(Channel ch) {
        ChannelInitializer<Channel> initializer = new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) {
                throw new IllegalStateException();
            }
        };
        Http2MultiplexCodecBuilder multiplexCodecBuilder = Http2MultiplexCodecBuilder.forClient((ChannelHandler)initializer).initialSettings(this.clientConfig.getHttp2Settings());
        if (this.clientConfig.isDebug()) {
            multiplexCodecBuilder.frameLogger((Http2FrameLogger)new PushPromiseHandler(LogLevel.DEBUG, "client"));
        }
        Http2MultiplexCodec multiplexCodec = multiplexCodecBuilder.autoAckSettingsFrame(true).build();
        ChannelPipeline pipeline = ch.pipeline();
        pipeline.addLast("client-multiplex", (ChannelHandler)multiplexCodec);
        pipeline.addLast("client-messages", (ChannelHandler)new ClientMessages());
    }

    static class PushPromiseHandler
    extends Http2FrameLogger {
        PushPromiseHandler(LogLevel level, String name) {
            super(level, name);
        }

        public void logPushPromise(Http2FrameLogger.Direction direction, ChannelHandlerContext ctx, int streamId, int promisedStreamId, Http2Headers headers, int padding) {
            super.logPushPromise(direction, ctx, streamId, promisedStreamId, headers, padding);
            ClientTransport transport = (ClientTransport)ctx.channel().attr(ClientTransport.TRANSPORT_ATTRIBUTE_KEY).get();
            if (transport != null) {
                transport.pushPromiseReceived(ctx.channel(), Integer.valueOf(streamId), Integer.valueOf(promisedStreamId), headers);
            }
        }
    }

    static class ClientMessages
    extends ChannelInboundHandlerAdapter {
        ClientMessages() {
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            if (msg instanceof DefaultHttp2SettingsFrame) {
                DefaultHttp2SettingsFrame settingsFrame = (DefaultHttp2SettingsFrame)msg;
                ClientTransport transport = (ClientTransport)ctx.channel().attr(ClientTransport.TRANSPORT_ATTRIBUTE_KEY).get();
                if (transport != null) {
                    transport.settingsReceived(settingsFrame.settings());
                }
            } else {
                logger.log(Level.FINE, "received msg " + msg.getClass().getName());
            }
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            if (evt instanceof Http2ConnectionPrefaceAndSettingsFrameWrittenEvent) {
                Http2ConnectionPrefaceAndSettingsFrameWrittenEvent event = (Http2ConnectionPrefaceAndSettingsFrameWrittenEvent)evt;
                ClientTransport transport = (ClientTransport)ctx.channel().attr(ClientTransport.TRANSPORT_ATTRIBUTE_KEY).get();
                if (transport != null) {
                    transport.settingsReceived(null);
                }
            }
            ctx.fireUserEventTriggered(evt);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            ClientTransport transport = (ClientTransport)ctx.channel().attr(ClientTransport.TRANSPORT_ATTRIBUTE_KEY).get();
            if (transport != null) {
                transport.fail(ctx.channel(), cause);
            }
        }
    }
}

