/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.netty.http.client.handler.http2;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http2.HttpConversionUtil;
import org.xbib.netty.http.client.api.ClientTransport;

@ChannelHandler.Sharable
public class Http2ResponseHandler
extends SimpleChannelInboundHandler<FullHttpResponse> {
    protected void channelRead0(ChannelHandlerContext ctx, FullHttpResponse httpResponse) throws Exception {
        Integer streamId = httpResponse.headers().getInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text());
        ClientTransport transport = (ClientTransport)ctx.channel().attr(ClientTransport.TRANSPORT_ATTRIBUTE_KEY).get();
        if (transport != null) {
            transport.responseReceived(ctx.channel(), streamId, httpResponse);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        ctx.fireChannelInactive();
        ClientTransport transport = (ClientTransport)ctx.channel().attr(ClientTransport.TRANSPORT_ATTRIBUTE_KEY).get();
        if (transport != null) {
            transport.inactive(ctx.channel());
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        ctx.fireExceptionCaught(cause);
        ClientTransport transport = (ClientTransport)ctx.channel().attr(ClientTransport.TRANSPORT_ATTRIBUTE_KEY).get();
        if (transport != null) {
            transport.fail(ctx.channel(), cause);
        }
    }
}

