/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.netty.http.client.transport;

import io.netty.channel.Channel;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.ssl.SslHandler;
import java.io.IOException;
import java.net.ConnectException;
import java.nio.charset.MalformedInputException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnmappableCharacterException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.net.ssl.SSLSession;
import org.xbib.net.PercentDecoder;
import org.xbib.net.URL;
import org.xbib.net.URLSyntaxException;
import org.xbib.netty.http.client.Client;
import org.xbib.netty.http.client.api.BackOff;
import org.xbib.netty.http.client.api.ClientTransport;
import org.xbib.netty.http.client.api.Request;
import org.xbib.netty.http.client.transport.Flow;
import org.xbib.netty.http.common.HttpAddress;
import org.xbib.netty.http.common.HttpResponse;
import org.xbib.netty.http.common.cookie.Cookie;
import org.xbib.netty.http.common.cookie.CookieBox;

public abstract class BaseTransport
implements ClientTransport {
    private static final Logger logger = Logger.getLogger(BaseTransport.class.getName());
    protected final Client client;
    protected final HttpAddress httpAddress;
    protected Throwable throwable;
    private static final Request DUMMY = Request.builder((HttpMethod)HttpMethod.GET).build();
    private final Map<Request, Channel> channels;
    private SSLSession sslSession;
    public final Map<String, Flow> flowMap;
    protected final SortedMap<String, Request> requests;
    private CookieBox cookieBox;
    protected HttpDataFactory httpDataFactory;

    public BaseTransport(Client client, HttpAddress httpAddress) {
        this.client = client;
        this.httpAddress = httpAddress;
        this.channels = new ConcurrentHashMap<Request, Channel>();
        this.flowMap = new ConcurrentHashMap<String, Flow>();
        this.requests = new ConcurrentSkipListMap<String, Request>();
        this.httpDataFactory = new DefaultHttpDataFactory();
    }

    public HttpAddress getHttpAddress() {
        return this.httpAddress;
    }

    public <T> CompletableFuture<T> execute(Request request, Function<HttpResponse, T> supplier) throws IOException {
        Objects.requireNonNull(supplier);
        CompletableFuture completableFuture = new CompletableFuture();
        request.setResponseListener(response -> {
            if (response != null) {
                completableFuture.complete(supplier.apply(response));
            } else {
                completableFuture.cancel(true);
            }
        });
        this.execute(request);
        return completableFuture;
    }

    public void close() {
        this.get();
        this.cancel();
    }

    public boolean isFailed() {
        return this.throwable != null;
    }

    public Throwable getFailure() {
        return this.throwable;
    }

    public void fail(Channel channel, Throwable throwable) {
        if (this.throwable != null) {
            return;
        }
        this.throwable = throwable;
        logger.log(Level.SEVERE, "channel " + channel + " failing: " + throwable.getMessage(), throwable);
        for (Flow flow : this.flowMap.values()) {
            flow.fail(throwable);
        }
    }

    public void inactive(Channel channel) {
    }

    public ClientTransport get() {
        return this.get(this.client.getClientConfig().getReadTimeoutMillis(), TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientTransport get(long value, TimeUnit timeUnit) {
        if (!this.flowMap.isEmpty()) {
            for (Map.Entry<String, Flow> entry : this.flowMap.entrySet()) {
                Flow flow = entry.getValue();
                if (flow.isClosed()) continue;
                for (Integer key : flow.keys()) {
                    String requestKey = this.getRequestKey(entry.getKey(), key);
                    try {
                        flow.get(key).get(value, timeUnit);
                        this.completeRequest(requestKey);
                    }
                    catch (Exception e) {
                        this.completeRequestExceptionally(requestKey, e);
                        flow.fail(e);
                    }
                    finally {
                        flow.remove(key);
                    }
                }
                flow.close();
            }
            this.flowMap.clear();
        }
        this.channels.values().forEach(channel -> {
            try {
                this.client.releaseChannel((Channel)channel, true);
            }
            catch (IOException e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        });
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        if (!this.flowMap.isEmpty()) {
            for (Map.Entry<String, Flow> entry : this.flowMap.entrySet()) {
                Flow flow = entry.getValue();
                for (Integer key : flow.keys()) {
                    try {
                        flow.get(key).cancel(true);
                    }
                    catch (Exception e) {
                        this.completeRequestExceptionally(this.getRequestKey(entry.getKey(), key), e);
                        flow.fail(e);
                    }
                    finally {
                        flow.remove(key);
                    }
                }
                flow.close();
            }
        }
        this.channels.values().forEach(channel -> {
            try {
                this.client.releaseChannel((Channel)channel, true);
            }
            catch (IOException e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        });
        this.flowMap.clear();
        this.channels.clear();
        this.requests.clear();
        this.httpDataFactory.cleanAllHttpData();
    }

    public SSLSession getSession() {
        return this.sslSession;
    }

    protected abstract String getRequestKey(String var1, Integer var2);

    Channel mapChannel(Request request) throws IOException {
        Channel channel;
        if (!this.client.hasPooledConnections()) {
            channel = this.channels.get(DUMMY);
            if (channel == null) {
                channel = this.switchNextChannel();
            }
            this.channels.put(DUMMY, channel);
        } else {
            channel = this.switchNextChannel();
            this.channels.put(request, channel);
        }
        SslHandler sslHandler = (SslHandler)channel.pipeline().get(SslHandler.class);
        this.sslSession = sslHandler != null ? sslHandler.engine().getSession() : null;
        return channel;
    }

    private Channel switchNextChannel() throws IOException {
        Channel channel = this.client.newChannel(this.httpAddress);
        if (channel == null) {
            ConnectException connectException = this.httpAddress != null ? new ConnectException("unable to connect to " + this.httpAddress) : (this.client.hasPooledConnections() ? new ConnectException("unable to get channel from pool") : new ConnectException("unable to get channel"));
            this.throwable = connectException;
            throw connectException;
        }
        channel.attr(TRANSPORT_ATTRIBUTE_KEY).set((Object)this);
        this.waitForSettings();
        return channel;
    }

    protected Request continuation(Request request, HttpResponse httpResponse) throws URLSyntaxException {
        if (httpResponse == null) {
            return null;
        }
        if (request == null) {
            return null;
        }
        try {
            if (request.canRedirect()) {
                int status = httpResponse.getStatus().getCode();
                switch (status) {
                    case 300: 
                    case 301: 
                    case 302: 
                    case 303: 
                    case 305: 
                    case 307: 
                    case 308: {
                        String location = httpResponse.getHeaders().getHeader((CharSequence)HttpHeaderNames.LOCATION);
                        location = new PercentDecoder(StandardCharsets.UTF_8.newDecoder()).decode((CharSequence)location);
                        if (location == null) break;
                        logger.log(Level.FINE, "found redirect location: " + location);
                        URL redirUrl = URL.base((URL)request.url()).resolve(location);
                        HttpMethod method = httpResponse.getStatus().getCode() == 303 ? HttpMethod.GET : request.httpMethod();
                        Request.Builder newHttpRequestBuilder = Request.builder((HttpMethod)method, (Request)request).url(redirUrl);
                        request.url().getQueryParams().forEach(pair -> newHttpRequestBuilder.addParameter((String)pair.getFirst(), pair.getSecond()));
                        request.cookies().forEach(arg_0 -> ((Request.Builder)newHttpRequestBuilder).addCookie(arg_0));
                        Request newHttpRequest = newHttpRequestBuilder.build();
                        StringBuilder hostAndPort = new StringBuilder();
                        hostAndPort.append(redirUrl.getHost());
                        if (redirUrl.getPort() != null) {
                            hostAndPort.append(':').append(redirUrl.getPort());
                        }
                        newHttpRequest.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)hostAndPort.toString());
                        logger.log(Level.FINE, "redirect url: " + redirUrl);
                        return newHttpRequest;
                    }
                }
            }
        }
        catch (MalformedInputException | UnmappableCharacterException e) {
            this.throwable = e;
        }
        return null;
    }

    protected Request retry(Request request, HttpResponse httpResponse) {
        if (httpResponse == null) {
            return null;
        }
        if (request == null) {
            return null;
        }
        if (request.isBackOff()) {
            BackOff backOff = request.getBackOff() != null ? request.getBackOff() : this.client.getClientConfig().getBackOff();
            int status = httpResponse.getStatus().getCode();
            switch (status) {
                case 403: 
                case 404: 
                case 500: 
                case 502: 
                case 503: 
                case 504: 
                case 507: 
                case 509: {
                    long millis;
                    if (backOff == null || (millis = backOff.nextBackOffMillis()) == -1L) break;
                    logger.log(Level.FINE, () -> "status = " + status + " backing off request by " + millis + " milliseconds");
                    try {
                        Thread.sleep(millis);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    return request;
                }
            }
        }
        return null;
    }

    private void completeRequest(String requestKey) {
        Request request;
        if (requestKey != null && (request = (Request)this.requests.get(requestKey)) != null && request.getCompletableFuture() != null) {
            request.getCompletableFuture().complete(request);
        }
    }

    private void completeRequestExceptionally(String requestKey, Throwable throwable) {
        Request request;
        if (requestKey != null && (request = (Request)this.requests.get(requestKey)) != null && request.getCompletableFuture() != null) {
            request.getCompletableFuture().completeExceptionally(throwable);
        }
    }

    public void setCookieBox(CookieBox cookieBox) {
        this.cookieBox = cookieBox;
    }

    public CookieBox getCookieBox() {
        return this.cookieBox;
    }

    void addCookie(Cookie cookie) {
        if (this.cookieBox == null) {
            this.cookieBox = new CookieBox(32);
        }
        this.cookieBox.put((Object)cookie, (Object)true);
    }

    List<Cookie> matchCookiesFromBox(Request request) {
        return this.cookieBox == null ? Collections.emptyList() : this.cookieBox.keySet().stream().filter(cookie -> this.matchCookie(request.url(), (Cookie)cookie)).collect(Collectors.toList());
    }

    List<Cookie> matchCookies(Request request) {
        return request.cookies().stream().filter(cookie -> this.matchCookie(request.url(), (Cookie)cookie)).collect(Collectors.toList());
    }

    private boolean matchCookie(URL url, Cookie cookie) {
        boolean pathMatch;
        boolean domainMatch;
        boolean bl = domainMatch = cookie.domain() == null || url.getHost().endsWith(cookie.domain());
        if (!domainMatch) {
            return false;
        }
        boolean bl2 = pathMatch = "/".equals(cookie.path()) || url.getPath().startsWith(cookie.path());
        if (!pathMatch) {
            return false;
        }
        boolean secureScheme = "https".equals(url.getScheme());
        return secureScheme && cookie.isSecure() || !secureScheme && !cookie.isSecure();
    }
}

