/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.netty.http.client.transport;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http2.DefaultHttp2DataFrame;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.DefaultHttp2HeadersFrame;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2StreamChannel;
import io.netty.handler.codec.http2.Http2StreamChannelBootstrap;
import io.netty.handler.codec.http2.Http2StreamFrameToHttpObjectCodec;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.util.AsciiString;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xbib.net.URLSyntaxException;
import org.xbib.netty.http.client.Client;
import org.xbib.netty.http.client.api.ClientTransport;
import org.xbib.netty.http.client.api.Request;
import org.xbib.netty.http.client.cookie.ClientCookieDecoder;
import org.xbib.netty.http.client.cookie.ClientCookieEncoder;
import org.xbib.netty.http.client.handler.http2.Http2ResponseHandler;
import org.xbib.netty.http.client.transport.BaseTransport;
import org.xbib.netty.http.client.transport.Flow;
import org.xbib.netty.http.common.DefaultHttpResponse;
import org.xbib.netty.http.common.HttpAddress;
import org.xbib.netty.http.common.HttpResponse;
import org.xbib.netty.http.common.cookie.Cookie;

public class Http2Transport
extends BaseTransport {
    private static final Logger logger = Logger.getLogger(Http2Transport.class.getName());
    private CompletableFuture<Boolean> settingsPromise;
    private final ChannelInitializer<Channel> initializer;

    public Http2Transport(final Client client, HttpAddress httpAddress) {
        super(client, httpAddress);
        this.settingsPromise = httpAddress != null ? new CompletableFuture() : null;
        final Http2Transport transport = this;
        this.initializer = new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) {
                ch.attr(ClientTransport.TRANSPORT_ATTRIBUTE_KEY).set((Object)transport);
                ChannelPipeline p = ch.pipeline();
                p.addLast("child-client-frame-converter", (ChannelHandler)new Http2StreamFrameToHttpObjectCodec(false));
                p.addLast("child-client-decompressor", (ChannelHandler)new HttpContentDecompressor());
                p.addLast("child-client-chunk-aggregator", (ChannelHandler)new HttpObjectAggregator(client.getClientConfig().getMaxContentLength()));
                p.addLast("child-client-response-handler", (ChannelHandler)new Http2ResponseHandler());
            }
        };
    }

    public ClientTransport execute(Request request) throws IOException {
        Channel channel = this.mapChannel(request);
        if (this.throwable != null) {
            return this;
        }
        String channelId = channel.id().toString();
        this.flowMap.putIfAbsent(channelId, new Flow());
        Http2StreamChannel childChannel = (Http2StreamChannel)new Http2StreamChannelBootstrap(channel).handler(this.initializer).open().syncUninterruptibly().getNow();
        AsciiString method = request.httpMethod().asciiName();
        String scheme = request.url().getScheme();
        String authority = request.url().getHost() + (String)(request.url().getPort() != null ? ":" + request.url().getPort() : "");
        String path = request.relative().isEmpty() ? "/" : request.relative();
        Http2Headers http2Headers = new DefaultHttp2Headers().method((CharSequence)method).scheme((CharSequence)scheme).authority((CharSequence)authority).path((CharSequence)path);
        Integer streamId = ((Flow)this.flowMap.get(channelId)).nextStreamId();
        if (streamId == null) {
            throw new IllegalStateException();
        }
        this.requests.put(this.getRequestKey(channelId, streamId), request);
        http2Headers.setInt((Object)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), streamId.intValue());
        ArrayList<Cookie> cookies = new ArrayList<Cookie>();
        cookies.addAll(this.matchCookiesFromBox(request));
        cookies.addAll(this.matchCookies(request));
        if (!cookies.isEmpty()) {
            request.headers().set((CharSequence)HttpHeaderNames.COOKIE, (Object)ClientCookieEncoder.STRICT.encode((Collection<? extends Cookie>)cookies));
        }
        HttpConversionUtil.toHttp2Headers((HttpHeaders)request.headers(), (Http2Headers)http2Headers);
        boolean hasContent = request.content() != null && request.content().readableBytes() > 0;
        DefaultHttp2HeadersFrame headersFrame = new DefaultHttp2HeadersFrame(http2Headers, !hasContent);
        childChannel.write((Object)headersFrame);
        if (hasContent) {
            DefaultHttp2DataFrame dataFrame = new DefaultHttp2DataFrame(request.content(), true);
            childChannel.write((Object)dataFrame);
        }
        childChannel.flush();
        this.client.getRequestCounter().incrementAndGet();
        if (this.client.hasPooledConnections()) {
            this.client.releaseChannel(channel, false);
        }
        return this;
    }

    public void settingsReceived(Http2Settings http2Settings) {
        if (this.settingsPromise != null) {
            this.settingsPromise.complete(true);
        } else {
            logger.log(Level.WARNING, "settings received but no promise present");
        }
    }

    public void waitForSettings() {
        if (this.settingsPromise != null) {
            try {
                this.settingsPromise.get(this.client.getClientConfig().getReadTimeoutMillis(), TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                logger.log(Level.WARNING, "timeout in client while waiting for settings");
                this.settingsPromise.completeExceptionally(e);
            }
            catch (InterruptedException | ExecutionException e) {
                this.settingsPromise.completeExceptionally(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void responseReceived(Channel channel, Integer streamId, FullHttpResponse fullHttpResponse) {
        block25: {
            if (this.throwable != null) {
                logger.log(Level.WARNING, "throwable is not null?", this.throwable);
                return;
            }
            if (streamId == null) {
                logger.log(Level.WARNING, "stream ID is null?");
                return;
            }
            DefaultHttpResponse httpResponse = null;
            this.client.getResponseCounter().incrementAndGet();
            try {
                String channelId = channel.id().toString();
                int pos = channelId.indexOf(47);
                channelId = pos > 0 ? channelId.substring(0, pos) : channelId;
                Flow flow = (Flow)this.flowMap.get(channelId);
                if (flow == null) {
                    if (logger.isLoggable(Level.WARNING)) {
                        logger.log(Level.WARNING, "flow is null? channelId = " + channelId);
                    }
                    return;
                }
                Request request = (Request)this.requests.remove(this.getRequestKey(channelId, streamId));
                if (request == null) {
                    CompletableFuture<Boolean> promise;
                    if (logger.isLoggable(Level.WARNING)) {
                        logger.log(Level.WARNING, "request is null? channelId = " + channelId + " streamId = " + streamId);
                    }
                    if ((promise = flow.get(streamId)) != null) {
                        promise.completeExceptionally(new IllegalStateException("no request"));
                    }
                    break block25;
                }
                for (String cookieString : fullHttpResponse.headers().getAll((CharSequence)HttpHeaderNames.SET_COOKIE)) {
                    Cookie cookie = ClientCookieDecoder.STRICT.decode(cookieString);
                    this.addCookie(cookie);
                }
                httpResponse = new DefaultHttpResponse(this.httpAddress, fullHttpResponse, this.getCookieBox());
                CompletableFuture<Boolean> promise = flow.get(streamId);
                try {
                    request.onResponse((HttpResponse)httpResponse);
                    Request retryRequest = this.retry(request, (HttpResponse)httpResponse);
                    if (retryRequest != null) {
                        this.client.retry(this, retryRequest);
                    } else {
                        Request continueRequest = this.continuation(request, (HttpResponse)httpResponse);
                        if (continueRequest != null) {
                            this.client.continuation(this, continueRequest);
                        }
                    }
                    if (promise != null) {
                        promise.complete(true);
                    } else {
                        logger.log(Level.FINE, "promise is null, flow lost");
                    }
                }
                catch (IOException | URLSyntaxException e) {
                    if (promise != null) {
                        promise.completeExceptionally(e);
                    } else {
                        logger.log(Level.FINE, "promise is null, can't abort flow");
                    }
                }
                finally {
                    flow.remove(streamId);
                }
            }
            finally {
                if (httpResponse != null) {
                    httpResponse.release();
                }
            }
        }
    }

    public void pushPromiseReceived(Channel channel, Integer streamId, Integer promisedStreamId, Http2Headers headers) {
        String channelId = channel.id().toString();
        ((Flow)this.flowMap.get(channelId)).put(promisedStreamId, new CompletableFuture<Boolean>());
        String requestKey = this.getRequestKey(channel.id().toString(), streamId);
        this.requests.put(requestKey, (Request)this.requests.get(requestKey));
    }

    @Override
    protected String getRequestKey(String channelId, Integer streamId) {
        return channelId + "#" + streamId;
    }
}

