/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.netty.http.client.cookie;

import java.time.Instant;
import java.util.Locale;
import java.util.Objects;
import org.xbib.netty.http.common.cookie.Cookie;
import org.xbib.netty.http.common.cookie.CookieDecoder;
import org.xbib.netty.http.common.cookie.DefaultCookie;
import org.xbib.netty.http.common.cookie.SameSite;
import org.xbib.netty.http.common.util.DateTimeUtil;

public final class ClientCookieDecoder
extends CookieDecoder {
    public static final ClientCookieDecoder STRICT = new ClientCookieDecoder(true);
    public static final ClientCookieDecoder LAX = new ClientCookieDecoder(false);

    private ClientCookieDecoder(boolean strict) {
        super(strict);
    }

    public Cookie decode(String header) {
        int headerLen = Objects.requireNonNull(header, "header").length();
        if (headerLen == 0) {
            throw new IllegalArgumentException("header length is 0");
        }
        CookieBuilder cookieBuilder = null;
        int i = 0;
        while (i < headerLen) {
            char c;
            block4: while (i < headerLen && (c = header.charAt(i)) != ',') {
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\u000b': 
                    case '\f': 
                    case '\r': 
                    case ' ': 
                    case ';': {
                        ++i;
                        continue block4;
                    }
                }
            }
            int nameBegin = i;
            int nameEnd = 0;
            int valueBegin = 0;
            int valueEnd = 0;
            while (i < headerLen) {
                char curChar = header.charAt(i);
                if (curChar == ';') {
                    nameEnd = i;
                    valueEnd = -1;
                    valueBegin = -1;
                    break;
                }
                if (curChar == '=') {
                    nameEnd = i++;
                    if (i == headerLen) {
                        valueEnd = 0;
                        valueBegin = 0;
                        break;
                    }
                    valueBegin = i;
                    int semiPos = header.indexOf(59, i);
                    i = semiPos > 0 ? semiPos : headerLen;
                    valueEnd = i;
                    break;
                }
                if (++i != headerLen) continue;
                nameEnd = headerLen;
                valueEnd = -1;
                valueBegin = -1;
                break;
            }
            if (valueEnd > 0 && header.charAt(valueEnd - 1) == ',') {
                --valueEnd;
            }
            if (nameEnd < nameBegin || valueEnd < valueBegin) continue;
            if (cookieBuilder == null) {
                DefaultCookie cookie = this.initCookie(header, nameBegin, nameEnd, valueBegin, valueEnd);
                if (cookie == null) {
                    return null;
                }
                cookieBuilder = new CookieBuilder(cookie, header);
                continue;
            }
            cookieBuilder.appendAttribute(nameBegin, nameEnd, valueBegin, valueEnd);
        }
        if (cookieBuilder == null) {
            throw new IllegalArgumentException("no cookie found");
        }
        return cookieBuilder.cookie();
    }

    private static class CookieBuilder {
        private final String header;
        private final DefaultCookie cookie;
        private String domain;
        private String path;
        private long maxAge = Long.MIN_VALUE;
        private int expiresStart;
        private int expiresEnd;
        private boolean secure;
        private boolean httpOnly;
        private SameSite sameSite = SameSite.STRICT;

        CookieBuilder(DefaultCookie cookie, String header) {
            this.cookie = cookie;
            this.header = header;
        }

        Cookie cookie() {
            this.cookie.setDomain(this.domain);
            this.cookie.setPath(this.path);
            this.cookie.setMaxAge(this.mergeMaxAgeAndExpires());
            this.cookie.setSecure(this.secure);
            this.cookie.setHttpOnly(this.httpOnly);
            this.cookie.setSameSite(this.sameSite);
            return this.cookie;
        }

        void appendAttribute(int keyStart, int keyEnd, int valueStart, int valueEnd) {
            int length = keyEnd - keyStart;
            if (length == 4) {
                this.parse4(keyStart, valueStart, valueEnd);
            } else if (length == 6) {
                this.parse6(keyStart, valueStart, valueEnd);
            } else if (length == 7) {
                this.parse7(keyStart, valueStart, valueEnd);
            } else if (length == 8) {
                this.parse8(keyStart, valueStart, valueEnd);
            }
        }

        private void parse4(int nameStart, int valueStart, int valueEnd) {
            if (this.header.regionMatches(true, nameStart, "Path", 0, 4)) {
                this.path = this.computeValue(valueStart, valueEnd);
            }
        }

        private void parse6(int nameStart, int valueStart, int valueEnd) {
            if (this.header.regionMatches(true, nameStart, "Domain", 0, 5)) {
                this.domain = this.computeValue(valueStart, valueEnd);
            } else if (this.header.regionMatches(true, nameStart, "Secure", 0, 5)) {
                this.secure = true;
            }
        }

        private void setMaxAge(String value) {
            try {
                this.maxAge = Math.max(Long.parseLong(value), 0L);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        private long mergeMaxAgeAndExpires() {
            Instant expiresDate;
            if (this.maxAge != Long.MIN_VALUE) {
                return this.maxAge;
            }
            if (CookieBuilder.isValueDefined(this.expiresStart, this.expiresEnd) && (expiresDate = DateTimeUtil.parseDate((String)this.header, (int)this.expiresStart, (int)this.expiresEnd)) != null) {
                Instant now = Instant.now();
                long maxAgeMillis = expiresDate.toEpochMilli() - now.toEpochMilli();
                return maxAgeMillis / 1000L + (long)(maxAgeMillis % 1000L != 0L ? 1 : 0);
            }
            return Long.MIN_VALUE;
        }

        private void parse7(int nameStart, int valueStart, int valueEnd) {
            if (this.header.regionMatches(true, nameStart, "Expires", 0, 7)) {
                this.expiresStart = valueStart;
                this.expiresEnd = valueEnd;
            } else if (this.header.regionMatches(true, nameStart, "Max-Age", 0, 7)) {
                this.setMaxAge(this.computeValue(valueStart, valueEnd));
            }
        }

        private void parse8(int nameStart, int valueStart, int valueEnd) {
            String string;
            if (this.header.regionMatches(true, nameStart, "HTTPOnly", 0, 8)) {
                this.httpOnly = true;
            } else if (this.header.regionMatches(true, nameStart, "SameSite", 0, 8) && (string = this.computeValue(valueStart, valueEnd)) != null) {
                this.setSameSite(SameSite.valueOf((String)string.toUpperCase(Locale.ROOT)));
            }
        }

        private static boolean isValueDefined(int valueStart, int valueEnd) {
            return valueStart != -1 && valueStart != valueEnd;
        }

        private String computeValue(int valueStart, int valueEnd) {
            return CookieBuilder.isValueDefined(valueStart, valueEnd) ? this.header.substring(valueStart, valueEnd) : null;
        }

        private void setSameSite(SameSite value) {
            this.sameSite = value;
        }
    }
}

