/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.netty.http.client.handler.ws1;

import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientProtocolHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;

public class Http1WebSocketClientHandler
extends ChannelInboundHandlerAdapter {
    final WebSocketClientHandshaker handshaker;

    public Http1WebSocketClientHandler(WebSocketClientHandshaker handshaker) {
        this.handshaker = handshaker;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        ctx.fireChannelActive();
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        ctx.fireChannelInactive();
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof CloseWebSocketFrame) {
            this.handshaker.close(ctx.channel(), (CloseWebSocketFrame)msg).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        } else {
            ctx.fireChannelRead(msg);
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt == WebSocketClientProtocolHandler.ClientHandshakeStateEvent.HANDSHAKE_COMPLETE) {
            String actualProtocol = this.handshaker.actualSubprotocol();
            if (!actualProtocol.equals("")) {
                throw new IOException("Invalid Websocket Protocol");
            }
        } else {
            ctx.fireUserEventTriggered(evt);
        }
    }
}

