/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.netty.http.client.handler.ws2;

import io.netty.handler.codec.http.websocketx.WebSocketDecoderConfig;
import io.netty.handler.codec.http.websocketx.extensions.compression.PerMessageDeflateClientExtensionHandshaker;
import org.xbib.netty.http.client.handler.ws2.Http2WebSocketClientHandler;
import org.xbib.netty.http.common.ws.Preconditions;

public final class Http2WebSocketClientBuilder {
    private static final short DEFAULT_STREAM_WEIGHT = 16;
    private static final boolean MASK_PAYLOAD = true;
    private WebSocketDecoderConfig webSocketDecoderConfig;
    private PerMessageDeflateClientExtensionHandshaker perMessageDeflateClientExtensionHandshaker;
    private long handshakeTimeoutMillis = 15000L;
    private short streamWeight;
    private long closedWebSocketRemoveTimeoutMillis = 30000L;
    private boolean isSingleWebSocketPerConnection;

    Http2WebSocketClientBuilder() {
    }

    public static Http2WebSocketClientBuilder create() {
        return new Http2WebSocketClientBuilder();
    }

    public Http2WebSocketClientBuilder decoderConfig(WebSocketDecoderConfig webSocketDecoderConfig) {
        this.webSocketDecoderConfig = (WebSocketDecoderConfig)Preconditions.requireNonNull((Object)webSocketDecoderConfig, (String)"webSocketDecoderConfig");
        return this;
    }

    public Http2WebSocketClientBuilder handshakeTimeoutMillis(long handshakeTimeoutMillis) {
        this.handshakeTimeoutMillis = Preconditions.requirePositive((long)handshakeTimeoutMillis, (String)"handshakeTimeoutMillis");
        return this;
    }

    public Http2WebSocketClientBuilder closedWebSocketRemoveTimeoutMillis(long closedWebSocketRemoveTimeoutMillis) {
        this.closedWebSocketRemoveTimeoutMillis = Preconditions.requirePositive((long)closedWebSocketRemoveTimeoutMillis, (String)"closedWebSocketRemoveTimeoutMillis");
        return this;
    }

    public Http2WebSocketClientBuilder compression(boolean isCompressionEnabled) {
        if (isCompressionEnabled) {
            if (this.perMessageDeflateClientExtensionHandshaker == null) {
                this.perMessageDeflateClientExtensionHandshaker = new PerMessageDeflateClientExtensionHandshaker();
            }
        } else {
            this.perMessageDeflateClientExtensionHandshaker = null;
        }
        return this;
    }

    public Http2WebSocketClientBuilder compression(int compressionLevel, boolean allowClientWindowSize, int requestedServerWindowSize, boolean allowClientNoContext, boolean requestedServerNoContext) {
        this.perMessageDeflateClientExtensionHandshaker = new PerMessageDeflateClientExtensionHandshaker(compressionLevel, allowClientWindowSize, requestedServerWindowSize, allowClientNoContext, requestedServerNoContext);
        return this;
    }

    public Http2WebSocketClientBuilder streamWeight(int weight) {
        this.streamWeight = Preconditions.requireRange((int)weight, (int)1, (int)256, (String)"streamWeight");
        return this;
    }

    public Http2WebSocketClientBuilder assumeSingleWebSocketPerConnection(boolean isSingleWebSocketPerConnection) {
        this.isSingleWebSocketPerConnection = isSingleWebSocketPerConnection;
        return this;
    }

    public Http2WebSocketClientHandler build() {
        PerMessageDeflateClientExtensionHandshaker compressionHandshaker = this.perMessageDeflateClientExtensionHandshaker;
        boolean hasCompression = compressionHandshaker != null;
        WebSocketDecoderConfig config = this.webSocketDecoderConfig;
        if (config == null) {
            config = WebSocketDecoderConfig.newBuilder().expectMaskedFrames(false).allowMaskMismatch(false).allowExtensions(hasCompression).build();
        } else {
            boolean isAllowExtensions = config.allowExtensions();
            if (!isAllowExtensions && hasCompression) {
                config = config.toBuilder().allowExtensions(true).build();
            }
        }
        short weight = this.streamWeight;
        if (weight == 0) {
            weight = 16;
        }
        return new Http2WebSocketClientHandler(config, true, weight, this.handshakeTimeoutMillis, this.closedWebSocketRemoveTimeoutMillis, compressionHandshaker, this.isSingleWebSocketPerConnection);
    }
}

