/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.netty.http.client.handler.ws2;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.handler.codec.Headers;
import io.netty.handler.codec.http.websocketx.WebSocketDecoderConfig;
import io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketClientExtension;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionData;
import io.netty.handler.codec.http.websocketx.extensions.compression.PerMessageDeflateClientExtensionHandshaker;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2LocalFlowController;
import io.netty.util.AsciiString;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ScheduledFuture;
import java.net.InetSocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayDeque;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xbib.netty.http.client.handler.ws2.Http2WebSocketClientHandler;
import org.xbib.netty.http.common.ws.Http2WebSocket;
import org.xbib.netty.http.common.ws.Http2WebSocketChannel;
import org.xbib.netty.http.common.ws.Http2WebSocketChannelHandler;
import org.xbib.netty.http.common.ws.Http2WebSocketEvent;
import org.xbib.netty.http.common.ws.Http2WebSocketExtensions;
import org.xbib.netty.http.common.ws.Http2WebSocketProtocol;
import org.xbib.netty.http.common.ws.Preconditions;

public final class Http2WebSocketClientHandshaker {
    private static final Logger logger = Logger.getLogger(Http2WebSocketClientHandshaker.class.getName());
    private static final int ESTIMATED_DEFERRED_HANDSHAKES = 4;
    private static final AtomicIntegerFieldUpdater<Http2WebSocketClientHandshaker> WEBSOCKET_CHANNEL_SERIAL = AtomicIntegerFieldUpdater.newUpdater(Http2WebSocketClientHandshaker.class, "webSocketChannelSerial");
    private static final Http2Headers EMPTY_HEADERS = new DefaultHttp2Headers(false);
    private final Http2Connection.Endpoint<Http2LocalFlowController> streamIdFactory;
    private final WebSocketDecoderConfig webSocketDecoderConfig;
    private final Http2WebSocketChannelHandler.WebSocketsParent webSocketsParent;
    private final short streamWeight;
    private final CharSequence scheme;
    private final PerMessageDeflateClientExtensionHandshaker compressionHandshaker;
    private final boolean isEncoderMaskPayload;
    private final long timeoutMillis;
    private Queue<Handshake> deferred;
    private Boolean supportsWebSocket;
    private volatile int webSocketChannelSerial;
    private CharSequence compressionExtensionHeader;

    Http2WebSocketClientHandshaker(Http2WebSocketChannelHandler.WebSocketsParent webSocketsParent, Http2Connection.Endpoint<Http2LocalFlowController> streamIdFactory, WebSocketDecoderConfig webSocketDecoderConfig, boolean isEncoderMaskPayload, short streamWeight, CharSequence scheme, long handshakeTimeoutMillis, PerMessageDeflateClientExtensionHandshaker compressionHandshaker) {
        this.webSocketsParent = webSocketsParent;
        this.streamIdFactory = streamIdFactory;
        this.webSocketDecoderConfig = webSocketDecoderConfig;
        this.isEncoderMaskPayload = isEncoderMaskPayload;
        this.timeoutMillis = handshakeTimeoutMillis;
        this.streamWeight = streamWeight;
        this.scheme = scheme;
        this.compressionHandshaker = compressionHandshaker;
    }

    public static Http2WebSocketClientHandshaker create(Channel channel) {
        Objects.requireNonNull(channel, "channel");
        return ((Http2WebSocketClientHandler)Preconditions.requireHandler((Channel)channel, Http2WebSocketClientHandler.class)).handShaker();
    }

    public ChannelFuture handshake(String path, ChannelHandler webSocketHandler) {
        return this.handshake(path, "", EMPTY_HEADERS, webSocketHandler);
    }

    public ChannelFuture handshake(String path, Http2Headers requestHeaders, ChannelHandler webSocketHandler) {
        return this.handshake(path, "", requestHeaders, webSocketHandler);
    }

    public ChannelFuture handshake(String path, String subprotocol, ChannelHandler webSocketHandler) {
        return this.handshake(path, subprotocol, EMPTY_HEADERS, webSocketHandler);
    }

    public ChannelFuture handshake(String path, String subprotocol, Http2Headers requestHeaders, ChannelHandler webSocketHandler) {
        Preconditions.requireNonEmpty((String)path, (String)"path");
        Preconditions.requireNonNull((Object)subprotocol, (String)"subprotocol");
        Preconditions.requireNonNull((Object)requestHeaders, (String)"requestHeaders");
        Preconditions.requireNonNull((Object)webSocketHandler, (String)"webSocketHandler");
        long startNanos = System.nanoTime();
        ChannelHandlerContext ctx = this.webSocketsParent.context();
        if (!ctx.channel().isOpen()) {
            return ctx.newFailedFuture((Throwable)new ClosedChannelException());
        }
        int serial = WEBSOCKET_CHANNEL_SERIAL.getAndIncrement(this);
        Http2WebSocketChannel webSocketChannel = new Http2WebSocketChannel(this.webSocketsParent, serial, path, subprotocol, this.webSocketDecoderConfig, this.isEncoderMaskPayload, webSocketHandler).initialize();
        Handshake handshake = new Handshake(webSocketChannel, requestHeaders, this.timeoutMillis, startNanos);
        handshake.future().addListener(future -> {
            Throwable cause = future.cause();
            if (cause != null && !(cause instanceof WebSocketHandshakeException)) {
                Http2WebSocketEvent.fireHandshakeError((Http2WebSocketChannel)webSocketChannel, null, (long)System.nanoTime(), (Throwable)cause);
            }
        });
        EventLoop el = ctx.channel().eventLoop();
        if (el.inEventLoop()) {
            this.handshakeOrDefer(handshake, el);
        } else {
            el.execute(() -> this.handshakeOrDefer(handshake, el));
        }
        return webSocketChannel.handshakePromise();
    }

    void handshake(Http2WebSocket webSocket, Http2Headers responseHeaders, boolean endOfStream) {
        String status;
        if (webSocket == Http2WebSocket.CLOSED) {
            return;
        }
        Http2WebSocketChannel webSocketChannel = (Http2WebSocketChannel)webSocket;
        ChannelPromise handshakePromise = webSocketChannel.handshakePromise();
        if (handshakePromise.isDone()) {
            return;
        }
        Object errorMessage = null;
        WebSocketClientExtension compressionExtension = null;
        switch (status = responseHeaders.status().toString()) {
            case "200": {
                CharSequence extensionsHeader;
                WebSocketExtensionData compression;
                PerMessageDeflateClientExtensionHandshaker handshaker;
                CharSequence serverSubprotocol;
                if (endOfStream) {
                    errorMessage = "websocket handshake error: unexpected result - status=200, end_of_stream=true";
                    break;
                }
                String clientSubprotocol = webSocketChannel.subprotocol();
                if (!Http2WebSocketClientHandshaker.isEqual(clientSubprotocol, serverSubprotocol = (CharSequence)responseHeaders.get((Object)Http2WebSocketProtocol.HEADER_WEBSOCKET_SUBPROTOCOL_NAME))) {
                    errorMessage = "websocket handshake error: unexpected subprotocol - " + clientSubprotocol;
                }
                if (errorMessage != null || (handshaker = this.compressionHandshaker) == null || (compression = Http2WebSocketExtensions.decode((CharSequence)(extensionsHeader = (CharSequence)responseHeaders.get((Object)Http2WebSocketProtocol.HEADER_WEBSOCKET_EXTENSIONS_NAME)))) == null) break;
                compressionExtension = handshaker.handshakeExtension(compression);
                break;
            }
            case "400": {
                CharSequence webSocketVersion = (CharSequence)responseHeaders.get((Object)Http2WebSocketProtocol.HEADER_WEBSOCKET_VERSION_NAME);
                errorMessage = webSocketVersion != null ? "websocket handshake error: unsupported version; supported versions - " + webSocketVersion : "websocket handshake error: bad request";
                break;
            }
            case "404": {
                errorMessage = "websocket handshake error: path not found - " + webSocketChannel.path() + ", subprotocols - " + webSocketChannel.subprotocol();
                break;
            }
            default: {
                errorMessage = "websocket handshake error: " + status;
            }
        }
        if (errorMessage != null) {
            WebSocketHandshakeException cause = new WebSocketHandshakeException((String)errorMessage);
            if (handshakePromise.tryFailure((Throwable)cause)) {
                Http2WebSocketEvent.fireHandshakeError((Http2WebSocketChannel)webSocketChannel, (Http2Headers)responseHeaders, (long)System.nanoTime(), (Throwable)cause);
            }
            return;
        }
        if (compressionExtension != null) {
            webSocketChannel.compression(compressionExtension.newExtensionEncoder(), compressionExtension.newExtensionDecoder());
        }
        if (handshakePromise.trySuccess()) {
            Http2WebSocketEvent.fireHandshakeSuccess((Http2WebSocketChannel)webSocketChannel, (Http2Headers)responseHeaders, (long)System.nanoTime());
        }
    }

    void reject(int streamId, Http2WebSocket webSocket, Http2Headers headers, boolean endOfStream) {
        Http2WebSocketEvent.fireHandshakeValidationStartAndError((Channel)this.webSocketsParent.context().channel(), (int)streamId, (Http2Headers)((Http2Headers)headers.set((Object)AsciiString.of((CharSequence)"x-websocket-endofstream"), (Object)AsciiString.of((CharSequence)(endOfStream ? "true" : "false")))));
        if (webSocket == Http2WebSocket.CLOSED) {
            return;
        }
        Http2WebSocketChannel webSocketChannel = (Http2WebSocketChannel)webSocket;
        ChannelPromise handshakePromise = webSocketChannel.handshakePromise();
        if (handshakePromise.isDone()) {
            return;
        }
        WebSocketHandshakeException cause = new WebSocketHandshakeException("websocket handshake error: invalid response headers");
        if (handshakePromise.tryFailure((Throwable)cause)) {
            Http2WebSocketEvent.fireHandshakeError((Http2WebSocketChannel)webSocketChannel, (Http2Headers)headers, (long)System.nanoTime(), (Throwable)cause);
        }
    }

    void onSupportsWebSocket(boolean supportsWebSocket) {
        if (!supportsWebSocket) {
            logger.log(Level.SEVERE, "websocket handshake error: bootstrapping websockets with http2 is not supported by server");
        }
        this.supportsWebSocket = supportsWebSocket;
        this.handshakeDeferred(supportsWebSocket);
    }

    private void handshakeOrDefer(Handshake handshake, EventLoop eventLoop) {
        if (handshake.isDone()) {
            return;
        }
        Http2WebSocketChannel webSocketChannel = handshake.webSocketChannel();
        Http2Headers requestHeaders = handshake.requestHeaders();
        long startNanos = handshake.startNanos();
        ChannelFuture registered = eventLoop.register((Channel)webSocketChannel);
        if (!registered.isSuccess()) {
            Throwable cause = registered.cause();
            WebSocketHandshakeException e = new WebSocketHandshakeException("websocket handshake channel registration error", cause);
            Http2WebSocketEvent.fireHandshakeStartAndError((Channel)webSocketChannel.parent(), (int)webSocketChannel.serial(), (String)webSocketChannel.path(), (String)webSocketChannel.subprotocol(), (Http2Headers)requestHeaders, (long)startNanos, (long)System.nanoTime(), (Throwable)e);
            handshake.complete((Throwable)e);
            return;
        }
        Http2WebSocketEvent.fireHandshakeStart((Http2WebSocketChannel)webSocketChannel, (Http2Headers)requestHeaders, (long)startNanos);
        Boolean supports = this.supportsWebSocket;
        if (supports == null) {
            Queue<Handshake> d = this.deferred;
            if (d == null) {
                d = this.deferred = new ArrayDeque<Handshake>(4);
            }
            handshake.startTimeout();
            d.add(handshake);
            return;
        }
        if (supports.booleanValue()) {
            handshake.startTimeout();
        }
        this.handshakeImmediate(handshake, supports);
    }

    private void handshakeDeferred(boolean supportsWebSocket) {
        Queue<Handshake> d = this.deferred;
        if (d == null) {
            return;
        }
        this.deferred = null;
        Handshake handshake = d.poll();
        while (handshake != null) {
            this.handshakeImmediate(handshake, supportsWebSocket);
            handshake = d.poll();
        }
    }

    private void handshakeImmediate(Handshake handshake, boolean supportsWebSocket) {
        short pendingStreamWeight;
        String subprotocol;
        Http2WebSocketChannel webSocketChannel = handshake.webSocketChannel();
        Http2Headers customHeaders = handshake.requestHeaders();
        if (handshake.isDone()) {
            return;
        }
        if (!supportsWebSocket) {
            WebSocketHandshakeException e = new WebSocketHandshakeException("websocket handshake error: bootstrapping websockets with http2 is not supported by server");
            Http2WebSocketEvent.fireHandshakeError((Http2WebSocketChannel)webSocketChannel, null, (long)System.nanoTime(), (Throwable)e);
            handshake.complete((Throwable)e);
            return;
        }
        int streamId = this.streamIdFactory.incrementAndGetNextStreamId();
        this.webSocketsParent.register(streamId, webSocketChannel.setStreamId(streamId));
        String authority = this.authority();
        String path = webSocketChannel.path();
        Http2Headers headers = Http2WebSocketProtocol.extendedConnect((Http2Headers)((Http2Headers)new DefaultHttp2Headers().scheme(this.scheme).authority((CharSequence)authority).path((CharSequence)path).set((Object)Http2WebSocketProtocol.HEADER_WEBSOCKET_VERSION_NAME, (Object)Http2WebSocketProtocol.HEADER_WEBSOCKET_VERSION_VALUE)));
        PerMessageDeflateClientExtensionHandshaker handshaker = this.compressionHandshaker;
        if (handshaker != null) {
            headers.set((Object)Http2WebSocketProtocol.HEADER_WEBSOCKET_EXTENSIONS_NAME, (Object)this.compressionExtensionHeader(handshaker));
        }
        if (!(subprotocol = webSocketChannel.subprotocol()).isEmpty()) {
            headers.set((Object)Http2WebSocketProtocol.HEADER_WEBSOCKET_SUBPROTOCOL_NAME, (Object)subprotocol);
        }
        if (!customHeaders.isEmpty()) {
            headers.setAll((Headers)customHeaders);
        }
        short weight = (pendingStreamWeight = webSocketChannel.pendingStreamWeight()) > 0 ? pendingStreamWeight : this.streamWeight;
        this.webSocketsParent.writeHeaders(webSocketChannel.streamId(), headers, false, weight).addListener(future -> {
            if (!future.isSuccess()) {
                handshake.complete(future.cause());
                return;
            }
            webSocketChannel.setStreamWeightAttribute(weight);
        });
    }

    private String authority() {
        return ((InetSocketAddress)this.webSocketsParent.context().channel().remoteAddress()).getHostString();
    }

    private CharSequence compressionExtensionHeader(PerMessageDeflateClientExtensionHandshaker handshaker) {
        CharSequence header = this.compressionExtensionHeader;
        if (header == null) {
            header = this.compressionExtensionHeader = AsciiString.of((CharSequence)Http2WebSocketExtensions.encode((WebSocketExtensionData)handshaker.newRequestData()));
        }
        return header;
    }

    private static boolean isEqual(String str, CharSequence seq) {
        if ((seq == null || seq.length() == 0) && str.isEmpty()) {
            return true;
        }
        if (seq == null) {
            return false;
        }
        return str.contentEquals(seq);
    }

    static class Handshake {
        private final Future<Void> channelClose;
        private final ChannelPromise handshake;
        private final long timeoutMillis;
        private boolean done;
        private ScheduledFuture<?> timeoutFuture;
        private Future<?> handshakeCompleteFuture;
        private GenericFutureListener<ChannelFuture> channelCloseListener;
        private final Http2WebSocketChannel webSocketChannel;
        private final Http2Headers requestHeaders;
        private final long handshakeStartNanos;

        public Handshake(Http2WebSocketChannel webSocketChannel, Http2Headers requestHeaders, long timeoutMillis, long handshakeStartNanos) {
            this.channelClose = webSocketChannel.closeFuture();
            this.handshake = webSocketChannel.handshakePromise();
            this.timeoutMillis = timeoutMillis;
            this.webSocketChannel = webSocketChannel;
            this.requestHeaders = requestHeaders;
            this.handshakeStartNanos = handshakeStartNanos;
        }

        public void startTimeout() {
            ChannelPromise h = this.handshake;
            Channel channel = h.channel();
            if (this.done) {
                return;
            }
            GenericFutureListener l = this.channelCloseListener = future -> this.onConnectionClose();
            this.channelClose.addListener(l);
            if (this.done) {
                return;
            }
            this.handshakeCompleteFuture = h.addListener(future -> this.onHandshakeComplete(future.cause()));
            if (this.done) {
                return;
            }
            this.timeoutFuture = channel.eventLoop().schedule(this::onTimeout, this.timeoutMillis, TimeUnit.MILLISECONDS);
        }

        public void complete(Throwable e) {
            this.onHandshakeComplete(e);
        }

        public boolean isDone() {
            return this.done;
        }

        public ChannelFuture future() {
            return this.handshake;
        }

        public Http2WebSocketChannel webSocketChannel() {
            return this.webSocketChannel;
        }

        public Http2Headers requestHeaders() {
            return this.requestHeaders;
        }

        public long startNanos() {
            return this.handshakeStartNanos;
        }

        private void onConnectionClose() {
            if (!this.done) {
                this.handshake.tryFailure((Throwable)new ClosedChannelException());
                this.done();
            }
        }

        private void onHandshakeComplete(Throwable cause) {
            if (!this.done) {
                if (cause != null) {
                    this.handshake.tryFailure(cause);
                } else {
                    this.handshake.trySuccess();
                }
                this.done();
            }
        }

        private void onTimeout() {
            if (!this.done) {
                this.handshake.tryFailure((Throwable)new TimeoutException());
                this.done();
            }
        }

        private void done() {
            this.done = true;
            GenericFutureListener<ChannelFuture> closeListener = this.channelCloseListener;
            if (closeListener != null) {
                this.channelClose.removeListener(closeListener);
            }
            this.cancel(this.handshakeCompleteFuture);
            this.cancel((Future<?>)this.timeoutFuture);
        }

        private void cancel(Future<?> future) {
            if (future != null) {
                future.cancel(true);
            }
        }
    }
}

