/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.netty.http.client.retry;

import org.xbib.netty.http.client.api.BackOff;

public class ExponentialBackOff
implements BackOff {
    public static final int DEFAULT_INITIAL_INTERVAL_MILLIS = 500;
    public static final double DEFAULT_RANDOMIZATION_FACTOR = 0.5;
    public static final double DEFAULT_MULTIPLIER = 1.5;
    public static final int DEFAULT_MAX_INTERVAL_MILLIS = 60000;
    public static final int DEFAULT_MAX_ELAPSED_TIME_MILLIS = 900000;
    private int currentIntervalMillis;
    private final int initialIntervalMillis;
    private final double randomizationFactor;
    private final double multiplier;
    private final int maxIntervalMillis;
    private long startTimeNanos;
    private final int maxElapsedTimeMillis;
    private final NanoClock nanoClock;

    public ExponentialBackOff() {
        this(new Builder());
    }

    private ExponentialBackOff(Builder builder) {
        this.initialIntervalMillis = builder.initialIntervalMillis;
        this.randomizationFactor = builder.randomizationFactor;
        this.multiplier = builder.multiplier;
        this.maxIntervalMillis = builder.maxIntervalMillis;
        this.maxElapsedTimeMillis = builder.maxElapsedTimeMillis;
        this.nanoClock = builder.nanoClock;
        this.reset();
    }

    public final void reset() {
        this.currentIntervalMillis = this.initialIntervalMillis;
        this.startTimeNanos = this.nanoClock.nanoTime();
    }

    public void setStartTimeNanos(long startTimeNanos) {
        this.startTimeNanos = startTimeNanos;
    }

    public long nextBackOffMillis() {
        if (this.getElapsedTimeMillis() > (long)this.maxElapsedTimeMillis) {
            return -1L;
        }
        int randomizedInterval = ExponentialBackOff.getRandomValueFromInterval(this.randomizationFactor, Math.random(), this.currentIntervalMillis);
        this.incrementCurrentInterval();
        return randomizedInterval;
    }

    public static int getRandomValueFromInterval(double randomizationFactor, double random, int currentIntervalMillis) {
        double delta = randomizationFactor * (double)currentIntervalMillis;
        double minInterval = (double)currentIntervalMillis - delta;
        double maxInterval = (double)currentIntervalMillis + delta;
        return (int)(minInterval + random * (maxInterval - minInterval + 1.0));
    }

    public final int getInitialIntervalMillis() {
        return this.initialIntervalMillis;
    }

    public final double getRandomizationFactor() {
        return this.randomizationFactor;
    }

    public final int getCurrentIntervalMillis() {
        return this.currentIntervalMillis;
    }

    public final double getMultiplier() {
        return this.multiplier;
    }

    public final int getMaxIntervalMillis() {
        return this.maxIntervalMillis;
    }

    public final int getMaxElapsedTimeMillis() {
        return this.maxElapsedTimeMillis;
    }

    public final long getElapsedTimeMillis() {
        return (this.nanoClock.nanoTime() - this.startTimeNanos) / 1000000L;
    }

    private void incrementCurrentInterval() {
        this.currentIntervalMillis = (double)this.currentIntervalMillis >= (double)this.maxIntervalMillis / this.multiplier ? this.maxIntervalMillis : (int)((double)this.currentIntervalMillis * this.multiplier);
    }

    public static class Builder {
        private int initialIntervalMillis = 500;
        private double randomizationFactor = 0.5;
        private double multiplier = 1.5;
        private int maxIntervalMillis = 60000;
        private int maxElapsedTimeMillis = 900000;
        private NanoClock nanoClock = NanoClock.SYSTEM;

        public ExponentialBackOff build() {
            if (this.initialIntervalMillis <= 0) {
                throw new IllegalArgumentException();
            }
            if (!(0.0 <= this.randomizationFactor) || !(this.randomizationFactor < 1.0)) {
                throw new IllegalArgumentException();
            }
            if (this.multiplier < 1.0) {
                throw new IllegalArgumentException();
            }
            if (this.maxIntervalMillis < this.initialIntervalMillis) {
                throw new IllegalArgumentException();
            }
            if (this.maxElapsedTimeMillis <= 0) {
                throw new IllegalArgumentException();
            }
            return new ExponentialBackOff(this);
        }

        public Builder setInitialIntervalMillis(int initialIntervalMillis) {
            this.initialIntervalMillis = initialIntervalMillis;
            return this;
        }

        public Builder setRandomizationFactor(double randomizationFactor) {
            this.randomizationFactor = randomizationFactor;
            return this;
        }

        public Builder setMultiplier(double multiplier) {
            this.multiplier = multiplier;
            return this;
        }

        public Builder setMaxIntervalMillis(int maxIntervalMillis) {
            this.maxIntervalMillis = maxIntervalMillis;
            return this;
        }

        public Builder setMaxElapsedTimeMillis(int maxElapsedTimeMillis) {
            this.maxElapsedTimeMillis = maxElapsedTimeMillis;
            return this;
        }

        public Builder setNanoClock(NanoClock nanoClock) {
            if (nanoClock != null) {
                this.nanoClock = nanoClock;
            }
            return this;
        }
    }

    public static interface NanoClock {
        public static final NanoClock SYSTEM = System::nanoTime;

        public long nanoTime();
    }
}

