/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.netty.http.client.transport;

import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicInteger;

public class Flow {
    private final AtomicInteger counter = new AtomicInteger(3);
    private final SortedMap<Integer, CompletableFuture<Boolean>> map = new ConcurrentSkipListMap<Integer, CompletableFuture<Boolean>>();

    CompletableFuture<Boolean> get(Integer key) {
        return (CompletableFuture)this.map.get(key);
    }

    Set<Integer> keys() {
        return this.map.keySet();
    }

    Integer firstKey() {
        return this.map.isEmpty() ? null : this.map.firstKey();
    }

    Integer lastKey() {
        return this.map.isEmpty() ? null : this.map.lastKey();
    }

    void put(Integer key, CompletableFuture<Boolean> promise) {
        this.map.put(key, promise);
    }

    void remove(Integer key) {
        if (key != null) {
            this.map.remove(key);
        }
    }

    Integer nextStreamId() {
        int streamId = this.counter.getAndAdd(2);
        if (streamId == Integer.MIN_VALUE) {
            this.counter.set(3);
            streamId = 3;
        }
        this.map.put(streamId, new CompletableFuture());
        return streamId;
    }

    void fail(Throwable throwable) {
        for (CompletableFuture<Boolean> promise : this.map.values()) {
            promise.completeExceptionally(throwable);
        }
    }

    public void close() {
        this.map.clear();
    }

    public boolean isClosed() {
        return this.map.isEmpty();
    }

    public String toString() {
        return "[next=" + this.counter + ", " + this.map + "]";
    }
}

