/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.netty.http.client.transport;

import io.netty.channel.Channel;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.multipart.HttpPostRequestEncoder;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.HttpConversionUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xbib.net.URLSyntaxException;
import org.xbib.netty.http.client.Client;
import org.xbib.netty.http.client.api.ClientTransport;
import org.xbib.netty.http.client.api.Request;
import org.xbib.netty.http.client.cookie.ClientCookieDecoder;
import org.xbib.netty.http.client.cookie.ClientCookieEncoder;
import org.xbib.netty.http.client.transport.BaseTransport;
import org.xbib.netty.http.client.transport.Flow;
import org.xbib.netty.http.common.DefaultHttpResponse;
import org.xbib.netty.http.common.HttpAddress;
import org.xbib.netty.http.common.HttpResponse;
import org.xbib.netty.http.common.cookie.Cookie;

public class Http1Transport
extends BaseTransport {
    private static final Logger logger = Logger.getLogger(Http1Transport.class.getName());

    public Http1Transport(Client client, HttpAddress httpAddress) {
        super(client, httpAddress);
    }

    public ClientTransport execute(Request request) throws IOException {
        Channel channel = this.mapChannel(request);
        if (this.throwable != null) {
            return this;
        }
        String channelId = channel.id().toString();
        this.flowMap.putIfAbsent(channelId, new Flow());
        String uri = request.httpVersion().majorVersion() == 1 ? request.relative() : request.absolute();
        DefaultFullHttpRequest fullHttpRequest = request.content() == null ? new DefaultFullHttpRequest(request.httpVersion(), request.httpMethod(), uri) : new DefaultFullHttpRequest(request.httpVersion(), request.httpMethod(), uri, request.content());
        HttpPostRequestEncoder httpPostRequestEncoder = null;
        Integer streamId = ((Flow)this.flowMap.get(channelId)).nextStreamId();
        if (streamId == null) {
            throw new IllegalStateException();
        }
        String requestKey = channelId + "#" + streamId;
        this.requests.put(requestKey, request);
        request.headers().set((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), (Object)Integer.toString(streamId));
        ArrayList<Cookie> cookies = new ArrayList<Cookie>();
        cookies.addAll(this.matchCookiesFromBox(request));
        cookies.addAll(this.matchCookies(request));
        if (!cookies.isEmpty()) {
            request.headers().set((CharSequence)HttpHeaderNames.COOKIE, (Object)ClientCookieEncoder.STRICT.encode((Collection<? extends Cookie>)cookies));
        }
        fullHttpRequest.headers().set(request.headers());
        if (request.content() == null && !request.getBodyData().isEmpty()) {
            try {
                httpPostRequestEncoder = new HttpPostRequestEncoder(this.httpDataFactory, (HttpRequest)fullHttpRequest, true);
                httpPostRequestEncoder.setBodyHttpDatas(request.getBodyData());
                httpPostRequestEncoder.finalizeRequest();
            }
            catch (HttpPostRequestEncoder.ErrorDataEncoderException e) {
                throw new IOException(e);
            }
        }
        if (channel.isWritable()) {
            channel.write((Object)fullHttpRequest);
            if (httpPostRequestEncoder != null && httpPostRequestEncoder.isChunked()) {
                channel.write((Object)httpPostRequestEncoder);
            }
            channel.flush();
            if (httpPostRequestEncoder != null) {
                httpPostRequestEncoder.cleanFiles();
            }
            this.client.getRequestCounter().incrementAndGet();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void responseReceived(Channel channel, Integer streamId, FullHttpResponse fullHttpResponse) {
        if (this.throwable != null) {
            logger.log(Level.WARNING, "throwable not null", this.throwable);
            return;
        }
        if (this.requests.isEmpty()) {
            logger.log(Level.WARNING, "no request present for responding");
            return;
        }
        String requestKey = (String)this.requests.lastKey();
        DefaultHttpResponse httpResponse = null;
        try {
            CompletableFuture<Boolean> promise;
            Integer lastKey;
            Request request = (Request)this.requests.get(requestKey);
            if (request != null) {
                for (String cookieString : fullHttpResponse.headers().getAll((CharSequence)HttpHeaderNames.SET_COOKIE)) {
                    Cookie cookie = ClientCookieDecoder.STRICT.decode(cookieString);
                    this.addCookie(cookie);
                }
                httpResponse = new DefaultHttpResponse(this.httpAddress, fullHttpResponse, this.getCookieBox());
                request.onResponse((HttpResponse)httpResponse);
                this.client.getResponseCounter().incrementAndGet();
            } else {
                logger.log(Level.WARNING, "unable to find request for response");
            }
            try {
                Request retryRequest = this.retry(request, (HttpResponse)httpResponse);
                if (retryRequest != null) {
                    this.client.retry(this, retryRequest);
                } else {
                    Request continueRequest = this.continuation(request, (HttpResponse)httpResponse);
                    if (continueRequest != null) {
                        this.client.continuation(this, continueRequest);
                    }
                }
            }
            catch (IOException | URLSyntaxException e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
            String channelId = channel.id().toString();
            Flow flow = (Flow)this.flowMap.get(channelId);
            if (flow != null && (lastKey = flow.lastKey()) != null && (promise = flow.get(lastKey)) != null) {
                promise.complete(true);
            }
        }
        finally {
            if (requestKey != null) {
                this.requests.remove(requestKey);
            }
            if (httpResponse != null) {
                httpResponse.release();
            }
        }
    }

    public void settingsReceived(Http2Settings http2Settings) {
    }

    public void waitForSettings() {
    }

    public void pushPromiseReceived(Channel channel, Integer streamId, Integer promisedStreamId, Http2Headers headers) {
    }

    @Override
    protected String getRequestKey(String channelId, Integer streamId) {
        try {
            return this.requests.isEmpty() ? null : (String)this.requests.lastKey();
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }
}

