/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.netty.http.common;

import io.netty.handler.codec.http.HttpVersion;
import java.net.InetSocketAddress;
import org.xbib.net.URL;
import org.xbib.netty.http.common.PoolKey;

public class HttpAddress
implements PoolKey {
    public static final HttpVersion HTTP_1_1 = HttpVersion.valueOf((String)"HTTP/1.1");
    public static final HttpVersion HTTP_2_0 = HttpVersion.valueOf((String)"HTTP/2.0");
    private final String host;
    private final Integer port;
    private final HttpVersion version;
    private final Boolean secure;
    private InetSocketAddress inetSocketAddress;

    public static HttpAddress http1(String host) {
        return new HttpAddress(host, 80, HTTP_1_1, false);
    }

    public static HttpAddress http1(String host, int port) {
        return new HttpAddress(host, port, HTTP_1_1, false);
    }

    public static HttpAddress secureHttp1(String host) {
        return new HttpAddress(host, 443, HTTP_1_1, true);
    }

    public static HttpAddress secureHttp1(String host, int port) {
        return new HttpAddress(host, port, HTTP_1_1, true);
    }

    public static HttpAddress http2(String host) {
        return new HttpAddress(host, 443, HTTP_2_0, false);
    }

    public static HttpAddress http2(String host, int port) {
        return new HttpAddress(host, port, HTTP_2_0, false);
    }

    public static HttpAddress secureHttp2(String host) {
        return new HttpAddress(host, 443, HTTP_2_0, true);
    }

    public static HttpAddress secureHttp2(String host, int port) {
        return new HttpAddress(host, port, HTTP_2_0, true);
    }

    public static HttpAddress http1(URL url) {
        return new HttpAddress(url, HTTP_1_1);
    }

    public static HttpAddress http2(URL url) {
        return new HttpAddress(url, HTTP_2_0);
    }

    public static HttpAddress of(URL url) {
        return new HttpAddress(url, HTTP_1_1);
    }

    public static HttpAddress of(URL url, HttpVersion httpVersion) {
        return new HttpAddress(url, httpVersion);
    }

    public static HttpAddress of(String host, Integer port, HttpVersion version, boolean secure) {
        return new HttpAddress(host, port, version, secure);
    }

    public HttpAddress(URL url, HttpVersion version) {
        this(url.getHost(), url.getPort(), version, "https".equals(url.getScheme()));
    }

    public HttpAddress(String host, Integer port, HttpVersion version, boolean secure) {
        this.host = host;
        this.port = port == null || port == -1 ? (secure ? 443 : 80) : port;
        this.version = version;
        this.secure = secure;
    }

    @Override
    public InetSocketAddress getInetSocketAddress() {
        if (this.inetSocketAddress == null) {
            this.inetSocketAddress = new InetSocketAddress(this.host, (int)this.port);
        }
        return this.inetSocketAddress;
    }

    public URL base() {
        return this.isSecure() ? URL.https().host(this.host).port(this.port).build() : URL.http().host(this.host).port(this.port).build();
    }

    public HttpVersion getVersion() {
        return this.version;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public String toString() {
        return this.host + ":" + this.port + " (version:" + this.version + ",secure:" + this.secure + ")";
    }

    public boolean equals(Object object) {
        return object instanceof HttpAddress && this.host.equals(((HttpAddress)object).host) && this.port != null && this.port.equals(((HttpAddress)object).port) && this.version.equals((Object)((HttpAddress)object).version) && this.secure.equals(((HttpAddress)object).secure);
    }

    public int hashCode() {
        return this.host.hashCode() ^ this.port ^ this.version.hashCode() ^ this.secure.hashCode();
    }
}

