/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.netty.http.common;

import io.netty.handler.codec.http.HttpHeaderValues;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.MalformedInputException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnmappableCharacterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.xbib.net.PercentDecoder;
import org.xbib.net.PercentEncoder;
import org.xbib.net.PercentEncoders;
import org.xbib.netty.http.common.util.LimitedSet;
import org.xbib.netty.http.common.util.LimitedTreeMap;

public class HttpParameters
implements Map<String, SortedSet<String>> {
    private static final String EQUALS = "=";
    private static final String AMPERSAND = "&";
    private final int maxParam;
    private final int sizeLimit;
    private final int elementSizeLimit;
    private final LimitedTreeMap<String, String> map;
    private final PercentEncoder percentEncoder;
    private final PercentDecoder percentDecoder;
    private final CharSequence contentType;

    public HttpParameters() {
        this(1024, 1024, 65536, (CharSequence)HttpHeaderValues.APPLICATION_X_WWW_FORM_URLENCODED, StandardCharsets.UTF_8);
    }

    public HttpParameters(CharSequence contentType) {
        this(1024, 1024, 65536, contentType, StandardCharsets.UTF_8);
    }

    public HttpParameters(CharSequence contentType, Charset charset) {
        this(1024, 1024, 65536, contentType, charset);
    }

    public HttpParameters(int maxParam, int sizeLimit, int elementSizeLimit, CharSequence contentType, Charset charset) {
        this.maxParam = maxParam;
        this.sizeLimit = sizeLimit;
        this.elementSizeLimit = elementSizeLimit;
        this.map = new LimitedTreeMap(maxParam);
        this.percentEncoder = PercentEncoders.getQueryEncoder((Charset)charset);
        this.percentDecoder = new PercentDecoder();
        this.contentType = contentType;
    }

    @Override
    public SortedSet<String> put(String key, SortedSet<String> value) {
        return this.map.put(key, value);
    }

    @Override
    public SortedSet<String> get(Object key) {
        return (SortedSet)this.map.get(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends SortedSet<String>> m) {
        this.map.putAll(m);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        if (value instanceof String) {
            for (Set values : this.map.values()) {
                if (!values.contains(value)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public int size() {
        int count = 0;
        for (String key : this.map.keySet()) {
            count += ((SortedSet)this.map.get(key)).size();
        }
        return count;
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public SortedSet<String> remove(Object key) {
        return (SortedSet)this.map.remove(key);
    }

    @Override
    public Set<String> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<SortedSet<String>> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<String, SortedSet<String>>> entrySet() {
        return this.map.entrySet();
    }

    public SortedSet<String> put(String key, SortedSet<String> values, boolean percentEncode) {
        if (percentEncode) {
            this.remove(key);
            for (String v : values) {
                this.add(key, v, percentEncode);
            }
            return this.get(key);
        }
        return this.map.put(key, values);
    }

    public String addRaw(String key, String value) {
        return this.add(key, value, false);
    }

    public String add(String key, String value) {
        return this.add(key, value, true);
    }

    private String add(String key, String value, boolean percentEncode) {
        String v = null;
        try {
            String k = percentEncode ? this.percentEncoder.encode((CharSequence)key) : key;
            LimitedSet values = (LimitedSet)this.map.get(k);
            if (values == null) {
                values = new LimitedSet(this.sizeLimit, this.elementSizeLimit);
                this.map.put(k, values);
            }
            if (value != null) {
                v = percentEncode ? this.percentEncoder.encode((CharSequence)value) : value;
                values.add(v);
            }
        }
        catch (CharacterCodingException e) {
            throw new IllegalArgumentException(e);
        }
        return v;
    }

    public String addNull(String key, String nullString) {
        return this.addRaw(key, nullString);
    }

    public void addAll(String[] keyValuePairs, boolean percentEncode) {
        for (int i = 0; i < keyValuePairs.length - 1; i += 2) {
            this.add(keyValuePairs[i], keyValuePairs[i + 1], percentEncode);
        }
    }

    public void addAll(Map<? extends String, ? extends SortedSet<String>> m, boolean percentEncode) {
        if (percentEncode) {
            for (String string : m.keySet()) {
                this.put(string, m.get(string), true);
            }
        } else {
            this.map.putAll(m);
        }
    }

    public void addMap(Map<String, List<String>> m) {
        for (String key : m.keySet()) {
            LimitedSet<String> vals = this.get(key);
            if (vals == null) {
                vals = new LimitedSet<String>(this.sizeLimit, this.elementSizeLimit);
                this.put(key, (SortedSet<String>)vals);
            }
            vals.addAll(m.get(key));
        }
    }

    public String getFirst(String key) {
        SortedSet values = (SortedSet)this.map.get(key);
        if (values == null || values.isEmpty()) {
            return null;
        }
        return (String)values.first();
    }

    public String getFirstDecoded(String key) throws MalformedInputException, UnmappableCharacterException {
        SortedSet values = (SortedSet)this.map.get(key);
        if (values == null || values.isEmpty()) {
            return null;
        }
        String value = (String)values.first();
        return this.percentDecoder.decode((CharSequence)value);
    }

    public CharSequence getContentType() {
        return this.contentType;
    }

    public String getAsQueryString(boolean percentEncode) throws MalformedInputException, UnmappableCharacterException {
        ArrayList<String> list = new ArrayList<String>();
        for (String key : this.keySet()) {
            list.add(this.getAsQueryString(key, percentEncode));
        }
        return String.join((CharSequence)AMPERSAND, list);
    }

    public String getAsQueryString(String key) throws MalformedInputException, UnmappableCharacterException {
        return this.getAsQueryString(key, true);
    }

    public String getAsQueryString(String key, boolean percentEncode) throws MalformedInputException, UnmappableCharacterException {
        String k = percentEncode ? this.percentEncoder.encode((CharSequence)key) : key;
        SortedSet values = (SortedSet)this.map.get(k);
        if (values == null) {
            return k + EQUALS;
        }
        Iterator it = values.iterator();
        StringBuilder sb = new StringBuilder();
        while (it.hasNext()) {
            String v = (String)it.next();
            v = percentEncode ? this.percentEncoder.encode((CharSequence)v) : v;
            sb.append(k).append(EQUALS).append(v);
            if (!it.hasNext()) continue;
            sb.append(AMPERSAND);
        }
        return sb.toString();
    }

    public String getAsHeaderElement(String key) {
        String value = this.getFirst(key);
        if (value == null) {
            return null;
        }
        return key + "=\"" + value + "\"";
    }

    public HttpParameters getOAuthParameters() {
        HttpParameters oauthParams = new HttpParameters(this.maxParam, this.sizeLimit, this.elementSizeLimit, this.contentType, StandardCharsets.UTF_8);
        this.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("oauth_") || ((String)entry.getKey()).startsWith("x_oauth_")).forEach((? super T entry) -> oauthParams.put((String)entry.getKey(), (SortedSet)entry.getValue()));
        return oauthParams;
    }

    public String toString() {
        return new LinkedHashMap<String, SortedSet<String>>(this).toString();
    }
}

