/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.netty.http.common.cookie;

import java.nio.CharBuffer;
import org.xbib.netty.http.common.cookie.CookieUtil;
import org.xbib.netty.http.common.cookie.DefaultCookie;

public abstract class CookieDecoder {
    protected final boolean strict;

    protected CookieDecoder(boolean strict) {
        this.strict = strict;
    }

    protected DefaultCookie initCookie(String header, int nameBegin, int nameEnd, int valueBegin, int valueEnd) {
        boolean wrap;
        if (nameBegin == -1 || nameBegin == nameEnd) {
            return null;
        }
        if (valueBegin == -1) {
            return null;
        }
        CharBuffer wrappedValue = CharBuffer.wrap(header, valueBegin, valueEnd);
        CharSequence unwrappedValue = CookieUtil.unwrapValue(wrappedValue);
        if (unwrappedValue == null) {
            return null;
        }
        String name = header.substring(nameBegin, nameEnd);
        if (this.strict && CookieUtil.firstInvalidCookieNameOctet(name) >= 0) {
            return null;
        }
        boolean bl = wrap = unwrappedValue.length() != valueEnd - valueBegin;
        if (this.strict && CookieUtil.firstInvalidCookieValueOctet(unwrappedValue) >= 0) {
            return null;
        }
        DefaultCookie cookie = new DefaultCookie(name, unwrappedValue.toString());
        cookie.setWrap(wrap);
        return cookie;
    }
}

