/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.netty.http.common.util;

import java.util.Objects;
import java.util.TreeSet;

public class LimitedSet<T extends CharSequence>
extends TreeSet<T> {
    private final int sizeLimit;
    private final int elementMaximumLength;

    public LimitedSet(int sizeLimit, int elementMaximumLength) {
        this.sizeLimit = sizeLimit;
        this.elementMaximumLength = elementMaximumLength;
    }

    @Override
    public boolean add(T t) {
        Objects.requireNonNull(t);
        if (this.size() < this.sizeLimit && t.length() <= this.elementMaximumLength) {
            return super.add(t);
        }
        throw new IllegalArgumentException("limit exceeded");
    }
}

