/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.netty.http.common;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.handler.codec.http.FullHttpResponse;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.xbib.netty.http.common.DefaultHttpHeaders;
import org.xbib.netty.http.common.HttpAddress;
import org.xbib.netty.http.common.HttpHeaders;
import org.xbib.netty.http.common.HttpResponse;
import org.xbib.netty.http.common.HttpStatus;
import org.xbib.netty.http.common.cookie.CookieBox;

public class DefaultHttpResponse
implements HttpResponse {
    private final HttpAddress httpAddress;
    private final FullHttpResponse fullHttpResponse;
    private final HttpStatus httpStatus;
    private final HttpHeaders httpHeaders;
    private final CookieBox cookieBox;

    public DefaultHttpResponse(HttpAddress httpAddress, FullHttpResponse fullHttpResponse, CookieBox cookieBox) {
        this.httpAddress = httpAddress;
        this.fullHttpResponse = fullHttpResponse.retain();
        this.httpStatus = new HttpStatus(this.fullHttpResponse.status());
        this.httpHeaders = new DefaultHttpHeaders(this.fullHttpResponse.headers());
        this.cookieBox = cookieBox;
    }

    @Override
    public HttpAddress getAddress() {
        return this.httpAddress;
    }

    @Override
    public HttpStatus getStatus() {
        return this.httpStatus;
    }

    @Override
    public HttpHeaders getHeaders() {
        return this.httpHeaders;
    }

    @Override
    public CookieBox getCookies() {
        return this.cookieBox;
    }

    @Override
    public ByteBuf getBody() {
        return this.fullHttpResponse.content();
    }

    @Override
    public InputStream getBodyAsStream() {
        return new ByteBufInputStream(this.getBody());
    }

    @Override
    public String getBodyAsString(Charset charset) {
        return this.getBody().toString(charset);
    }

    @Override
    public void release() {
        this.fullHttpResponse.release();
    }
}

