/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.netty.http.common;

import io.netty.handler.codec.http.HttpHeaderValues;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.MalformedInputException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnmappableCharacterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.xbib.net.PercentEncoder;
import org.xbib.net.PercentEncoders;
import org.xbib.netty.http.common.util.CaseInsensitiveParameters;

public class HttpParameters
extends CaseInsensitiveParameters {
    private static final String EQUALS = "=";
    private static final String AMPERSAND = "&";
    private final int sizeLimit;
    private final int elementSizeLimit;
    private final PercentEncoder percentEncoder;
    private final CharSequence contentType;
    private final Charset encoding;

    public HttpParameters() {
        this(1024, 1024, 65536, (CharSequence)HttpHeaderValues.APPLICATION_X_WWW_FORM_URLENCODED, StandardCharsets.UTF_8);
    }

    public HttpParameters(CharSequence contentType) {
        this(1024, 1024, 65536, contentType, StandardCharsets.UTF_8);
    }

    public HttpParameters(CharSequence contentType, Charset charset) {
        this(1024, 1024, 65536, contentType, charset);
    }

    public HttpParameters(int maxParam, int sizeLimit, int elementSizeLimit, CharSequence contentType, Charset charset) {
        this.sizeLimit = sizeLimit;
        this.elementSizeLimit = elementSizeLimit;
        this.percentEncoder = PercentEncoders.getQueryEncoder((Charset)charset);
        this.contentType = contentType;
        this.encoding = charset;
    }

    public CharSequence getContentType() {
        return this.contentType;
    }

    public Charset getEncoding() {
        return this.encoding;
    }

    public Collection<String> put(String key, Collection<String> values, boolean percentEncode) {
        this.remove(key);
        for (String v : values) {
            this.add(key, v, percentEncode);
        }
        return this.getAll(key);
    }

    public HttpParameters addRaw(String key, String value) {
        return this.add(key, value, false);
    }

    @Override
    public HttpParameters add(String key, String value) {
        return this.add(key, value, true);
    }

    public HttpParameters addNull(String key, String nullString) {
        return this.addRaw(key, nullString);
    }

    private HttpParameters add(String key, String value, boolean percentEncode) {
        try {
            String k = percentEncode ? this.percentEncoder.encode((CharSequence)key) : key;
            String v = percentEncode ? this.percentEncoder.encode((CharSequence)value) : value;
            super.add(k, v);
        }
        catch (CharacterCodingException e) {
            throw new IllegalArgumentException(e);
        }
        return this;
    }

    public String getAsQueryString(boolean percentEncode) throws MalformedInputException, UnmappableCharacterException {
        ArrayList<String> list = new ArrayList<String>();
        for (String key : super.names()) {
            list.add(this.getAsQueryString(key, percentEncode));
        }
        return String.join((CharSequence)AMPERSAND, list);
    }

    public String getAsQueryString(String key) throws MalformedInputException, UnmappableCharacterException {
        return this.getAsQueryString(key, true);
    }

    public String getAsQueryString(String key, boolean percentEncode) throws MalformedInputException, UnmappableCharacterException {
        String k = percentEncode ? this.percentEncoder.encode((CharSequence)key) : key;
        List<String> values = this.getAll(k);
        if (values == null) {
            return k + EQUALS;
        }
        Iterator it = values.iterator();
        StringBuilder sb = new StringBuilder();
        while (it.hasNext()) {
            String v = (String)it.next();
            v = percentEncode ? this.percentEncoder.encode((CharSequence)v) : v;
            sb.append(k).append(EQUALS).append(v);
            if (!it.hasNext()) continue;
            sb.append(AMPERSAND);
        }
        return sb.toString();
    }
}

