/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.netty.http.common.cookie;

import java.nio.charset.Charset;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.MalformedInputException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnmappableCharacterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import org.xbib.net.PercentDecoder;
import org.xbib.net.PercentEncoder;
import org.xbib.net.PercentEncoders;
import org.xbib.netty.http.common.security.Codec;
import org.xbib.netty.http.common.security.CryptUtil;
import org.xbib.netty.http.common.security.HMac;

public class CookieSigner {
    private String signature;
    private final String publicValue;
    private final String privateValue;
    private String cookieValue;

    private CookieSigner(Charset charset, HMac hmac, Codec codec, String privateValue, String publicValue, String secret) throws MalformedInputException, UnmappableCharacterException, NoSuchAlgorithmException, InvalidKeyException {
        PercentEncoder percentEncoder = PercentEncoders.getCookieEncoder((Charset)charset);
        this.privateValue = privateValue;
        this.publicValue = publicValue;
        this.signature = CryptUtil.hmac(charset, hmac, codec, privateValue, secret);
        this.cookieValue = percentEncoder.encode((CharSequence)String.join((CharSequence)":", publicValue, privateValue, this.signature));
    }

    private CookieSigner(Charset charset, HMac hmac, Codec codec, String rawValue, String secret) throws MalformedInputException, UnmappableCharacterException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        PercentDecoder persentDecoder = new PercentDecoder(charset.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT));
        String[] s = persentDecoder.decode((CharSequence)rawValue).split(":", 3);
        if (s.length != 3) {
            throw new IllegalStateException("unable to find three colon-separated components in cookie value");
        }
        this.signature = CryptUtil.hmac(charset, hmac, codec, s[1], secret);
        if (!s[2].equals(this.signature)) {
            throw new SignatureException("HMAC signature does not match");
        }
        this.publicValue = s[0];
        this.privateValue = s[1];
        this.cookieValue = rawValue;
    }

    public String getPublicValue() {
        return this.publicValue;
    }

    public String getPrivateValue() {
        return this.privateValue;
    }

    public String getCookieValue() {
        return this.cookieValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Charset charset = StandardCharsets.UTF_8;
        private HMac hmac = HMac.HMAC_SHA1;
        private Codec codec = Codec.BASE64;
        private String privateValue;
        private String publicValue;
        private String secret;
        private String rawValue;

        public Builder withCharset(Charset charset) {
            this.charset = charset;
            return this;
        }

        public Builder withHMac(HMac hmac) {
            this.hmac = hmac;
            return this;
        }

        public Builder withCodec(Codec codec) {
            this.codec = codec;
            return this;
        }

        public Builder withPrivateValue(String privateValue) {
            this.privateValue = privateValue;
            return this;
        }

        public Builder withPublicValue(String publicValue) {
            this.publicValue = publicValue;
            return this;
        }

        public Builder withSecret(String secret) {
            this.secret = secret;
            return this;
        }

        public Builder withRawValue(String rawValue) {
            this.rawValue = rawValue;
            return this;
        }

        public CookieSigner build() {
            try {
                return this.rawValue != null ? new CookieSigner(this.charset, this.hmac, this.codec, this.rawValue, this.secret) : new CookieSigner(this.charset, this.hmac, this.codec, this.privateValue, this.publicValue, this.secret);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
    }
}

