/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.netty.http.common.mime;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.xbib.netty.http.common.mime.MimeMultipartListener;
import org.xbib.netty.http.common.mime.MimePart;

public class MimeMultipartParser {
    private final String contentType;
    private final ByteBuf payload;
    private byte[] boundary;
    private String type;
    private String subType;

    public MimeMultipartParser(String contentType, ByteBuf payload) {
        this.contentType = contentType;
        this.payload = payload;
        if (contentType != null) {
            int pos = contentType.indexOf(59);
            this.type = pos >= 0 ? contentType.substring(0, pos) : contentType;
            this.type = this.type.trim().toLowerCase();
            this.subType = this.type.startsWith("multipart") ? this.type.substring(10).trim() : null;
            Map<String, String> m = this.parseHeaderLine(contentType);
            this.boundary = m.containsKey("boundary") ? m.get("boundary").getBytes(StandardCharsets.US_ASCII) : null;
        }
    }

    public String type() {
        return this.type;
    }

    public String subType() {
        return this.subType;
    }

    public void parse(MimeMultipartListener listener) throws IOException {
        if (this.boundary == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        boolean inHeader = true;
        boolean inBody = false;
        Integer start = null;
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        int eol = 0;
        byte[] payloadBytes = this.payload.array();
        for (int i = 0; i < payloadBytes.length; ++i) {
            int len;
            byte b = payloadBytes[i];
            if (inHeader) {
                switch (b) {
                    case 13: {
                        break;
                    }
                    case 10: {
                        if (sb.length() > 0) {
                            String[] s = sb.toString().split(":");
                            String k = s[0];
                            String v = s[1];
                            if (!k.startsWith("--")) {
                                headers.put(k.toLowerCase(Locale.ROOT), v.trim());
                            }
                            eol = 0;
                            sb.setLength(0);
                            break;
                        }
                        if (++eol < 1) break;
                        eol = 0;
                        sb.setLength(0);
                        inHeader = false;
                        inBody = true;
                        break;
                    }
                    default: {
                        eol = 0;
                        sb.append(b);
                    }
                }
            }
            if (!inBody) continue;
            int n = len = headers.containsKey("content-length") ? Integer.parseInt((String)headers.get("content-length")) : -1;
            if (len > 0) {
                inBody = false;
                inHeader = true;
                continue;
            }
            if (b != 13 && b != 10) {
                start = i;
            }
            if (start == null) continue;
            i = MimeMultipartParser.indexOf(payloadBytes, this.boundary, start, payloadBytes.length);
            if (i == -1) {
                throw new IOException("boundary not found");
            }
            int l = i - start;
            if (l > 4) {
                l -= 4;
            }
            ByteBuf body = this.payload.retainedSlice(start.intValue(), l);
            LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
            for (Map.Entry entry : headers.entrySet()) {
                m.putAll(this.parseHeaderLine((String)entry.getValue()));
            }
            headers.putAll(m);
            if (listener != null) {
                listener.handle(this.type, this.subType, new MimePart(headers, body));
            }
            inBody = false;
            inHeader = true;
            headers = new LinkedHashMap();
            start = null;
            eol = -1;
        }
    }

    private Map<String, String> parseHeaderLine(String line) {
        String value;
        int i;
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        int pos = line.indexOf(";");
        String spec = line.substring(pos + 1);
        if (pos < 0) {
            return params;
        }
        String key = "";
        boolean inKey = true;
        boolean inString = false;
        int start = 0;
        block5: for (i = 0; i < spec.length(); ++i) {
            switch (spec.charAt(i)) {
                case '=': {
                    if (inKey) {
                        key = spec.substring(start, i).trim().toLowerCase();
                        start = i + 1;
                        inKey = false;
                        continue block5;
                    }
                    if (inString) continue block5;
                    throw new IllegalArgumentException(this.contentType + " value has illegal character '=' at " + i + ": " + spec);
                }
                case ';': {
                    if (inKey) {
                        if (spec.substring(start, i).trim().length() > 0) {
                            throw new IllegalArgumentException(this.contentType + " parameter missing value at " + i + ": " + spec);
                        }
                        throw new IllegalArgumentException(this.contentType + " parameter key has illegal character ';' at " + i + ": " + spec);
                    }
                    if (inString) continue block5;
                    value = spec.substring(start, i).trim();
                    params.put(key, value);
                    key = null;
                    start = i + 1;
                    inKey = true;
                    continue block5;
                }
                case '\"': {
                    if (inKey) {
                        throw new IllegalArgumentException(this.contentType + " key has illegal character '\"' at " + i + ": " + spec);
                    }
                    if (inString) {
                        value = spec.substring(start, i).trim();
                        params.put(key, value);
                        key = null;
                        ++i;
                        while (i < spec.length() && spec.charAt(i) != ';') {
                            if (!Character.isWhitespace(spec.charAt(i))) {
                                throw new IllegalArgumentException(this.contentType + " value has garbage after quoted string at " + i + ": " + spec);
                            }
                            ++i;
                        }
                        start = i + 1;
                        inString = false;
                        inKey = true;
                        continue block5;
                    }
                    if (spec.substring(start, i).trim().length() > 0) {
                        throw new IllegalArgumentException(this.contentType + " value has garbage before quoted string at " + i + ": " + spec);
                    }
                    start = i + 1;
                    inString = true;
                }
            }
        }
        if (inKey) {
            if (pos > start && spec.substring(start, i).trim().length() > 0) {
                throw new IllegalArgumentException(this.contentType + " missing value at " + i + ": " + spec);
            }
        } else if (!inString) {
            value = spec.substring(start, i).trim();
            params.put(key, value);
        } else {
            throw new IllegalArgumentException(this.contentType + " has an unterminated quoted string: " + spec);
        }
        return params;
    }

    private static int indexOf(byte[] array, byte[] target, int start, int end) {
        if (target.length == 0) {
            return 0;
        }
        block0: for (int i = start; i < end - target.length + 1; ++i) {
            for (int j = 0; j < target.length; ++j) {
                if (array[i + j] != target[j]) continue block0;
            }
            return i;
        }
        return -1;
    }
}

