/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.netty.http.common.security;

import io.netty.handler.codec.http2.Http2SecurityUtil;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;

public class SecurityUtil {
    private static TrustManagerFactory TRUST_MANAGER_FACTORY;

    private SecurityUtil() {
    }

    static {
        try {
            TRUST_MANAGER_FACTORY = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        }
        catch (Exception e) {
            TRUST_MANAGER_FACTORY = null;
        }
    }

    public static interface Defaults {
        public static final List<String> OPENSSL_CIPHERS = Http2SecurityUtil.CIPHERS;
        public static final List<String> JDK_CIPHERS = Arrays.asList(((SSLSocketFactory)SSLSocketFactory.getDefault()).getDefaultCipherSuites());
        public static final TrustManagerFactory DEFAULT_TRUST_MANAGER_FACTORY = TRUST_MANAGER_FACTORY;
        public static final SslProvider DEFAULT_SSL_PROVIDER = OpenSsl.isAvailable() ? SslProvider.OPENSSL : SslProvider.JDK;
        public static final Iterable<String> DEFAULT_CIPHERS = OpenSsl.isAvailable() ? OPENSSL_CIPHERS : JDK_CIPHERS;
        public static final CipherSuiteFilter DEFAULT_CIPHER_SUITE_FILTER = SupportedCipherSuiteFilter.INSTANCE;
    }
}

