/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.netty.http.common.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.xbib.netty.http.common.util.MultiMap;

abstract class AbstractMultiMap<K, V>
implements MultiMap<K, V> {
    private final Map<K, Collection<V>> map = this.newMap();

    AbstractMultiMap() {
        this(null);
    }

    private AbstractMultiMap(MultiMap<K, V> map) {
        if (map != null) {
            this.putAll(map);
        }
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(K key) {
        return this.map.containsKey(key);
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public boolean put(K key, V value) {
        Collection<V> set = this.map.get(key);
        if (set == null) {
            set = this.newValues();
            set.add(value);
            this.map.put(key, set);
            return true;
        }
        set.add(value);
        return false;
    }

    @Override
    public void putAll(K key, Iterable<V> values) {
        if (values == null) {
            return;
        }
        Collection set = this.map.computeIfAbsent(key, k -> this.newValues());
        for (V v : values) {
            set.add(v);
        }
    }

    @Override
    public Collection<V> get(K key) {
        return this.map.get(key);
    }

    @Override
    public Collection<V> remove(K key) {
        return this.map.remove(key);
    }

    @Override
    public boolean remove(K key, V value) {
        Collection<V> set = this.map.get(key);
        return set != null && set.remove(value);
    }

    @Override
    public void putAll(MultiMap<K, V> map) {
        if (map != null) {
            for (K key : map.keySet()) {
                this.putAll(key, map.get(key));
            }
        }
    }

    @Override
    public Map<K, Collection<V>> asMap() {
        return this.map;
    }

    @Override
    public String getString(K key) {
        Collection<V> v = this.get(key);
        return v != null ? v.iterator().next().toString() : null;
    }

    @Override
    public String getString(K key, String defaultValue) {
        Collection<V> collection = this.get(key);
        Iterator<V> iterator = collection != null ? collection.iterator() : null;
        Object v = iterator != null ? (Object)iterator.next() : null;
        return v != null ? v.toString() : defaultValue;
    }

    @Override
    public Integer getInteger(K key, int defaultValue) {
        Collection<V> collection = this.get(key);
        Iterator<V> iterator = collection != null ? collection.iterator() : null;
        Object v = iterator != null ? (Object)iterator.next() : null;
        return v != null ? Integer.parseInt(v.toString()) : defaultValue;
    }

    @Override
    public Boolean getBoolean(K key, boolean defaultValue) {
        Collection<V> collection = this.get(key);
        Iterator<V> iterator = collection != null ? collection.iterator() : null;
        Object v = iterator != null ? (Object)iterator.next() : null;
        return v != null ? Boolean.parseBoolean(v.toString()) : defaultValue;
    }

    public boolean equals(Object obj) {
        return obj instanceof AbstractMultiMap && this.map.equals(((AbstractMultiMap)obj).map);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return this.map.toString();
    }

    abstract Collection<V> newValues();

    abstract Map<K, Collection<V>> newMap();
}

