/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.netty.http.common.util;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.xbib.netty.http.common.util.ParameterMap;

public class CaseInsensitiveParameters
implements ParameterMap {
    private static final int BUCKET_SIZE = 17;
    private final MapEntry[] entries = new MapEntry[17];
    private final MapEntry head;

    private static int hash(String name) {
        int h = 0;
        for (int i = name.length() - 1; i >= 0; --i) {
            char c = name.charAt(i);
            if (c >= 'A' && c <= 'Z') {
                c = (char)(c + 32);
            }
            h = 31 * h + c;
        }
        if (h > 0) {
            return h;
        }
        if (h == Integer.MIN_VALUE) {
            return Integer.MAX_VALUE;
        }
        return -h;
    }

    private ParameterMap set0(Iterable<Map.Entry<String, String>> map) {
        this.clear();
        for (Map.Entry<String, String> entry : map) {
            this.add(entry.getKey(), entry.getValue());
        }
        return this;
    }

    @Override
    public ParameterMap setAll(ParameterMap headers) {
        return this.set0(headers);
    }

    @Override
    public int size() {
        return this.names().size();
    }

    private static boolean eq(String name1, String name2) {
        int nameLen = name1.length();
        if (nameLen != name2.length()) {
            return false;
        }
        for (int i = nameLen - 1; i >= 0; --i) {
            char c2;
            char c1 = name1.charAt(i);
            if (c1 == (c2 = name2.charAt(i))) continue;
            if (c1 >= 'A' && c1 <= 'Z') {
                c1 = (char)(c1 + 32);
            }
            if (c2 >= 'A' && c2 <= 'Z') {
                c2 = (char)(c2 + 32);
            }
            if (c1 == c2) continue;
            return false;
        }
        return true;
    }

    private static int index(int hash) {
        return hash % 17;
    }

    public CaseInsensitiveParameters() {
        this.head.before = this.head.after = (this.head = new MapEntry(-1, null, null));
    }

    @Override
    public ParameterMap add(String name, String strVal) {
        int h = CaseInsensitiveParameters.hash(name);
        int i = CaseInsensitiveParameters.index(h);
        this.add0(h, i, name, strVal);
        return this;
    }

    @Override
    public ParameterMap add(String name, Iterable<String> values) {
        int h = CaseInsensitiveParameters.hash(name);
        int i = CaseInsensitiveParameters.index(h);
        for (String vstr : values) {
            this.add0(h, i, name, vstr);
        }
        return this;
    }

    @Override
    public ParameterMap addAll(ParameterMap headers) {
        for (Map.Entry<String, String> entry : headers.entries()) {
            this.add(entry.getKey(), entry.getValue());
        }
        return this;
    }

    @Override
    public ParameterMap addAll(Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.add(entry.getKey(), entry.getValue());
        }
        return this;
    }

    @Override
    public ParameterMap remove(String name) {
        Objects.requireNonNull(name, "name");
        int h = CaseInsensitiveParameters.hash(name);
        int i = CaseInsensitiveParameters.index(h);
        this.remove0(h, i, name);
        return this;
    }

    @Override
    public ParameterMap set(String name, String strVal) {
        int h = CaseInsensitiveParameters.hash(name);
        int i = CaseInsensitiveParameters.index(h);
        this.remove0(h, i, name);
        this.add0(h, i, name, strVal);
        return this;
    }

    @Override
    public ParameterMap set(String name, Iterable<String> values) {
        Objects.requireNonNull(values, "values");
        int h = CaseInsensitiveParameters.hash(name);
        int i = CaseInsensitiveParameters.index(h);
        this.remove0(h, i, name);
        for (String v : values) {
            if (v == null) break;
            this.add0(h, i, name, v);
        }
        return this;
    }

    @Override
    public ParameterMap clear() {
        Arrays.fill(this.entries, null);
        this.head.before = this.head.after = this.head;
        return this;
    }

    @Override
    public String get(String name) {
        Objects.requireNonNull(name, "name");
        int h = CaseInsensitiveParameters.hash(name);
        int i = CaseInsensitiveParameters.index(h);
        MapEntry e = this.entries[i];
        String value = null;
        while (e != null) {
            if (e.hash == h && CaseInsensitiveParameters.eq(name, e.key)) {
                value = e.getValue();
            }
            e = e.next;
        }
        return value;
    }

    @Override
    public List<String> getAll(String name) {
        Objects.requireNonNull(name, "name");
        LinkedList<String> values = new LinkedList<String>();
        int h = CaseInsensitiveParameters.hash(name);
        int i = CaseInsensitiveParameters.index(h);
        MapEntry e = this.entries[i];
        while (e != null) {
            if (e.hash == h && CaseInsensitiveParameters.eq(name, e.key)) {
                values.addFirst(e.getValue());
            }
            e = e.next;
        }
        return values;
    }

    @Override
    public void forEach(Consumer<? super Map.Entry<String, String>> action) {
        MapEntry e = this.head.after;
        while (e != this.head) {
            action.accept(e);
            e = e.after;
        }
    }

    @Override
    public List<Map.Entry<String, String>> entries() {
        LinkedList<Map.Entry<String, String>> all = new LinkedList<Map.Entry<String, String>>();
        MapEntry e = this.head.after;
        while (e != this.head) {
            all.add(e);
            e = e.after;
        }
        return all;
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        return this.entries().iterator();
    }

    @Override
    public boolean contains(String name) {
        return this.get(name) != null;
    }

    @Override
    public boolean isEmpty() {
        return this.head == this.head.after;
    }

    @Override
    public List<String> names() {
        LinkedList<String> names = new LinkedList<String>();
        MapEntry e = this.head.after;
        while (e != this.head) {
            if (!names.contains(e.getKey())) {
                names.add(e.getKey());
            }
            e = e.after;
        }
        names.sort(String.CASE_INSENSITIVE_ORDER);
        return names;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : this) {
            sb.append(entry).append('\n');
        }
        return sb.toString();
    }

    private void add0(int h, int i, String name, String value) {
        MapEntry newEntry;
        MapEntry e = this.entries[i];
        this.entries[i] = newEntry = new MapEntry(h, name, value);
        newEntry.next = e;
        newEntry.addBefore(this.head);
    }

    private void remove0(int h, int i, String name) {
        MapEntry next;
        MapEntry e = this.entries[i];
        if (e == null) {
            return;
        }
        while (e.hash == h && CaseInsensitiveParameters.eq(name, e.key)) {
            e.remove();
            next = e.next;
            if (next != null) {
                this.entries[i] = next;
                e = next;
                continue;
            }
            this.entries[i] = null;
            return;
        }
        while ((next = e.next) != null) {
            if (next.hash == h && CaseInsensitiveParameters.eq(name, next.key)) {
                e.next = next.next;
                next.remove();
                continue;
            }
            e = next;
        }
    }

    private static final class MapEntry
    implements Map.Entry<String, String> {
        final int hash;
        final String key;
        String value;
        MapEntry next;
        MapEntry before;
        MapEntry after;

        MapEntry(int hash, String key, String value) {
            this.hash = hash;
            this.key = key;
            this.value = value;
        }

        void remove() {
            this.before.after = this.after;
            this.after.before = this.before;
        }

        void addBefore(MapEntry e) {
            this.after = e;
            this.before = e.before;
            this.before.after = this;
            this.after.before = this;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public String setValue(String value) {
            Objects.requireNonNull(value, "value");
            String oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public String toString() {
            return this.getKey() + ": " + this.getValue();
        }
    }
}

