/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.datasource;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.xipki.datasource.DatabaseType;
import org.xipki.util.Args;

class SqlErrorCodes {
    boolean useSqlStateForTranslation;
    Set<String> badSqlGrammarCodes = Collections.emptySet();
    Set<String> invalidResultSetAccessCodes = Collections.emptySet();
    Set<String> duplicateKeyCodes = Collections.emptySet();
    Set<String> dataIntegrityViolationCodes = Collections.emptySet();
    Set<String> permissionDeniedCodes = Collections.emptySet();
    Set<String> dataAccessResourceFailureCodes = Collections.emptySet();
    Set<String> transientDataAccessResourceCodes = Collections.emptySet();
    Set<String> cannotAcquireLockCodes = Collections.emptySet();
    Set<String> deadlockLoserCodes = Collections.emptySet();
    Set<String> cannotSerializeTransactionCodes = Collections.emptySet();

    private SqlErrorCodes() {
    }

    static SqlErrorCodes newInstance(DatabaseType dbType) {
        Args.notNull((Object)((Object)dbType), (String)"dbType");
        switch (dbType) {
            case DB2: {
                return new DB2();
            }
            case H2: {
                return new H2();
            }
            case HSQL: {
                return new HSQL();
            }
            case MYSQL: {
                return new MySQL();
            }
            case MARIADB: {
                return new MariaDB();
            }
            case ORACLE: {
                return new Oracle();
            }
            case POSTGRES: {
                return new PostgreSQL();
            }
            case UNKNOWN: {
                return new SqlErrorCodes();
            }
        }
        throw new IllegalStateException("should not reach here, unknown database type " + (Object)((Object)dbType));
    }

    private static Set<String> toSet(String ... strs) {
        if (strs == null || strs.length == 0) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(strs)));
    }

    private static Set<String> toSet(int ... ints) {
        if (ints == null || ints.length == 0) {
            return Collections.emptySet();
        }
        HashSet<String> set = new HashSet<String>();
        for (int i : ints) {
            set.add(Integer.toString(i));
        }
        return Collections.unmodifiableSet(set);
    }

    private static class PostgreSQL
    extends SqlErrorCodes {
        PostgreSQL() {
            this.useSqlStateForTranslation = true;
            this.badSqlGrammarCodes = SqlErrorCodes.toSet(new String[]{"03000", "42000", "42601", "42602", "42622", "42804", "42P01"});
            this.duplicateKeyCodes = SqlErrorCodes.toSet(new int[]{23505});
            this.dataIntegrityViolationCodes = SqlErrorCodes.toSet(new int[]{23000, 23502, 23503, 23514});
            this.dataAccessResourceFailureCodes = SqlErrorCodes.toSet(new int[]{53000, 53100, 53200, 53300});
            this.cannotAcquireLockCodes = SqlErrorCodes.toSet(new String[]{"55P03"});
            this.cannotSerializeTransactionCodes = SqlErrorCodes.toSet(new int[]{40001});
            this.deadlockLoserCodes = SqlErrorCodes.toSet(new String[]{"40P01"});
        }
    }

    private static class Oracle
    extends SqlErrorCodes {
        Oracle() {
            this.badSqlGrammarCodes = SqlErrorCodes.toSet(new int[]{900, 903, 904, 917, 936, 942, 17006, 6550});
            this.invalidResultSetAccessCodes = SqlErrorCodes.toSet(new int[]{17003});
            this.duplicateKeyCodes = SqlErrorCodes.toSet(new int[]{1});
            this.dataIntegrityViolationCodes = SqlErrorCodes.toSet(new int[]{1400, 1722, 2291, 2292});
            this.dataAccessResourceFailureCodes = SqlErrorCodes.toSet(new int[]{17002, 17447});
            this.cannotAcquireLockCodes = SqlErrorCodes.toSet(new int[]{54, 30006});
            this.cannotSerializeTransactionCodes = SqlErrorCodes.toSet(new int[]{8177});
            this.deadlockLoserCodes = SqlErrorCodes.toSet(new int[]{60});
        }
    }

    private static class MariaDB
    extends MySQL {
        MariaDB() {
        }
    }

    private static class MySQL
    extends SqlErrorCodes {
        MySQL() {
            this.badSqlGrammarCodes = SqlErrorCodes.toSet(new int[]{1054, 1064, 1146});
            this.duplicateKeyCodes = SqlErrorCodes.toSet(new int[]{1062});
            this.dataIntegrityViolationCodes = SqlErrorCodes.toSet(new int[]{630, 839, 840, 893, 1169, 1215, 1216, 1217, 1364, 1451, 1452, 1557});
            this.dataAccessResourceFailureCodes = SqlErrorCodes.toSet(new int[]{1});
            this.cannotAcquireLockCodes = SqlErrorCodes.toSet(new int[]{1205});
            this.deadlockLoserCodes = SqlErrorCodes.toSet(new int[]{1213});
        }
    }

    private static class HSQL
    extends SqlErrorCodes {
        HSQL() {
            this.badSqlGrammarCodes = SqlErrorCodes.toSet(new int[]{-22, -28});
            this.duplicateKeyCodes = SqlErrorCodes.toSet(new int[]{-104});
            this.dataIntegrityViolationCodes = SqlErrorCodes.toSet(new int[]{-9});
            this.dataAccessResourceFailureCodes = SqlErrorCodes.toSet(new int[]{-80});
        }
    }

    private static class H2
    extends SqlErrorCodes {
        H2() {
            this.badSqlGrammarCodes = SqlErrorCodes.toSet(new int[]{42000, 42001, 42101, 42102, 42111, 42112, 42121, 42122, 42132});
            this.duplicateKeyCodes = SqlErrorCodes.toSet(new int[]{23001, 23505});
            this.dataIntegrityViolationCodes = SqlErrorCodes.toSet(new int[]{22001, 22003, 22012, 22018, 22025, 23000, 23002, 23003, 23502, 23503, 23506, 23507, 23513});
            this.dataAccessResourceFailureCodes = SqlErrorCodes.toSet(new int[]{90046, 90100, 90117, 90121, 90126});
            this.cannotAcquireLockCodes = SqlErrorCodes.toSet(new int[]{50200});
        }
    }

    private static class DB2
    extends SqlErrorCodes {
        DB2() {
            this.badSqlGrammarCodes = SqlErrorCodes.toSet(new int[]{-7, -29, -97, -104, -109, -115, -128, -199, -204, -206, -301, -408, -441, -491});
            this.duplicateKeyCodes = SqlErrorCodes.toSet(new int[]{-803});
            this.dataIntegrityViolationCodes = SqlErrorCodes.toSet(new int[]{-407, -530, -531, -532, -543, -544, -545, -603, -667});
            this.dataAccessResourceFailureCodes = SqlErrorCodes.toSet(new int[]{-904, -971});
            this.transientDataAccessResourceCodes = SqlErrorCodes.toSet(new int[]{-1035, -1218, -30080, -30081});
            this.deadlockLoserCodes = SqlErrorCodes.toSet(new int[]{-911, -913});
        }
    }
}

