/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.api;

import java.util.Date;
import org.bouncycastle.asn1.ocsp.CrlID;
import org.xipki.security.CertRevocationInfo;
import org.xipki.security.HashAlgo;
import org.xipki.util.Args;

public class CertStatusInfo {
    private CertStatus certStatus;
    private CertRevocationInfo revocationInfo;
    private HashAlgo certHashAlgo;
    private byte[] certHash;
    private Date thisUpdate;
    private Date nextUpdate;
    private String certprofile;
    private CrlID crlId;
    private Date archiveCutOff;

    private CertStatusInfo(CertStatus certStatus, Date thisUpdate, Date nextUpdate, String certprofile) {
        this.certStatus = (CertStatus)((Object)Args.notNull((Object)((Object)certStatus), (String)"certStatus"));
        this.thisUpdate = (Date)Args.notNull((Object)thisUpdate, (String)"thisUpdate");
        this.nextUpdate = nextUpdate;
        this.certprofile = certprofile;
    }

    public Date getThisUpdate() {
        return this.thisUpdate;
    }

    public void setThisUpdate(Date thisUpdate) {
        this.thisUpdate = thisUpdate;
    }

    public Date getNextUpdate() {
        return this.nextUpdate;
    }

    public void setNextUpdate(Date nextUpdate) {
        this.nextUpdate = nextUpdate;
    }

    public CertStatus getCertStatus() {
        return this.certStatus;
    }

    public void setCertStatus(CertStatus certStatus) {
        this.certStatus = (CertStatus)((Object)Args.notNull((Object)((Object)certStatus), (String)"certStatus"));
    }

    public CertRevocationInfo getRevocationInfo() {
        return this.revocationInfo;
    }

    public HashAlgo getCertHashAlgo() {
        return this.certHashAlgo;
    }

    public byte[] getCertHash() {
        return this.certHash;
    }

    public String getCertprofile() {
        return this.certprofile;
    }

    public void setCertprofile(String certprofile) {
        this.certprofile = certprofile;
    }

    public CrlID getCrlId() {
        return this.crlId;
    }

    public void setCrlId(CrlID crlId) {
        this.crlId = crlId;
    }

    public Date getArchiveCutOff() {
        return this.archiveCutOff;
    }

    public void setArchiveCutOff(Date archiveCutOff) {
        this.archiveCutOff = archiveCutOff;
    }

    public static CertStatusInfo getCrlExpiredStatusInfo() {
        return new CertStatusInfo(CertStatus.CRL_EXPIRED, new Date(), null, null);
    }

    public static CertStatusInfo getUnknownCertStatusInfo(Date thisUpdate, Date nextUpdate) {
        return new CertStatusInfo(CertStatus.UNKNOWN, thisUpdate, nextUpdate, null);
    }

    public static CertStatusInfo getIgnoreCertStatusInfo(Date thisUpdate, Date nextUpdate) {
        return new CertStatusInfo(CertStatus.IGNORE, thisUpdate, nextUpdate, null);
    }

    public static CertStatusInfo getIssuerUnknownCertStatusInfo(Date thisUpdate, Date nextUpdate) {
        return new CertStatusInfo(CertStatus.ISSUER_UNKNOWN, thisUpdate, nextUpdate, null);
    }

    public static CertStatusInfo getGoodCertStatusInfo(HashAlgo certHashAlgo, byte[] certHash, Date thisUpdate, Date nextUpdate, String certprofile) {
        CertStatusInfo ret = new CertStatusInfo(CertStatus.GOOD, thisUpdate, nextUpdate, certprofile);
        ret.certHashAlgo = certHashAlgo;
        ret.certHash = certHash;
        return ret;
    }

    public static CertStatusInfo getGoodCertStatusInfo(Date thisUpdate, Date nextUpdate) {
        return new CertStatusInfo(CertStatus.GOOD, thisUpdate, nextUpdate, null);
    }

    public static CertStatusInfo getRevokedCertStatusInfo(CertRevocationInfo revocationInfo, HashAlgo certHashAlgo, byte[] certHash, Date thisUpdate, Date nextUpdate, String certprofile) {
        Args.notNull((Object)revocationInfo, (String)"revocationInfo");
        CertStatusInfo ret = new CertStatusInfo(CertStatus.REVOKED, thisUpdate, nextUpdate, certprofile);
        ret.revocationInfo = revocationInfo;
        ret.certHashAlgo = certHashAlgo;
        ret.certHash = certHash;
        return ret;
    }

    public static CertStatusInfo getRevokedCertStatusInfo(CertRevocationInfo revocationInfo, Date thisUpdate, Date nextUpdate) {
        Args.notNull((Object)revocationInfo, (String)"revocationInfo");
        CertStatusInfo ret = new CertStatusInfo(CertStatus.REVOKED, thisUpdate, nextUpdate, null);
        ret.revocationInfo = revocationInfo;
        return ret;
    }

    public static enum UnknownIssuerBehaviour {
        unknown,
        malformedRequest,
        internalError,
        unauthorized,
        tryLater;

    }

    public static enum UnknownCertBehaviour {
        unknown,
        good,
        malformedRequest,
        internalError,
        tryLater;

    }

    public static enum CertStatus {
        GOOD,
        REVOKED,
        UNKNOWN,
        IGNORE,
        ISSUER_UNKNOWN,
        CRL_EXPIRED;

    }
}

