/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ocsp.api;

import java.io.Closeable;
import java.math.BigInteger;
import java.util.Date;
import java.util.Map;
import org.xipki.datasource.DataSourceWrapper;
import org.xipki.ocsp.api.CertStatusInfo;
import org.xipki.ocsp.api.OcspStoreException;
import org.xipki.ocsp.api.RequestIssuer;
import org.xipki.security.X509Cert;
import org.xipki.util.Args;
import org.xipki.util.Validity;

public abstract class OcspStore
implements Closeable {
    protected static final long DAY = 86400000L;
    protected String name;
    protected CertStatusInfo.UnknownCertBehaviour unknownCertBehaviour = CertStatusInfo.UnknownCertBehaviour.unknown;
    protected int retentionInterval;
    protected boolean includeArchiveCutoff;
    protected boolean includeCrlId;
    protected boolean ignoreExpiredCert;
    protected boolean ignoreNotYetValidCert;
    protected Validity minNextUpdatePeriod;
    protected Validity updateInterval;

    public abstract boolean knowsIssuer(RequestIssuer var1);

    public abstract X509Cert getIssuerCert(RequestIssuer var1);

    protected boolean isIgnoreExpiredCrls() {
        return false;
    }

    public final CertStatusInfo getCertStatus(Date time, RequestIssuer reqIssuer, BigInteger serialNumber, boolean includeCertHash, boolean includeRit, boolean inheritCaRevocation) throws OcspStoreException {
        CertStatusInfo info = this.getCertStatus0(time, reqIssuer, serialNumber, includeCertHash, includeRit, inheritCaRevocation);
        if (!(info == null || this.minNextUpdatePeriod == null || this.isIgnoreExpiredCrls() || this.unknownCertBehaviour != CertStatusInfo.UnknownCertBehaviour.good && this.unknownCertBehaviour != CertStatusInfo.UnknownCertBehaviour.unknown)) {
            Date nextUpdate = info.getNextUpdate();
            Date minNextUpdate = this.minNextUpdatePeriod.add(time);
            if (nextUpdate != null) {
                if (minNextUpdate.after(nextUpdate)) {
                    info.setNextUpdate(minNextUpdate);
                }
            } else {
                info.setNextUpdate(minNextUpdate);
            }
        }
        return info;
    }

    protected abstract CertStatusInfo getCertStatus0(Date var1, RequestIssuer var2, BigInteger var3, boolean var4, boolean var5, boolean var6) throws OcspStoreException;

    public abstract void init(Map<String, ?> var1, DataSourceWrapper var2) throws OcspStoreException;

    public abstract boolean isHealthy();

    public void setName(String name) {
        this.name = Args.notBlank((String)name, (String)"name");
    }

    public String getName() {
        return this.name;
    }

    public CertStatusInfo.UnknownCertBehaviour getUnknownCertBehaviour() {
        return this.unknownCertBehaviour;
    }

    public void setUnknownCertBehaviour(CertStatusInfo.UnknownCertBehaviour unknownCertBehaviour) {
        this.unknownCertBehaviour = unknownCertBehaviour;
    }

    public boolean isIncludeArchiveCutoff() {
        return this.includeArchiveCutoff;
    }

    public void setIncludeArchiveCutoff(boolean includeArchiveCutoff) {
        this.includeArchiveCutoff = includeArchiveCutoff;
    }

    public int getRetentionInterval() {
        return this.retentionInterval;
    }

    public void setRetentionInterval(int retentionInterval) {
        this.retentionInterval = retentionInterval;
    }

    public boolean isIncludeCrlId() {
        return this.includeCrlId;
    }

    public void setIncludeCrlId(boolean includeCrlId) {
        this.includeCrlId = includeCrlId;
    }

    public boolean isIgnoreExpiredCert() {
        return this.ignoreExpiredCert;
    }

    public void setIgnoreExpiredCert(boolean ignoreExpiredCert) {
        this.ignoreExpiredCert = ignoreExpiredCert;
    }

    public boolean isIgnoreNotYetValidCert() {
        return this.ignoreNotYetValidCert;
    }

    public void setIgnoreNotYetValidCert(boolean ignoreNotYetValidCert) {
        this.ignoreNotYetValidCert = ignoreNotYetValidCert;
    }

    public Validity getMinNextUpdatePeriod() {
        return this.minNextUpdatePeriod;
    }

    public void setMinNextUpdatePeriod(Validity minNextUpdatePeriod) {
        this.minNextUpdatePeriod = minNextUpdatePeriod;
    }

    public Validity getUpdateInterval() {
        return this.updateInterval;
    }

    public void setUpdateInterval(Validity updateInterval) {
        this.updateInterval = updateInterval;
    }
}

