/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import org.xlightweb.HttpUtils;
import org.xlightweb.IEventDataSource;
import org.xlightweb.IEventHandler;
import org.xlightweb.IUnsynchronized;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class IEventHandlerInfo {
    private final boolean isUnsynchronized;
    private final boolean isOnConnectMultithreaded;
    private final boolean isOnMessageMultithreaded;
    private final boolean isOnDisconnectMultithreaded;

    IEventHandlerInfo(Class<IEventHandler> clazz) {
        if (clazz != null) {
            boolean isMultiThreaded = HttpUtils.isHandlerMultithreaded(clazz, (boolean)true);
            this.isUnsynchronized = IUnsynchronized.class.isAssignableFrom(clazz);
            this.isOnConnectMultithreaded = HttpUtils.isMethodMultithreaded(clazz, (String)"onConnect", (boolean)isMultiThreaded, (Class[])new Class[]{IEventDataSource.class});
            this.isOnDisconnectMultithreaded = HttpUtils.isMethodMultithreaded(clazz, (String)"onDisconnect", (boolean)isMultiThreaded, (Class[])new Class[]{IEventDataSource.class});
            this.isOnMessageMultithreaded = HttpUtils.isMethodMultithreaded(clazz, (String)"onMessage", (boolean)isMultiThreaded, (Class[])new Class[]{IEventDataSource.class});
        } else {
            this.isUnsynchronized = true;
            this.isOnConnectMultithreaded = false;
            this.isOnMessageMultithreaded = false;
            this.isOnDisconnectMultithreaded = false;
        }
    }

    public boolean isOnConnectMultithreaded() {
        return this.isOnConnectMultithreaded;
    }

    public boolean isOnMessageMultithreaded() {
        return this.isOnMessageMultithreaded;
    }

    public boolean isOnDisconnectMultithreaded() {
        return this.isOnDisconnectMultithreaded;
    }

    public boolean isUnsynchronized() {
        return this.isUnsynchronized;
    }
}

