/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URL;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.AbstractHttpConnection;
import org.xlightweb.GetRequest;
import org.xlightweb.HttpResponse;
import org.xlightweb.HttpResponseHeader;
import org.xlightweb.HttpUtils;
import org.xlightweb.IHttpExchange;
import org.xlightweb.IHttpRequest;
import org.xlightweb.IHttpRequestHeader;
import org.xlightweb.IHttpResponse;
import org.xlightweb.IHttpResponseHeader;
import org.xlightweb.IWebSocketConnection;
import org.xlightweb.IWebSocketHandler;
import org.xlightweb.IWriteCompleteHandler;
import org.xlightweb.UnsupportedProtocolException;
import org.xlightweb.WebSocketHandlerAdapter;
import org.xlightweb.WebSocketMessage;
import org.xlightweb.client.HttpClientConnection;
import org.xlightweb.client.IHttpClientEndpoint;
import org.xlightweb.server.HttpServerConnection;
import org.xsocket.Execution;
import org.xsocket.MaxReadSizeExceededException;
import org.xsocket.connection.IConnectHandler;
import org.xsocket.connection.IDataHandler;
import org.xsocket.connection.IDisconnectHandler;
import org.xsocket.connection.IHandler;
import org.xsocket.connection.INonBlockingConnection;
import org.xsocket.connection.NonBlockingConnectionPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WebSocketConnection
implements IWebSocketConnection {
    private static final Logger LOG = Logger.getLogger(WebSocketConnection.class.getName());
    private INonBlockingConnection tcpConnection;
    public static final int DEFAULT_RECEIVE_TIMEOUT = Integer.MAX_VALUE;
    private int receiveTimeoutSec = Integer.MAX_VALUE;
    private final WebSocketProtocolHandler protocolHandler = new WebSocketProtocolHandler();
    private final AbstractHttpConnection.IMultimodeExecutor executor;
    private final List<WebSocketMessage> inQueue = new ArrayList<WebSocketMessage>();
    private int inQueueVersion = 0;
    private final IHttpRequestHeader upgradeRequestHeader;
    private final IHttpResponseHeader upgradeResponseHeader;
    private final IPostWriteInterceptor interceptor;
    private final Object webSocketHandlerGuard = new Object();
    private WebSocketHandlerAdapter webSocketHandlerAdapter = null;
    private final AtomicReference<IOException> exceptionRef = new AtomicReference<Object>(null);
    private boolean isDisconnected = false;
    private AtomicReference<Object> attachmentRef = new AtomicReference<Object>(null);

    public WebSocketConnection(String uriString) throws IOException {
        this(uriString, (String)null);
    }

    public WebSocketConnection(String uriString, String protocol) throws IOException {
        this(uriString, protocol, null);
    }

    public WebSocketConnection(String uriString, IWebSocketHandler webSocketHandler) throws IOException {
        this(uriString, null, webSocketHandler);
    }

    public WebSocketConnection(String uriString, String protocol, IWebSocketHandler webSocketHandler) throws IOException {
        this(URI.create(uriString), protocol, webSocketHandler);
    }

    private WebSocketConnection(URI uri, String protocol, IWebSocketHandler webSocketHandler) throws IOException {
        this((IHttpClientEndpoint)WebSocketConnection.connect(uri), uri, protocol, webSocketHandler);
    }

    private static HttpClientConnection connect(URI uri) throws IOException {
        int port = uri.getPort();
        if (port == -1) {
            port = uri.getScheme().toLowerCase().equals("wss") ? 443 : 80;
        }
        return new HttpClientConnection(uri.getHost(), port);
    }

    public WebSocketConnection(IHttpClientEndpoint httpClientEndpoint, URI uri, String protocol, IWebSocketHandler webSocketHandler) throws IOException {
        this(WebSocketConnection.performHandshake(httpClientEndpoint, uri, protocol), protocol, webSocketHandler);
    }

    private WebSocketConnection(HandeshakeResult handeshakeResult, String protocol, IWebSocketHandler webSocketHandler) throws IOException {
        this(handeshakeResult.con, webSocketHandler, handeshakeResult.upgradeRequestHeader, handeshakeResult.upgradeResponseHeader);
    }

    private WebSocketConnection(HttpClientConnection httpConnection, IWebSocketHandler webSocketHandler, IHttpRequestHeader upgradeRequestHeader, IHttpResponseHeader upgradeResponseHeader) throws IOException {
        this(WebSocketConnection.convertToTcpConnection((AbstractHttpConnection)httpConnection), null, webSocketHandler, null, upgradeRequestHeader, upgradeResponseHeader);
    }

    private static HandeshakeResult performHandshake(IHttpClientEndpoint httpClientEndpoint, URI uri, String protocol) throws IOException {
        GetRequest request = new GetRequest(uri.toString());
        request.setHeader("Upgrade", "WebSocket");
        request.setHeader("Connection", "Upgrade");
        URL originURL = request.getRequestUrl();
        String origin = originURL.getProtocol() + "//" + originURL.getHost();
        if (originURL.getPort() != -1) {
            origin = origin + ":" + originURL.getPort();
        }
        request.setHeader("Origin", origin);
        if (protocol != null) {
            request.setHeader("WebSocket-Protocol", protocol);
        }
        IHttpResponse response = httpClientEndpoint.call((IHttpRequest)request);
        HttpClientConnection httpCon = (HttpClientConnection)HttpUtils.getConnectionFromAttribute((IHttpResponseHeader)response.getResponseHeader());
        if (response.getStatus() != 101) {
            if (response.getStatus() == 501) {
                if (response.hasBody()) {
                    throw new UnsupportedProtocolException(response.getBody().toString());
                }
                throw new UnsupportedProtocolException();
            }
            throw new IOException(response.getStatus() + " " + response.getReason());
        }
        return new HandeshakeResult(httpCon, request.getRequestHeader(), response.getResponseHeader());
    }

    public WebSocketConnection(HttpServerConnection httpConnection, IWebSocketHandler webSocketHandler, IHttpExchange exchange) throws IOException {
        this(httpConnection, webSocketHandler, new UpgradeResponseSender(exchange));
    }

    private WebSocketConnection(HttpServerConnection httpConnection, IWebSocketHandler webSocketHandler, UpgradeResponseSender upgradeHandler) throws IOException {
        this(httpConnection, webSocketHandler, upgradeHandler.getRequestHeader(), upgradeHandler.getResponseHeader(), upgradeHandler);
    }

    private static INonBlockingConnection convertToTcpConnection(AbstractHttpConnection httpConnection) throws IOException {
        INonBlockingConnection tcpCon = httpConnection.getUnderlyingTcpConnection();
        tcpCon.setHandler(null);
        return tcpCon;
    }

    private WebSocketConnection(HttpServerConnection httpConnection, IWebSocketHandler webSocketHandler, IHttpRequestHeader upgradeRequestHeader, IHttpResponseHeader upgradeResponseHeader, UpgradeResponseSender upgradeResponseSender) throws IOException {
        this(WebSocketConnection.convertToTcpConnection((AbstractHttpConnection)httpConnection), upgradeResponseSender, webSocketHandler, upgradeResponseSender, upgradeRequestHeader, upgradeResponseHeader);
    }

    private WebSocketConnection(INonBlockingConnection tcpConnection, IPostWriteInterceptor connectInterceptor, IWebSocketHandler webSocketHandler, WebSocketHandlerAdapter.IPostConnectInterceptor postConnectInterceptor, IHttpRequestHeader upgradeRequestHeader, IHttpResponseHeader upgradeResponseHeader) throws IOException {
        this.interceptor = connectInterceptor;
        this.tcpConnection = tcpConnection;
        this.upgradeRequestHeader = upgradeRequestHeader;
        this.upgradeResponseHeader = upgradeResponseHeader;
        this.executor = HttpUtils.newMultimodeExecutor((Executor)tcpConnection.getWorkerpool());
        this.setMessageHandler(webSocketHandler, postConnectInterceptor);
        this.protocolHandler.onConnect(tcpConnection);
        tcpConnection.setHandler((IHandler)this.protocolHandler);
    }

    @Override
    public String getProtocol() {
        return this.getUpgradeResponseHeader().getHeader("WebSocket-Protocol");
    }

    @Override
    public String getWebSocketLocation() {
        return this.getUpgradeResponseHeader().getHeader("WebSocket-Location");
    }

    @Override
    public String getWebSocketOrigin() {
        return this.getUpgradeResponseHeader().getHeader("WebSocket-Origin");
    }

    @Override
    public IHttpRequestHeader getUpgradeRequestHeader() {
        return this.upgradeRequestHeader;
    }

    @Override
    public IHttpResponseHeader getUpgradeResponseHeader() {
        return this.upgradeResponseHeader;
    }

    @Override
    public void destroy() {
        block2: {
            try {
                NonBlockingConnectionPool.destroy((INonBlockingConnection)this.tcpConnection);
            }
            catch (IOException ioe) {
                if (!LOG.isLoggable(Level.FINE)) break block2;
                LOG.fine("[" + this.getId() + "] error occured by destroying htttp connection " + this.getId() + " " + ioe.toString());
            }
        }
    }

    public INonBlockingConnection getUnderlyingTcpConnection() {
        return this.tcpConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int availableMessages() {
        List<WebSocketMessage> list = this.inQueue;
        synchronized (list) {
            return this.inQueue.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getInQueueVersion() {
        List<WebSocketMessage> list = this.inQueue;
        synchronized (list) {
            return this.inQueueVersion;
        }
    }

    public String toString() {
        return this.tcpConnection.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WebSocketMessage readMessage() throws BufferUnderflowException, SocketTimeoutException, ClosedChannelException, IOException {
        long start = System.currentTimeMillis();
        long remainingTime = this.receiveTimeoutSec;
        do {
            List<WebSocketMessage> list = this.inQueue;
            synchronized (list) {
                IOException ioe = this.exceptionRef.getAndSet(null);
                if (ioe != null) {
                    throw ioe;
                }
                if (this.isDisconnected) {
                    throw new ClosedChannelException();
                }
                if (this.inQueue.isEmpty()) {
                    try {
                        this.inQueue.wait(remainingTime);
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                    }
                } else {
                    ++this.inQueueVersion;
                    return this.inQueue.remove(0);
                }
            }
        } while ((remainingTime = HttpUtils.computeRemainingTime((long)start, (int)this.receiveTimeoutSec)) > 0L);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("receive timeout " + this.receiveTimeoutSec + " sec reached. throwing timeout exception");
        }
        throw new SocketTimeoutException("timeout " + this.receiveTimeoutSec + " sec reached");
    }

    @Override
    public int writeMessage(WebSocketMessage msg) throws IOException {
        if (this.interceptor != null) {
            this.interceptor.onPreWrite();
        }
        return msg.writeTo(this, null);
    }

    @Override
    public void writeMessage(WebSocketMessage msg, IWriteCompleteHandler writtenHandler) throws IOException {
        if (this.interceptor != null) {
            this.interceptor.onPreWrite();
        }
        msg.writeTo(this, writtenHandler);
    }

    @Override
    public void closeQuitly() {
        block5: {
            try {
                this.close();
            }
            catch (IOException ioe) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + this.getId() + "] error occured by closing connection " + this.getId() + " " + ioe.toString());
                }
                try {
                    NonBlockingConnectionPool.destroy((INonBlockingConnection)this.tcpConnection);
                }
                catch (IOException e) {
                    if (!LOG.isLoggable(Level.FINE)) break block5;
                    LOG.fine("[" + this.getId() + "] error occured by closing connection " + this.getId() + " " + e.toString());
                }
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.destroy();
    }

    void processNonthreaded(Runnable task) {
        this.executor.processNonthreaded(task);
    }

    void processMultithreaded(Runnable task) {
        this.executor.processMultithreaded(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setMessageHandler(IWebSocketHandler webSocketHandler, WebSocketHandlerAdapter.IPostConnectInterceptor postConnectInterceptor) throws IOException {
        Object object = this.webSocketHandlerGuard;
        synchronized (object) {
            if (this.webSocketHandlerAdapter != null) {
                this.webSocketHandlerAdapter.onDisconnect(this);
            }
            this.webSocketHandlerAdapter = new WebSocketHandlerAdapter(webSocketHandler, postConnectInterceptor);
            this.webSocketHandlerAdapter.onConnect(this);
        }
    }

    public boolean isOpen() {
        return this.tcpConnection.isOpen();
    }

    public boolean isServerSide() {
        return this.tcpConnection.isServerSide();
    }

    public INonBlockingConnection getTcpConnection() {
        return this.tcpConnection;
    }

    public void setAttachment(Object obj) {
        this.attachmentRef.set(obj);
    }

    public Object getAttachment() {
        return this.attachmentRef.get();
    }

    public long getConnectionTimeoutMillis() {
        return this.tcpConnection.getConnectionTimeoutMillis();
    }

    public void setConnectionTimeoutMillis(long timeoutMillis) {
        this.tcpConnection.setConnectionTimeoutMillis(timeoutMillis);
    }

    public long getRemainingMillisToConnectionTimeout() {
        return this.tcpConnection.getRemainingMillisToConnectionTimeout();
    }

    public long getIdleTimeoutMillis() {
        return this.tcpConnection.getIdleTimeoutMillis();
    }

    public void setIdleTimeoutMillis(long timeoutInMillis) {
        this.tcpConnection.setIdleTimeoutMillis(timeoutInMillis);
    }

    public long getRemainingMillisToIdleTimeout() {
        return this.tcpConnection.getRemainingMillisToIdleTimeout();
    }

    @Override
    public String getId() {
        return this.tcpConnection.getId();
    }

    public int getLocalPort() {
        return this.tcpConnection.getLocalPort();
    }

    public InetAddress getLocalAddress() {
        return this.tcpConnection.getLocalAddress();
    }

    public InetAddress getRemoteAddress() {
        return this.tcpConnection.getRemoteAddress();
    }

    public int getRemotePort() {
        return this.tcpConnection.getRemotePort();
    }

    public Object getOption(String name) throws IOException {
        return this.tcpConnection.getOption(name);
    }

    public Map<String, Class> getOptions() {
        return this.tcpConnection.getOptions();
    }

    public void setOption(String name, Object value) throws IOException {
        this.tcpConnection.setOption(name, value);
    }

    private static interface IPostWriteInterceptor {
        public void onPreWrite() throws IOException;
    }

    @Execution(value=0)
    private final class WebSocketProtocolHandler
    implements IConnectHandler,
    IDataHandler,
    IDisconnectHandler {
        private ByteBuffer rawBuffer = null;

        private WebSocketProtocolHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean onConnect(INonBlockingConnection connection) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
            Object object = WebSocketConnection.this.webSocketHandlerGuard;
            synchronized (object) {
                if (WebSocketConnection.this.webSocketHandlerAdapter != null) {
                    WebSocketConnection.this.webSocketHandlerAdapter.onConnect(WebSocketConnection.this);
                }
            }
            return true;
        }

        public boolean onData(INonBlockingConnection connection) throws IOException, BufferUnderflowException, ClosedChannelException, MaxReadSizeExceededException {
            if (connection.isOpen()) {
                int available = connection.available();
                ByteBuffer[] data = null;
                if (available > 0) {
                    data = connection.readByteBufferByLength(available);
                }
                this.onData(data);
            }
            return true;
        }

        void onData(ByteBuffer[] data) throws IOException {
            if (data == null) {
                if (this.rawBuffer == null) {
                    this.rawBuffer = ByteBuffer.allocate(0);
                }
            } else {
                this.rawBuffer = this.rawBuffer == null ? HttpUtils.merge((ByteBuffer[])data) : HttpUtils.merge((ByteBuffer)this.rawBuffer, (ByteBuffer[])data);
            }
            this.parse(this.rawBuffer);
            if (!this.rawBuffer.hasRemaining()) {
                this.rawBuffer = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void parse(ByteBuffer buffer) throws IOException {
            while (buffer.hasRemaining()) {
                WebSocketMessage msg = WebSocketMessage.parse(buffer);
                if (msg == null) {
                    return;
                }
                Object object = WebSocketConnection.this.inQueue;
                synchronized (object) {
                    WebSocketConnection.this.inQueueVersion++;
                    WebSocketConnection.this.inQueue.add(msg);
                    WebSocketConnection.this.inQueue.notifyAll();
                }
                object = WebSocketConnection.this.webSocketHandlerGuard;
                synchronized (object) {
                    if (WebSocketConnection.this.webSocketHandlerAdapter != null) {
                        WebSocketConnection.this.webSocketHandlerAdapter.onMessage(WebSocketConnection.this);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean onDisconnect(INonBlockingConnection connection) throws IOException {
            Object object = WebSocketConnection.this.inQueue;
            synchronized (object) {
                WebSocketConnection.this.isDisconnected = true;
                if (this.rawBuffer != null && this.rawBuffer.hasRemaining()) {
                    WebSocketConnection.this.exceptionRef.set(new IOException("connection terminated while receiving data"));
                }
                WebSocketConnection.this.inQueue.notifyAll();
            }
            object = WebSocketConnection.this.webSocketHandlerGuard;
            synchronized (object) {
                if (WebSocketConnection.this.webSocketHandlerAdapter != null) {
                    WebSocketConnection.this.webSocketHandlerAdapter.onDisconnect(WebSocketConnection.this);
                }
            }
            return true;
        }
    }

    private static final class UpgradeResponseSender
    implements WebSocketHandlerAdapter.IPostConnectInterceptor,
    IPostWriteInterceptor {
        private final IHttpExchange exchange;
        private final AtomicBoolean isUpgradeSent = new AtomicBoolean(false);
        private final IHttpResponseHeader responseHeader;

        public UpgradeResponseSender(IHttpExchange exchange) {
            this.exchange = exchange;
            String protocol = exchange.getRequest().getHeader("WebSocket-Protocol");
            String webSocketOrigin = exchange.getRequest().getHeader("Origin");
            String webSocketLocation = exchange.getRequest().isSecure() ? "wss://" + exchange.getRequest().getHost() + exchange.getRequest().getRequestURI() : "ws://" + exchange.getRequest().getHost() + exchange.getRequest().getRequestURI();
            this.responseHeader = new HttpResponseHeader(101);
            this.responseHeader.setReason("Web Socket Protocol Handshake");
            this.responseHeader.setHeader("Upgrade", "WebSocket");
            this.responseHeader.setHeader("Connection", "Upgrade");
            this.responseHeader.setHeader("WebSocket-Origin", webSocketOrigin);
            this.responseHeader.setHeader("WebSocket-Location", webSocketLocation);
            if (protocol != null) {
                this.responseHeader.setHeader("WebSocket-Protocol", protocol);
            }
        }

        public void onConnectException(IOException ioe) {
            if (ioe instanceof UnsupportedProtocolException) {
                this.exchange.sendError(501, ioe.getMessage());
            } else {
                this.exchange.sendError(501);
            }
        }

        public void onPostConnect() throws IOException {
            this.sentUpgradeIfNecessary();
        }

        public void onPreWrite() throws IOException {
            this.sentUpgradeIfNecessary();
        }

        private void sentUpgradeIfNecessary() throws IOException {
            if (!this.isUpgradeSent.getAndSet(true)) {
                this.exchange.send((IHttpResponse)new HttpResponse(this.responseHeader));
            }
        }

        IHttpRequestHeader getRequestHeader() {
            return this.exchange.getRequest().getRequestHeader();
        }

        IHttpResponseHeader getResponseHeader() {
            return this.responseHeader;
        }
    }

    private static final class HandeshakeResult {
        private HttpClientConnection con;
        private IHttpRequestHeader upgradeRequestHeader;
        private IHttpResponseHeader upgradeResponseHeader;

        public HandeshakeResult(HttpClientConnection con, IHttpRequestHeader upgradeRequestHeader, IHttpResponseHeader upgradeResponseHeader) {
            this.con = con;
            this.upgradeRequestHeader = upgradeRequestHeader;
            this.upgradeResponseHeader = upgradeResponseHeader;
        }
    }
}

