/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb.server;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.xlightweb.BadMessageException;
import org.xlightweb.IHttpExchange;
import org.xlightweb.IHttpRequest;
import org.xlightweb.IHttpRequestHandler;
import org.xlightweb.IWebHandler;
import org.xlightweb.IWebSocketHandler;
import org.xlightweb.WebSocketConnection;
import org.xlightweb.server.HttpServer;
import org.xlightweb.server.HttpServerConnection;
import org.xlightweb.server.IUpgradeHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XHttpServer
extends HttpServer {
    public XHttpServer(IWebHandler webHandler) throws UnknownHostException, IOException {
        this(webHandler, new HashMap<String, Object>());
    }

    public XHttpServer(IWebHandler webHandler, Map<String, Object> options) throws UnknownHostException, IOException {
        this(new InetSocketAddress(0), options, webHandler, null, false, MIN_SIZE_WORKER_POOL, SIZE_WORKER_POOL);
    }

    public XHttpServer(int port, IWebHandler webHandler) throws UnknownHostException, IOException {
        this(port, webHandler, MIN_SIZE_WORKER_POOL, SIZE_WORKER_POOL);
    }

    public XHttpServer(int port, IWebHandler webHandler, int minPoolsize, int maxPoolsize) throws UnknownHostException, IOException {
        this(port, webHandler, null, false, minPoolsize, maxPoolsize);
    }

    public XHttpServer(int port, IWebHandler webHandler, Map<String, Object> options) throws UnknownHostException, IOException {
        this(port, webHandler, options, null, false);
    }

    public XHttpServer(InetAddress address, int port, IWebHandler webHandler) throws UnknownHostException, IOException {
        this(address, port, webHandler, null, false);
    }

    public XHttpServer(String ipAddress, int port, IWebHandler webHandler) throws UnknownHostException, IOException {
        this(InetAddress.getByName(ipAddress), port, webHandler);
    }

    public XHttpServer(String ipAddress, int port, IWebHandler webHandler, Map<String, Object> options) throws UnknownHostException, IOException {
        this(InetAddress.getByName(ipAddress), port, webHandler, options, null, false);
    }

    public XHttpServer(int port, IWebHandler webHandler, SSLContext sslContext, boolean sslOn) throws UnknownHostException, IOException {
        this(port, webHandler, new HashMap<String, Object>(), sslContext, sslOn);
    }

    public XHttpServer(int port, IWebHandler webHandler, SSLContext sslContext, boolean sslOn, int minPoolsize, int maxPoolsize) throws UnknownHostException, IOException {
        this(new InetSocketAddress(port), new HashMap<String, Object>(), webHandler, sslContext, sslOn, minPoolsize, maxPoolsize);
    }

    public XHttpServer(int port, IWebHandler webHandler, Map<String, Object> options, SSLContext sslContext, boolean sslOn) throws UnknownHostException, IOException {
        this(new InetSocketAddress(port), options, webHandler, sslContext, sslOn, MIN_SIZE_WORKER_POOL, SIZE_WORKER_POOL);
    }

    public XHttpServer(String ipAddress, int port, IWebHandler webHandler, SSLContext sslContext, boolean sslOn) throws UnknownHostException, IOException {
        this(ipAddress, port, webHandler, new HashMap<String, Object>(), sslContext, sslOn);
    }

    public XHttpServer(String ipAddress, int port, IWebHandler webHandler, Map<String, Object> options, SSLContext sslContext, boolean sslOn) throws UnknownHostException, IOException {
        this(InetAddress.getByName(ipAddress), port, webHandler, options, sslContext, sslOn);
    }

    public XHttpServer(InetAddress address, int port, IWebHandler webHandler, SSLContext sslContext, boolean sslOn) throws UnknownHostException, IOException {
        this(address, port, webHandler, new HashMap<String, Object>(), sslContext, sslOn);
    }

    public XHttpServer(InetAddress address, int port, IWebHandler webHandler, Map<String, Object> options, SSLContext sslContext, boolean sslOn) throws UnknownHostException, IOException {
        this(new InetSocketAddress(address, port), options, webHandler, sslContext, sslOn, MIN_SIZE_WORKER_POOL, SIZE_WORKER_POOL);
    }

    XHttpServer(InetSocketAddress address, Map<String, Object> options, IWebHandler webHandler, SSLContext sslContext, boolean sslOn, int minPoolsize, int maxPoolsize) throws UnknownHostException, IOException {
        super(address, options, XHttpServer.getRequestHandler(webHandler), (IUpgradeHandler)new WebSocketUpgradeHandler(webHandler), sslContext, sslOn, minPoolsize, maxPoolsize);
    }

    private static IHttpRequestHandler getRequestHandler(IWebHandler webHandler) {
        if (IHttpRequestHandler.class.isAssignableFrom(webHandler.getClass())) {
            return (IHttpRequestHandler)webHandler;
        }
        return null;
    }

    private static final class WebSocketUpgradeHandler
    implements IUpgradeHandler {
        private final IWebSocketHandler webSocketHandler;

        public WebSocketUpgradeHandler(IWebHandler webHandler) {
            this.webSocketHandler = IWebSocketHandler.class.isAssignableFrom(webHandler.getClass()) ? (IWebSocketHandler)webHandler : null;
        }

        public boolean onRequest(IHttpExchange exchange) throws IOException, BadMessageException {
            IHttpRequest request = exchange.getRequest();
            if (this.webSocketHandler != null && request.getHeader("Upgrade").equalsIgnoreCase("WebSocket") && request.getProtocolVersion().endsWith("1.1")) {
                new WebSocketConnection((HttpServerConnection)exchange.getConnection(), this.webSocketHandler, exchange);
                return true;
            }
            return false;
        }
    }
}

