/*
 * Decompiled with CFR 0.152.
 */
package org.xmlresolver.apps;

import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.GregorianCalendar;
import java.util.Vector;
import org.w3c.dom.Element;
import org.xmlresolver.ResourceCache;
import org.xmlresolver.ResourceConnection;
import org.xmlresolver.helpers.DOMUtils;

public class CacheInfo {
    private static String usage = "Usage: CacheInfo cache-directory";
    private static GregorianCalendar now = new GregorianCalendar();

    public static void main(String[] args) {
        CacheInfo cache = new CacheInfo();
        if (args.length != 1) {
            System.err.println(usage);
            System.exit(1);
        }
        cache.run(args[0]);
    }

    public void run(String dir) {
        ResourceCache cache = new ResourceCache(dir);
        Element catalog = cache.catalog();
        Vector expired = new Vector();
        Vector uptodate = new Vector();
        if (catalog == null) {
            System.err.println(usage);
            System.exit(2);
        }
        int count = 0;
        Element entry = DOMUtils.getFirstElement((Element)catalog);
        while (entry != null) {
            Object uri = null;
            if ("uri".equals(entry.getLocalName())) {
                ++count;
            } else if ("system".equals(entry.getLocalName())) {
                ++count;
            }
            entry = DOMUtils.getNextElement((Element)entry);
        }
        System.out.println("Cache contains " + count + " entries.");
        entry = DOMUtils.getFirstElement((Element)catalog);
        while (entry != null) {
            Long cacheTime = -1L;
            String timestr = DOMUtils.attr((Element)entry, (String)"http://xmlresolver.org/ns/catalog", (String)"time");
            if (timestr != null) {
                cacheTime = Long.parseLong(timestr);
            }
            String etag = DOMUtils.attr((Element)entry, (String)"http://xmlresolver.org/ns/catalog", (String)"etag");
            if ("uri".equals(entry.getLocalName())) {
                System.out.println("URI:    " + entry.getAttribute("name"));
                this.showLocalFile(entry.getAttribute("uri"));
                System.out.println("\tCached on " + this.showTime(cacheTime));
                this.checkLastModified(entry.getAttribute("name"), cacheTime, etag);
                if (cache.expired(entry.getAttribute("name"), entry.getAttribute("uri"), entry)) {
                    System.out.println("\tEXPIRED");
                }
            } else if ("system".equals(entry.getLocalName())) {
                System.out.println("SYSTEM: " + entry.getAttribute("systemId"));
                this.showLocalFile(entry.getAttribute("uri"));
                System.out.println("\tCached on " + this.showTime(cacheTime));
                this.checkLastModified(entry.getAttribute("systemId"), cacheTime, etag);
                if (cache.expired(entry.getAttribute("systemId"), entry.getAttribute("uri"), entry)) {
                    System.out.println("\tEXPIRED");
                }
            } else if ("public".equals(entry.getLocalName())) {
                System.out.println("PUBLIC: " + entry.getAttribute("publicId"));
                this.showLocalFile(entry.getAttribute("uri"));
            } else {
                System.out.println("UNEXPECTED ENTRY TYPE!");
                this.showLocalFile(entry.getAttribute("uri"));
                System.out.println("\tCached on " + this.showTime(cacheTime));
            }
            entry = DOMUtils.getNextElement((Element)entry);
        }
    }

    private void showLocalFile(String filename) {
        System.out.println("\tLocal: " + filename);
    }

    private String showTime(long cacheTime) {
        String[] months = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
        GregorianCalendar cacheDate = new GregorianCalendar();
        cacheDate.setTimeInMillis(cacheTime);
        String result = cacheDate.get(5) + " ";
        result = result + months[cacheDate.get(2)] + " ";
        result = result + cacheDate.get(1) + " at ";
        if (cacheDate.get(10) < 10) {
            result = result + "0";
        }
        result = result + cacheDate.get(10) + ":";
        if (cacheDate.get(12) < 10) {
            result = result + "0";
        }
        result = result + cacheDate.get(12) + ":";
        if (cacheDate.get(13) < 10) {
            result = result + "0";
        }
        result = result + cacheDate.get(13);
        return result;
    }

    private void checkLastModified(String origURI, long cacheTime, String cachedEtag) {
        if (origURI == null || !origURI.startsWith("http:") && !origURI.startsWith("https:")) {
            System.out.println("\tCan't check age of actual resource.");
        }
        ResourceConnection rconn = new ResourceConnection(origURI);
        rconn.close();
        long lastModified = rconn.getLastModified();
        String etag = rconn.getEtag();
        if (rconn.getStatusCode() != 200) {
            System.out.println("\tHTTP returned " + rconn.getStatusCode());
        }
        if (lastModified <= 0L) {
            System.out.println("\tServer did not report last-modified");
        } else {
            System.out.println("\tLast modified on " + this.showTime(lastModified));
        }
        if (etag != null && cachedEtag != null) {
            if (etag.equals(cachedEtag)) {
                System.out.println("\tEtags match: " + etag);
            } else {
                System.out.println("\tEtags don't match: " + cachedEtag + " =/= " + etag);
            }
        }
        if (lastModified > cacheTime) {
            System.out.println("\tEXPIRED");
        }
    }

    private boolean expired(String origURI, String uri, long cacheTime) {
        if (origURI == null || !origURI.startsWith("http:")) {
            System.out.println(uri + ":");
            System.out.println("\t" + origURI);
            System.out.println("\tNot http:");
            return false;
        }
        try {
            URL url = new URL(uri);
            File localFile = new File(url.getPath());
            localFile.setLastModified(now.getTimeInMillis());
        }
        catch (MalformedURLException url) {
            // empty catch block
        }
        long lastModified = 0L;
        try {
            URL url = new URL(origURI);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            lastModified = conn.getLastModified();
            if (conn.getResponseCode() != 200) {
                System.out.println(uri + ":");
                System.out.println("\t" + origURI);
                System.out.println("\tHTTP returned " + conn.getResponseCode());
                return false;
            }
        }
        catch (MalformedURLException mue) {
            System.out.println(uri + ":");
            System.out.println("\t" + origURI);
            System.out.println("\tMalformedURLException");
            return false;
        }
        catch (IOException ioe) {
            System.out.println(uri + ":");
            System.out.println("\t" + origURI);
            System.out.println("\tIOException");
            return false;
        }
        if (lastModified == 0L) {
            System.out.println(uri + ":");
            System.out.println("\t" + origURI);
            System.out.println("\tUnknown: no last-modified header");
            return false;
        }
        if (lastModified > cacheTime) {
            System.out.println(uri + ":");
            System.out.println("\t" + origURI);
            System.out.println("\tExpired");
            return true;
        }
        return false;
    }
}

