/*
 * Decompiled with CFR 0.152.
 */
package org.xmlresolver.apps;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xmlresolver.Catalog;
import org.xmlresolver.Resolver;
import org.xmlresolver.helpers.FileURI;
import org.xmlresolver.tools.ResolvingXMLReader;

public class Parse {
    private static Logger logger = LoggerFactory.getLogger(Parse.class);
    private static final String SCHEMA_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/schema";
    private static final String SCHEMA_FULL_CHECKING_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";
    private static final String EXTERNAL_SCHEMA_LOCATION_PROPERTY_ID = "http://apache.org/xml/properties/schema/external-schemaLocation";
    private static final String EXTERNAL_NONS_SCHEMA_LOCATION_PROPERTY_ID = "http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation";

    public static void main(String[] args) throws FileNotFoundException, IOException {
        Parse parse = new Parse();
        if (!parse.run(args)) {
            System.exit(1);
        }
    }

    public boolean run(String[] args) {
        String xmlfile = null;
        int maxErrs = 10;
        boolean validating = true;
        boolean useSchema = false;
        Vector<String> xsdFiles = new Vector<String>();
        Vector<String> catalogFiles = new Vector<String>();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-c")) {
                catalogFiles.add(args[++i]);
                continue;
            }
            if (args[i].equals("-w")) {
                validating = false;
                continue;
            }
            if (args[i].equals("-s")) {
                useSchema = true;
                continue;
            }
            if (args[i].equals("-S")) {
                xsdFiles.add(args[++i]);
                useSchema = true;
                continue;
            }
            xmlfile = args[i];
        }
        if (xmlfile == null) {
            System.out.println("Usage: org.xmlresolver.apps.Parse [opts] xmlfile");
            System.out.println("");
            System.out.println("Where:");
            System.out.println("");
            System.out.println("-c catalogfile   Load a particular catalog file");
            System.out.println("-w               Perform a well-formed parse, not a validating parse");
            System.out.println("-s               Enable W3C XML Schema validation");
            System.out.println("-S schema.xsd    Use schema.xsd for validation (implies -s)");
            System.out.println("");
            System.out.println("The process ends with error-level 1, if there are errors.");
            return false;
        }
        Hashtable schemaList = Parse.lookupSchemas(xsdFiles);
        StringBuilder catalogList = new StringBuilder();
        for (int count = 0; count < catalogFiles.size(); ++count) {
            String file = (String)catalogFiles.elementAt(count);
            if (count > 0) {
                catalogList.append(";");
            }
            catalogList.append(file);
        }
        Catalog catalog = null;
        catalog = catalogFiles.isEmpty() ? new Catalog() : new Catalog(catalogList.toString());
        Resolver resolver = new Resolver(catalog);
        ResolvingXMLReader reader = new ResolvingXMLReader(resolver);
        try {
            reader.setFeature("http://xml.org/sax/features/namespaces", true);
            reader.setFeature("http://xml.org/sax/features/validation", validating);
            if (useSchema) {
                reader.setFeature(SCHEMA_VALIDATION_FEATURE_ID, useSchema);
                reader.setFeature(SCHEMA_FULL_CHECKING_FEATURE_ID, false);
                if (schemaList != null) {
                    String slh = "";
                    String nons_slh = "";
                    Enumeration nskey = schemaList.keys();
                    while (nskey.hasMoreElements()) {
                        String ns = (String)nskey.nextElement();
                        String xsd = (String)schemaList.get(ns);
                        if ("".equals(ns)) {
                            nons_slh = xsd;
                            logger.trace("Hint: ''=" + xsd);
                            continue;
                        }
                        if (!"".equals(slh)) {
                            slh = slh + " ";
                        }
                        slh = slh + ns + " " + xsd;
                        logger.trace("Hint: " + ns + "=" + xsd);
                    }
                    if (!"".equals(slh)) {
                        reader.setProperty(EXTERNAL_SCHEMA_LOCATION_PROPERTY_ID, (Object)slh);
                    }
                    if (!"".equals(nons_slh)) {
                        reader.setProperty(EXTERNAL_NONS_SCHEMA_LOCATION_PROPERTY_ID, (Object)nons_slh);
                    }
                }
            }
        }
        catch (SAXException slh) {
            // empty catch block
        }
        XParseError xpe = new XParseError();
        xpe.setMaxMessages(maxErrs);
        reader.setErrorHandler((ErrorHandler)xpe);
        boolean pass = true;
        try {
            String parseType = validating ? "validating" : "well-formed";
            String nsType = "namespace-aware";
            System.out.println("Attempting " + parseType + ", " + nsType + " parse");
            reader.parse(xmlfile);
        }
        catch (Exception e) {
            System.out.println(e.toString());
            pass = false;
        }
        System.out.print("Parse ");
        if (!pass || xpe.getFatalCount() > 0) {
            System.out.print("failed ");
            pass = false;
        } else {
            System.out.print("succeeded ");
        }
        System.out.print("with ");
        int errCount = xpe.getErrorCount();
        int warnCount = xpe.getWarningCount();
        if (errCount > 0) {
            System.out.print(errCount + " error");
            System.out.print(errCount > 1 ? "s" : "");
            System.out.print(" and ");
        } else {
            System.out.print("no errors and ");
        }
        if (warnCount > 0) {
            System.out.print(warnCount + " warning");
            System.out.print(warnCount > 1 ? "s" : "");
            System.out.print(".");
        } else {
            System.out.print("no warnings.");
        }
        System.out.println("");
        return pass;
    }

    private static Hashtable lookupSchemas(Vector xsdFiles) {
        Hashtable<String, String> mapping = new Hashtable<String, String>();
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setIgnoringComments(true);
            dbf.setNamespaceAware(true);
            dbf.setValidating(false);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Enumeration xsdenum = xsdFiles.elements();
            while (xsdenum.hasMoreElements()) {
                String xsd = (String)xsdenum.nextElement();
                Document doc = db.parse(xsd = xsd.replaceAll(" ", "%20"));
                Element s = doc.getDocumentElement();
                String targetNS = s.getAttribute("targetNamespace");
                if (targetNS == null || "".equals(targetNS)) {
                    mapping.put("", xsd);
                    continue;
                }
                mapping.put(targetNS, xsd);
            }
        }
        catch (IOException | ParserConfigurationException | SAXException pce) {
            pce.printStackTrace();
        }
        return mapping;
    }

    class XParseError
    implements ErrorHandler {
        private boolean showErrors = true;
        private boolean showWarnings = true;
        private int maxMessages = 10;
        private int fatalCount = 0;
        private int errorCount = 0;
        private int warningCount = 0;
        private String baseURI = "";

        public XParseError() {
            try {
                URI uri = FileURI.makeURI((String)"basename");
                this.baseURI = uri.toURL().toString();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }

        public int getErrorCount() {
            return this.errorCount;
        }

        public int getFatalCount() {
            return this.fatalCount;
        }

        public int getWarningCount() {
            return this.warningCount;
        }

        public int getMaxMessages() {
            return this.maxMessages;
        }

        public void setMaxMessages(int max) {
            this.maxMessages = max;
        }

        @Override
        public void error(SAXParseException exception) {
            ++this.errorCount;
            if (this.showErrors && this.errorCount + this.warningCount < this.maxMessages) {
                this.message("Error", exception);
            }
        }

        @Override
        public void fatalError(SAXParseException exception) {
            ++this.errorCount;
            ++this.fatalCount;
            if (this.showErrors && this.errorCount + this.warningCount < this.maxMessages) {
                this.message("Fatal error", exception);
            }
        }

        @Override
        public void warning(SAXParseException exception) {
            ++this.warningCount;
            if (this.showWarnings && this.errorCount + this.warningCount < this.maxMessages) {
                this.message("Warning", exception);
            }
        }

        private void message(String type, SAXParseException exception) {
            String filename = exception.getSystemId();
            if (filename.startsWith(this.baseURI)) {
                filename = filename.substring(this.baseURI.length());
            }
            System.out.print(type + ":" + filename + ":" + exception.getLineNumber());
            if (exception.getColumnNumber() > 0) {
                System.out.print(":" + exception.getColumnNumber());
            }
            System.out.println(":" + exception.getMessage());
        }
    }
}

