/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.assertj3;

import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xmlunit.assertj3.ExpectedException;
import org.xmlunit.assertj3.XmlAssert;
import org.xmlunit.diff.Comparison;
import org.xmlunit.diff.ComparisonFormatter;
import org.xmlunit.diff.ComparisonResult;
import org.xmlunit.diff.ComparisonType;
import org.xmlunit.diff.DefaultNodeMatcher;
import org.xmlunit.diff.DifferenceEvaluator;
import org.xmlunit.diff.DifferenceEvaluators;
import org.xmlunit.diff.ElementSelector;
import org.xmlunit.diff.ElementSelectors;
import org.xmlunit.diff.NodeMatcher;
import org.xmlunit.util.Predicate;

public class CompareAssertAreIdenticalTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testAreIdentical_withSameAttributesOrder_shouldPass() {
        String testXml = "<Element attr1=\"12\" attr2=\"xy\"/>";
        String controlXml = "<Element attr1=\"12\" attr2=\"xy\"/>";
        XmlAssert.assertThat((Object)testXml).and((Object)controlXml).areIdentical();
    }

    @Test
    public void testAreIdentical_withDifferentAttributesOrder_shouldPass() {
        String testXml = "<Element attr2=\"xy\" attr1=\"12\"/>";
        String controlXml = "<Element attr1=\"12\" attr2=\"xy\"/>";
        XmlAssert.assertThat((Object)testXml).and((Object)controlXml).areIdentical();
    }

    @Test
    public void testAreIdentical_shouldFail() {
        this.thrown.expectAssertionError("Expecting:%n <control instance> and <test instance> to be identical");
        this.thrown.expectAssertionError("Expected node type 'CDATA Section' but was 'Text'");
        String testXml = "<!DOCTYPE a><a xmlns:xyz=\"https://www.xmlunit.com/xyz\">   <b>text</b>   <c>      <d/>      <xyz:e/>   </c></a>";
        String controlXml = "<a xmlns:vwy=\"https://www.xmlunit.com/xyz\">   <b><![CDATA[text]]></b>   <c>      <d/>      <vwy:e/>   </c></a>";
        XmlAssert.assertThat((Object)testXml).and((Object)controlXml).areIdentical();
    }

    @Test
    public void testAreIdentical_shouldUseCustomFailMessage() {
        this.thrown.expectAssertionError("Alarm alarm!");
        String testXml = "<!DOCTYPE a><a xmlns:xyz=\"https://www.xmlunit.com/xyz\">   <b>text</b>   <c>      <d/>      <xyz:e/>   </c></a>";
        String controlXml = "<a xmlns:vwy=\"https://www.xmlunit.com/xyz\">   <b><![CDATA[text]]></b>   <c>      <d/>      <vwy:e/>   </c></a>";
        ((XmlAssert)XmlAssert.assertThat((Object)testXml).withFailMessage("Alarm alarm!", new Object[0])).and((Object)controlXml).areIdentical();
    }

    @Test
    public void testAreIdentical_shouldFailed_withReadableMessage() {
        this.thrown.expectAssertionError("Expecting:%n <control instance> and <test instance> to be identical");
        this.thrown.expectAssertionError("Expected attribute value 'xy' but was 'xyz'");
        this.thrown.expectAssertionError("at /Element[1]/@attr2");
        this.thrown.expectAssertionError("attr2=\"xyz\"");
        String testXml = "<Element attr2=\"xyz\" attr1=\"12\"/>";
        String controlXml = "<Element attr1=\"12\" attr2=\"xy\"/>";
        XmlAssert.assertThat((Object)testXml).and((Object)controlXml).areIdentical();
    }

    @Test
    public void testAreIdentical_shouldFailed_withElementOrderMessage() {
        this.thrown.expectAssertionError("Expecting:%n <control instance> and <test instance> to be identical");
        this.thrown.expectAssertionError("Expected child nodelist sequence '0' but was '1'");
        this.thrown.expectAssertionError("comparing <b...> at /a[1]/b[1] to <b...> at /a[1]/b[1]");
        String testXml = "<a><c/><b/></a>";
        String controlXml = "<a><b/><c/></a>";
        XmlAssert.assertThat((Object)testXml).and((Object)controlXml).withNodeMatcher((NodeMatcher)new DefaultNodeMatcher(new ElementSelector[]{ElementSelectors.byNameAndText})).areIdentical();
    }

    @Test
    public void testAreIdentical_withWhitespaces_shouldFailed() {
        this.thrown.expectAssertionError("Expecting:%n <control instance> and <test instance> to be identical");
        this.thrown.expectAssertionError("Expected child nodelist length '1' but was '3'");
        this.thrown.expectAssertionError("expected:<<a><b/></a>> but was:<<a>%n <b/>%n</a>>");
        String testXml = String.format("<a>%n <b/>%n</a>", new Object[0]);
        String controlXml = "<a><b/></a>";
        XmlAssert.assertThat((Object)testXml).and((Object)controlXml).areIdentical();
    }

    @Test
    public void testAreIdentical_withIgnoreWhitespacees_shouldPass() {
        String testXml = String.format("<a>%n <b/>%n</a>", new Object[0]);
        String controlXml = "<a><b/></a>";
        XmlAssert.assertThat((Object)testXml).and((Object)controlXml).ignoreWhitespace().areIdentical();
    }

    @Test
    public void testAreIdentical_withIgnoreWhitespaceAndTextValue_shouldPass() {
        String testXml = String.format("<a>%nX <b/>%n</a>", new Object[0]);
        String controlXml = "<a>X<b/></a>";
        XmlAssert.assertThat((Object)testXml).and((Object)controlXml).ignoreWhitespace().areIdentical();
    }

    @Test
    public void testAreIdentical_withIgnoreElementContentWhitespace_shouldFailed() {
        this.thrown.expectAssertionError("Expecting:%n <control instance> and <test instance> to be identical");
        this.thrown.expectAssertionError("Expected text value 'x' but was '\nx '");
        String testXml = String.format("<a>%nx <b/>%n</a>", new Object[0]);
        String controlXml = "<a>x<b/></a>";
        XmlAssert.assertThat((Object)testXml).and((Object)controlXml).ignoreElementContentWhitespace().areIdentical();
    }

    @Test
    public void testAreIdentical_withIgnoreComments_shouldPass() {
        String testXml = "<a><!-- test --></a>";
        String controlXml = "<a></a>";
        XmlAssert.assertThat((Object)testXml).and((Object)controlXml).ignoreComments().areIdentical();
    }

    @Test
    public void testAreIdentical_withIgnoreComments_1_0_shouldPass() {
        String testXml = "<a><!-- test --></a>";
        String controlXml = "<a></a>";
        XmlAssert.assertThat((Object)testXml).and((Object)controlXml).ignoreCommentsUsingXSLTVersion("1.0").areIdentical();
    }

    @Test
    public void testAreIdentical_withIgnoreComments_2_0_shouldPass() {
        String testXml = "<a><!-- test --></a>";
        String controlXml = "<a></a>";
        XmlAssert.assertThat((Object)testXml).and((Object)controlXml).ignoreCommentsUsingXSLTVersion("2.0").areIdentical();
    }

    @Test
    public void testAreIdentical_withNormalizeWhitespace_shouldPass() {
        String testXml = String.format("<a>%n  <b>%n  Test%n  Node%n  </b>%n</a>", new Object[0]);
        String controlXml = "<a><b>Test Node</b></a>";
        XmlAssert.assertThat((Object)testXml).and((Object)controlXml).normalizeWhitespace().areIdentical();
    }

    @Test
    public void testAreIdentical_withNormalizeWhitespace_shouldFailed() {
        this.thrown.expectAssertionError("Expecting:%n <control instance> and <test instance> to be identical");
        this.thrown.expectAssertionError("Expected text value 'TestNode' but was 'Test Node'");
        String testXml = String.format("<a>%n  <b>%n  Test%n  Node%n  </b>%n</a>", new Object[0]);
        String controlXml = "<a><b>TestNode</b></a>";
        XmlAssert.assertThat((Object)testXml).and((Object)controlXml).normalizeWhitespace().areIdentical();
    }

    @Test
    public void testAreIdentical_withInvalidTestXml_shouldFailed() {
        this.thrown.expectAssertionErrorPattern(".*Expecting code not to raise a throwable but caught.*Caught exception during comparison.*");
        String testXml = "abc";
        String controlXml = "<a><b/><c/></a>";
        XmlAssert.assertThat((Object)testXml).and((Object)controlXml).areIdentical();
    }

    @Test
    public void testAreIdentical_withInvalidControlXml_shouldFailed() {
        this.thrown.expectAssertionErrorPattern(".*Expecting code not to raise a throwable but caught.*Caught exception during comparison.*");
        String testXml = "<a><b/><c/></a>";
        String controlXml = "abc";
        XmlAssert.assertThat((Object)testXml).and((Object)controlXml).areIdentical();
    }

    @Test
    public void testAreIdentical_withDifferenceEvaluator_shouldPass() {
        String testXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><feed>   <title>title</title>   <entry>       <title>title1</title>       <id>id1</id>   </entry></feed>";
        String controlXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><feed>   <title>title</title>   <entry>       <description>description</description>       <uuid>uuid1</uuid>   </entry></feed>";
        XmlAssert.assertThat((Object)testXml).and((Object)controlXml).withDifferenceEvaluator(DifferenceEvaluators.chain((DifferenceEvaluator[])new DifferenceEvaluator[]{DifferenceEvaluators.Default, new IgnoreNodeEvaluator("entry")})).areIdentical();
    }

    @Test
    public void testAreIdentical_withAttributeFilter_shouldPass() {
        String testXml = "<Element attr2=\"xyz\" attr1=\"12\"/>";
        String controlXml = "<Element attr1=\"12\" attr2=\"xy\"/>";
        XmlAssert.assertThat((Object)testXml).and((Object)controlXml).withAttributeFilter((Predicate)new AttributeFilter("attr2")).areIdentical();
    }

    @Test
    public void testAreIdentical_withNodeFilter_shouldPass() {
        String testXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><feed>   <title>title</title>   <entry>       <title>title1</title>       <id>id1</id>   </entry></feed>";
        String controlXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><feed>   <title>title</title>   <entry>       <description>description</description>       <uuid>uuid1</uuid>   </entry></feed>";
        XmlAssert.assertThat((Object)testXml).and((Object)controlXml).withNodeFilter((Predicate)new NodeFilter("entry")).areIdentical();
    }

    @Test
    public void testAreIdentical_withComparisonFormatter_shouldFailed() {
        this.thrown.expectAssertionError("Expecting:%n <control instance> and <test instance> to be identical");
        this.thrown.expectAssertionError("foo");
        this.thrown.expectAssertionErrorPattern(".*bar.*bar.*");
        String testXml = "<a><c/><b/></a>";
        String controlXml = "<a><b/><c/></a>";
        XmlAssert.assertThat((Object)testXml).and((Object)controlXml).withComparisonFormatter((ComparisonFormatter)new DummyFormatter()).withNodeMatcher((NodeMatcher)new DefaultNodeMatcher(new ElementSelector[]{ElementSelectors.byNameAndText})).areIdentical();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void usesDocumentBuilderFactorySpecifiedOnXmlAssert() throws Exception {
        this.thrown.expectAssertionError("Expecting code not to raise a throwable but caught");
        this.thrown.expectAssertionError("org.xmlunit.XMLUnitException: Caught exception during comparison");
        this.thrown.expectAssertionError("java.io.IOException");
        DocumentBuilderFactory dFac = (DocumentBuilderFactory)Mockito.mock(DocumentBuilderFactory.class);
        DocumentBuilder b = (DocumentBuilder)Mockito.mock(DocumentBuilder.class);
        Mockito.when((Object)dFac.newDocumentBuilder()).thenReturn((Object)b);
        ((DocumentBuilder)Mockito.doThrow((Throwable[])new Throwable[]{new IOException()}).when((Object)b)).parse((InputSource)Mockito.any(InputSource.class));
        String control = "<a><b></b><c/></a>";
        try {
            XmlAssert.assertThat((Object)control).withDocumentBuilderFactory(dFac).and((Object)control).areIdentical();
        }
        finally {
            ((DocumentBuilder)Mockito.verify((Object)b)).parse((InputSource)Mockito.any(InputSource.class));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void usesDocumentBuilderFactorySpecifiedCompareXmlAssert() throws Exception {
        this.thrown.expectAssertionError("Expecting code not to raise a throwable but caught");
        this.thrown.expectAssertionError("org.xmlunit.XMLUnitException: Caught exception during comparison");
        this.thrown.expectAssertionError("java.io.IOException");
        DocumentBuilderFactory dFac = (DocumentBuilderFactory)Mockito.mock(DocumentBuilderFactory.class);
        DocumentBuilder b = (DocumentBuilder)Mockito.mock(DocumentBuilder.class);
        Mockito.when((Object)dFac.newDocumentBuilder()).thenReturn((Object)b);
        ((DocumentBuilder)Mockito.doThrow((Throwable[])new Throwable[]{new IOException()}).when((Object)b)).parse((InputSource)Mockito.any(InputSource.class));
        String control = "<a><b></b><c/></a>";
        try {
            XmlAssert.assertThat((Object)control).and((Object)control).withDocumentBuilderFactory(dFac).areIdentical();
        }
        finally {
            ((DocumentBuilder)Mockito.verify((Object)b)).parse((InputSource)Mockito.any(InputSource.class));
        }
    }

    @Test
    public void testAreIdentical_withIgnoreChildNodesOrder_shouldPass() {
        String testXml = "<a>   <c><d/><e/></c>   <b>text</b></a>";
        String controlXml = "<a>   <b>text</b>   <c><e/><d/></c></a>";
        XmlAssert.assertThat((Object)testXml).and((Object)controlXml).ignoreChildNodesOrder().areIdentical();
    }

    private final class IgnoreNodeEvaluator
    implements DifferenceEvaluator {
        private final String nodeName;

        public IgnoreNodeEvaluator(String nodeName) {
            this.nodeName = nodeName;
        }

        public ComparisonResult evaluate(Comparison comparison, ComparisonResult outcome) {
            Node controlNode = comparison.getControlDetails().getTarget();
            do {
                Element elem;
                if (!(controlNode instanceof Element) || !(elem = (Element)controlNode).getTagName().equals(this.nodeName)) continue;
                return ComparisonResult.EQUAL;
            } while ((controlNode = controlNode.getParentNode()) != null);
            return outcome;
        }
    }

    private final class AttributeFilter
    implements Predicate<Attr> {
        private final String attrName;

        private AttributeFilter(String attrName) {
            this.attrName = attrName;
        }

        public boolean test(Attr toTest) {
            return !this.attrName.equalsIgnoreCase(toTest.getName());
        }
    }

    private final class NodeFilter
    implements Predicate<Node> {
        private final String nodeName;

        private NodeFilter(String nodeName) {
            this.nodeName = nodeName;
        }

        public boolean test(Node toTest) {
            if (toTest instanceof Element) {
                return !this.nodeName.equalsIgnoreCase(((Element)toTest).getTagName());
            }
            return true;
        }
    }

    private static final class DummyFormatter
    implements ComparisonFormatter {
        private DummyFormatter() {
        }

        public String getDescription(Comparison difference) {
            return "foo";
        }

        public String getDetails(Comparison.Detail details, ComparisonType type, boolean formatXml) {
            return "bar";
        }
    }
}

