/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.assertj3;

import org.junit.Rule;
import org.junit.Test;
import org.xmlunit.assertj3.ExpectedException;
import org.xmlunit.assertj3.XmlAssert;
import org.xmlunit.diff.Comparison;
import org.xmlunit.diff.ComparisonListener;
import org.xmlunit.diff.ComparisonResult;
import org.xmlunit.diff.DefaultNodeMatcher;
import org.xmlunit.diff.ElementSelector;
import org.xmlunit.diff.ElementSelectors;
import org.xmlunit.diff.NodeMatcher;

public class CompareAssertAreNotIdenticalTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testAreNotIdentical_withSameAttributesOrder_shouldFailed() {
        this.thrown.expectAssertionError("Expecting:%n <control instance> and <test instance> to be not identical");
        String testXml = "<Element attr1=\"12\" attr2=\"xy\"/>";
        String controlXml = "<Element attr1=\"12\" attr2=\"xy\"/>";
        XmlAssert.assertThat((Object)testXml).and((Object)controlXml).areNotIdentical();
    }

    @Test
    public void testAreNotIdentical_withDifferentAttributesOrder_shouldFailed() {
        this.thrown.expectAssertionError("Expecting:%n <control instance> and <test instance> to be not identical");
        String testXml = "<Element attr2=\"xy\" attr1=\"12\"/>";
        String controlXml = "<Element attr1=\"12\" attr2=\"xy\"/>";
        XmlAssert.assertThat((Object)testXml).and((Object)controlXml).areNotIdentical();
    }

    @Test
    public void testAreNotIdentical_withCDataInsteadText_shouldPass() {
        String testXml = "<!DOCTYPE a><a xmlns:xyz=\"https://www.xmlunit.com/xyz\">   <b>text</b>   <c>      <d/>      <xyz:e/>   </c></a>";
        String controlXml = "<a xmlns:vwy=\"https://www.xmlunit.com/xyz\">   <b><![CDATA[text]]></b>   <c>      <d/>      <vwy:e/>   </c></a>";
        XmlAssert.assertThat((Object)testXml).and((Object)controlXml).areNotIdentical();
    }

    @Test
    public void testAreNotIdentical_withAttributeDifferentValues_shouldPass() {
        String testXml = "<Element attr1=\"12\" attr2=\"xyz\"/>";
        String controlXml = "<Element attr1=\"12\" attr2=\"xy\"/>";
        XmlAssert.assertThat((Object)testXml).and((Object)controlXml).areNotIdentical();
    }

    @Test
    public void testAreNotIdentical_withDifferentElementOrder_shouldPass() {
        String testXml = "<a><c/><b/></a>";
        String controlXml = "<a><b/><c/></a>";
        XmlAssert.assertThat((Object)testXml).and((Object)controlXml).withNodeMatcher((NodeMatcher)new DefaultNodeMatcher(new ElementSelector[]{ElementSelectors.byNameAndText})).areNotIdentical();
    }

    @Test
    public void testAreNotIdentical_withWhitespaces_shouldPass() {
        String testXml = String.format("<a>%n <b/>%n</a>", new Object[0]);
        String controlXml = "<a><b/></a>";
        XmlAssert.assertThat((Object)testXml).and((Object)controlXml).areNotIdentical();
    }

    @Test
    public void testAreNotIdentical_withIgnoreWhitespaces_shouldFailed() {
        this.thrown.expectAssertionError("Expecting:%n <control instance> and <test instance> to be not identical");
        String testXml = String.format("<a>%n <b/>%n</a>", new Object[0]);
        String controlXml = "<a><b/></a>";
        XmlAssert.assertThat((Object)testXml).and((Object)controlXml).ignoreWhitespace().areNotIdentical();
    }

    @Test
    public void testAreNotIdentical_withIgnoreWhitespaceAndTextValue_shouldFailed() {
        this.thrown.expectAssertionError("Expecting:%n <control instance> and <test instance> to be not identical");
        String testXml = String.format("<a>%nX <b/>%n</a>", new Object[0]);
        String controlXml = "<a>X<b/></a>";
        XmlAssert.assertThat((Object)testXml).and((Object)controlXml).ignoreWhitespace().areNotIdentical();
    }

    @Test
    public void testAreNotIdentical_withIgnoreElementContentWhitespace_shouldPass() {
        String testXml = String.format("<a>%nx <b/>%n</a>", new Object[0]);
        String controlXml = "<a>x<b/></a>";
        XmlAssert.assertThat((Object)testXml).and((Object)controlXml).ignoreElementContentWhitespace().areNotIdentical();
    }

    @Test
    public void testAreNotIdentical_withIgnoreComments_shouldFailed() {
        this.thrown.expectAssertionError("Expecting:%n <control instance> and <test instance> to be not identical");
        String testXml = "<a><!-- test --></a>";
        String controlXml = "<a></a>";
        XmlAssert.assertThat((Object)testXml).and((Object)controlXml).ignoreComments().areNotIdentical();
    }

    @Test
    public void testAreNotIdentical_withNormalizeWhitespace_shouldFailed() {
        this.thrown.expectAssertionError("Expecting:%n <control instance> and <test instance> to be not identical");
        String testXml = String.format("<a>%n  <b>%n  Test%n  Node%n  </b>%n</a>", new Object[0]);
        String controlXml = "<a><b>Test Node</b></a>";
        XmlAssert.assertThat((Object)testXml).and((Object)controlXml).normalizeWhitespace().areNotIdentical();
    }

    @Test
    public void testAreNotIdentical_withNormalizeWhitespace_shouldPass() {
        String testXml = String.format("<a>%n  <b>%n  Test%n  Node%n  </b>%n</a>", new Object[0]);
        String controlXml = "<a><b>TestNode</b></a>";
        XmlAssert.assertThat((Object)testXml).and((Object)controlXml).normalizeWhitespace().areNotIdentical();
    }

    @Test
    public void testAreNotIdentical_withInvalidTestXml_shouldFailed() {
        this.thrown.expectAssertionErrorPattern(".*Expecting code not to raise a throwable but caught.*Caught exception during comparison.*");
        String testXml = "abc";
        String controlXml = "<a><b/><c/></a>";
        XmlAssert.assertThat((Object)testXml).and((Object)controlXml).areNotIdentical();
    }

    @Test
    public void testAreNotIdentical_withInvalidControlXml_shouldFailed() {
        this.thrown.expectAssertionErrorPattern(".*Expecting code not to raise a throwable but caught.*Caught exception during comparison.*");
        String testXml = "<a><b/><c/></a>";
        String controlXml = "abc";
        XmlAssert.assertThat((Object)testXml).and((Object)controlXml).areNotIdentical();
    }

    @Test
    public void areNotIdentical_withDifferenceListener_shouldCollectChanges() {
        DifferenceComparisonListener differenceListener = new DifferenceComparisonListener();
        String testXml = "<Element attr1=\"12\" attr2=\"xyz\"/>";
        String controlXml = "<Element attr1=\"12\" attr2=\"xy\"/>";
        XmlAssert.assertThat((Object)testXml).and((Object)controlXml).withDifferenceListeners(new ComparisonListener[]{differenceListener}).areNotIdentical();
        XmlAssert.assertThat((Object)differenceListener.difference).isEqualTo((Object)1);
    }

    @Test
    public void areNotIdentical_withIgnoreChildNodesOrder_shouldFailed() {
        this.thrown.expectAssertionError("Expecting:%n <control instance> and <test instance> to be not identical");
        String testXml = "<a>   <c><d/><e/></c>   <b>text</b></a>";
        String controlXml = "<a>   <b>text</b>   <c><e/><d/></c></a>";
        XmlAssert.assertThat((Object)testXml).and((Object)controlXml).ignoreChildNodesOrder().areNotIdentical();
    }

    private final class DifferenceComparisonListener
    implements ComparisonListener {
        private int difference;

        private DifferenceComparisonListener() {
        }

        public void comparisonPerformed(Comparison comparison, ComparisonResult outcome) {
            switch (outcome) {
                case DIFFERENT: {
                    ++this.difference;
                }
            }
        }
    }
}

