/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.assertj3;

import java.io.File;
import org.junit.Rule;
import org.junit.Test;
import org.xmlunit.assertj3.ExpectedException;
import org.xmlunit.assertj3.XmlAssert;

public class CompareAssertAreNotSimilarTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testAreNotSimilar_shouldPass() {
        String testXml = "<a><c/><b/></a>";
        String controlXml = "<a><b/><c/></a>";
        XmlAssert.assertThat((Object)testXml).and((Object)controlXml).areNotSimilar();
    }

    @Test
    public void testAreNotSimilar_fromFiles_shouldPass() {
        File testXml = new File("../test-resources/test1.xml");
        File controlXml = new File("../test-resources/test2.xml");
        XmlAssert.assertThat((Object)testXml).and((Object)controlXml).areNotSimilar();
    }

    @Test
    public void testAreNotSimilar_withIdenticalXmls_shouldFailed() {
        this.thrown.expectAssertionError("Expecting:%n <control instance> and <test instance> to be not similar");
        String testXml = "<Element attr1=\"12\" attr2=\"xy\"/>";
        String controlXml = "<Element attr1=\"12\" attr2=\"xy\"/>";
        XmlAssert.assertThat((Object)testXml).and((Object)controlXml).areNotSimilar();
    }

    @Test
    public void testAreNotSimilar_withSimilarXmls_shouldFailed() {
        this.thrown.expectAssertionError("Expecting:%n <control instance> and <test instance> to be not similar");
        String testXml = "<!DOCTYPE a><a xmlns:xyz=\"https://www.xmlunit.com/xyz\">   <b>text</b>   <c>      <d/>      <xyz:e/>   </c></a>";
        String controlXml = "<a xmlns:vwy=\"https://www.xmlunit.com/xyz\">   <b><![CDATA[text]]></b>   <c>      <d/>      <vwy:e/>   </c></a>";
        XmlAssert.assertThat((Object)testXml).and((Object)controlXml).areNotSimilar();
    }

    @Test
    public void testAreNotSimilar_withSimilarXmlsIgnoreChildNodesOrder_shouldFailed() {
        this.thrown.expectAssertionError("Expecting:%n <control instance> and <test instance> to be not similar");
        String testXml = "<!DOCTYPE a><a>   <c><d/><e/></c>   <b>text</b></a>";
        String controlXml = "<a>   <b><![CDATA[text]]></b>   <c><e/><d/></c></a>";
        XmlAssert.assertThat((Object)testXml).and((Object)controlXml).ignoreChildNodesOrder().areNotSimilar();
    }

    @Test
    public void testAreNotSimilar_withIgnoreComments_shouldFailed() {
        this.thrown.expectAssertionError("Expecting:%n <control instance> and <test instance> to be not similar");
        String testXml = "<a><!-- test --></a>";
        String controlXml = "<a></a>";
        XmlAssert.assertThat((Object)testXml).and((Object)controlXml).ignoreComments().areNotSimilar();
    }

    @Test
    public void testAreNotSimilar_withInvalidTestXml_shouldFailed() {
        this.thrown.expectAssertionErrorPattern(".*Expecting code not to raise a throwable but caught.*Caught exception during comparison.*");
        String testXml = "abc";
        String controlXml = "<a><b/><c/></a>";
        XmlAssert.assertThat((Object)testXml).and((Object)controlXml).areNotSimilar();
    }

    @Test
    public void testAreNotSimilar_withInvalidControlXml_shouldFailed() {
        this.thrown.expectAssertionErrorPattern(".*Expecting code not to raise a throwable but caught.*Caught exception during comparison.*");
        String testXml = "<a><b/><c/></a>";
        String controlXml = "abc";
        XmlAssert.assertThat((Object)testXml).and((Object)controlXml).areNotSimilar();
    }
}

