/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.assertj3;

import java.io.File;
import org.junit.Rule;
import org.junit.Test;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmlunit.assertj3.ExpectedException;
import org.xmlunit.assertj3.XmlAssert;
import org.xmlunit.diff.Comparison;
import org.xmlunit.diff.ComparisonController;
import org.xmlunit.diff.ComparisonListener;
import org.xmlunit.diff.ComparisonResult;
import org.xmlunit.diff.ComparisonType;
import org.xmlunit.diff.Difference;
import org.xmlunit.diff.DifferenceEvaluator;
import org.xmlunit.diff.DifferenceEvaluators;

public class CompareAssertAreSimilarTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testAreSimilar_shouldPass() {
        String testXml = "<!DOCTYPE a><a xmlns:xyz=\"https://www.xmlunit.com/xyz\">   <b>text</b>   <c>      <d/>      <xyz:e/>   </c></a>";
        String controlXml = "<a xmlns:vwy=\"https://www.xmlunit.com/xyz\">   <b><![CDATA[text]]></b>   <c>      <d/>      <vwy:e/>   </c></a>";
        XmlAssert.assertThat((Object)testXml).and((Object)controlXml).areSimilar();
    }

    @Test
    public void testAreSimilar_withIgnoreChildNodesOrder_shouldPass() {
        String testXml = "<!DOCTYPE a><a>   <c><d/><e/></c>   <b>text</b></a>";
        String controlXml = "<a>   <b><![CDATA[text]]></b>   <c><e/><d/></c></a>";
        XmlAssert.assertThat((Object)testXml).and((Object)controlXml).ignoreChildNodesOrder().areSimilar();
    }

    @Test
    public void testAreSimilar_fromFiles_shouldFailed() {
        this.thrown.expectAssertionErrorPattern(".*Expecting:.*<(?:.*test2\\.xml)> and <(?:.*test1\\.xml)> to be similar.*");
        this.thrown.expectAssertionError("Expected processing instruction data 'href=\"animal.xsl\" type=\"text/xsl\"' but was 'type=\"text/xsl\" href=\"animal.xsl\"");
        File testXml = new File("../test-resources/test1.xml");
        File controlXml = new File("../test-resources/test2.xml");
        XmlAssert.assertThat((Object)testXml).and((Object)controlXml).areSimilar();
    }

    @Test
    public void testAreSimilar_withInvalidTestXml_shouldFailed() {
        this.thrown.expectAssertionErrorPattern(".*Expecting code not to raise a throwable but caught.*Caught exception during comparison.*");
        String testXml = "abc";
        String controlXml = "<a><b/><c/></a>";
        XmlAssert.assertThat((Object)testXml).and((Object)controlXml).areSimilar();
    }

    @Test
    public void testAreSimilar_withInvalidControlXml_shouldFailed() {
        this.thrown.expectAssertionErrorPattern(".*Expecting code not to raise a throwable but caught.*Caught exception during comparison.*");
        String testXml = "<a><b/><c/></a>";
        String controlXml = "abc";
        XmlAssert.assertThat((Object)testXml).and((Object)controlXml).areSimilar();
    }

    @Test
    public void testAreSimilar_withDifferenceEvaluator_shouldPass() {
        String testXml = "<a><b attr=\"abc\"></b></a>";
        String controlXml = "<a><b attr=\"xyz\"></b></a>";
        XmlAssert.assertThat((Object)testXml).and((Object)controlXml).withDifferenceEvaluator(DifferenceEvaluators.chain((DifferenceEvaluator[])new DifferenceEvaluator[]{DifferenceEvaluators.Default, new IgnoreAttributeValueEvaluator("attr")})).areSimilar();
    }

    @Test
    public void testAreSimilar_withComparisonController_shouldPass() {
        String testXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><feed>   <title>title</title>   <entry>       <title>title1</title>       <id>id1</id>   </entry></feed>";
        String controlXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><feed>   <title>title</title>   <invalidEntry>       <description>description</description>       <uuid>uuid1</uuid>   </invalidEntry></feed>";
        XmlAssert.assertThat((Object)testXml).and((Object)controlXml).withDifferenceEvaluator((DifferenceEvaluator)new IgnoreEntryEvaluator()).withComparisonController((ComparisonController)new StopAfterNode("invalidEntry")).areSimilar();
    }

    @Test
    public void testAreSimilar_withComparisonListeners_shouldPass() {
        SimilarityComparisonListener comparisonListener = new SimilarityComparisonListener();
        String controlXml = "<a><b>Test Value</b><c><![CDATA[ABC]]></c></a>";
        String testXml = "<a><b><![CDATA[Test Value]]></b><c>ABC</c></a>";
        XmlAssert.assertThat((Object)testXml).and((Object)controlXml).withComparisonListeners(new ComparisonListener[]{comparisonListener}).areSimilar();
        XmlAssert.assertThat((Object)comparisonListener.similars).isEqualTo((Object)2);
    }

    private final class IgnoreAttributeValueEvaluator
    implements DifferenceEvaluator {
        private final String attributeName;

        public IgnoreAttributeValueEvaluator(String attributeName) {
            this.attributeName = attributeName;
        }

        public ComparisonResult evaluate(Comparison comparison, ComparisonResult outcome) {
            Attr attr;
            Node controlNode = comparison.getControlDetails().getTarget();
            if (comparison.getType() == ComparisonType.ATTR_VALUE && controlNode instanceof Attr && (attr = (Attr)controlNode).getName().equals(this.attributeName)) {
                return ComparisonResult.SIMILAR;
            }
            return outcome;
        }
    }

    private final class IgnoreEntryEvaluator
    implements DifferenceEvaluator {
        private IgnoreEntryEvaluator() {
        }

        public ComparisonResult evaluate(Comparison comparison, ComparisonResult outcome) {
            Element elem;
            Node controlNode = comparison.getControlDetails().getTarget();
            if (controlNode instanceof Element && (elem = (Element)controlNode).getTagName().toLowerCase().contains("entry")) {
                return ComparisonResult.SIMILAR;
            }
            return outcome;
        }
    }

    private final class StopAfterNode
    implements ComparisonController {
        private final String nodeName;

        private StopAfterNode(String nodeName) {
            this.nodeName = nodeName;
        }

        public boolean stopDiffing(Difference difference) {
            ComparisonType type = difference.getComparison().getType();
            if (type == ComparisonType.ELEMENT_TAG_NAME) {
                String valueControl = (String)difference.getComparison().getControlDetails().getValue();
                String valueTest = (String)difference.getComparison().getTestDetails().getValue();
                return this.nodeName.equals(valueTest) || this.nodeName.equals(valueControl);
            }
            return false;
        }
    }

    private final class SimilarityComparisonListener
    implements ComparisonListener {
        private int similars;

        private SimilarityComparisonListener() {
        }

        public void comparisonPerformed(Comparison comparison, ComparisonResult outcome) {
            switch (outcome) {
                case SIMILAR: {
                    ++this.similars;
                }
            }
        }
    }
}

